/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.segment.realtime.firehose.SqlFirehose;
import org.apache.druid.segment.transform.ExpressionTransform;
import org.apache.druid.segment.transform.TransformSpec;
import org.apache.druid.segment.transform.TransformingStringInputRowParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlFirehoseTest {
    private static final TypeReference<Map<String, Object>> TYPE_REF = new TypeReference<Map<String, Object>>(){};
    private static File TEST_DIR;
    private List<Map<String, Object>> inputs;
    private List<FileInputStream> fileList;
    private InputRowParser parser;
    private ObjectMapper objectMapper;

    @Before
    public void setup() throws IOException {
        TEST_DIR = File.createTempFile(SqlFirehose.class.getSimpleName(), "testDir");
        FileUtils.forceDelete((File)TEST_DIR);
        org.apache.druid.java.util.common.FileUtils.mkdirp((File)TEST_DIR);
        ImmutableList inputTexts = ImmutableList.of((Object)ImmutableMap.of((Object)"x", (Object)"foostring1", (Object)"timestamp", (Object)2000), (Object)ImmutableMap.of((Object)"x", (Object)"foostring2", (Object)"timestamp", (Object)2000));
        ArrayList<FileInputStream> testFile = new ArrayList<FileInputStream>();
        this.objectMapper = new ObjectMapper((JsonFactory)new SmileFactory());
        int i = 0;
        for (Map m : inputTexts) {
            File file = new File(TEST_DIR, "test_" + i++);
            FileOutputStream fos = new FileOutputStream(file);
            Throwable throwable = null;
            try {
                JsonGenerator jg = this.objectMapper.getFactory().createGenerator((OutputStream)fos);
                jg.writeStartArray();
                jg.writeObject((Object)m);
                jg.writeEndArray();
                jg.close();
                testFile.add(new FileInputStream(file));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fos == null) continue;
                if (throwable != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fos.close();
            }
        }
        this.fileList = testFile;
        this.parser = TransformSpec.NONE.decorate((InputRowParser)new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"x"))))));
        this.inputs = inputTexts;
    }

    @Test
    public void testFirehose() throws Exception {
        TestCloseable closeable = new TestCloseable();
        ArrayList<Object> expectedResults = new ArrayList<Object>();
        for (Map<String, Object> map : this.inputs) {
            expectedResults.add(map.get("x"));
        }
        List lineIterators = this.fileList.stream().map(s -> new JsonIterator(TYPE_REF, (InputStream)s, (Closeable)closeable, this.objectMapper)).collect(Collectors.toList());
        try (SqlFirehose firehose = new SqlFirehose(lineIterators.iterator(), this.parser, (Closeable)closeable);){
            ArrayList results = new ArrayList();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (inputRow == null) {
                    results.add(null);
                    continue;
                }
                results.add(inputRow.getDimension("x").get(0));
            }
            Assert.assertEquals(expectedResults, results);
        }
    }

    @Test
    public void testFirehoseStringParser() throws Exception {
        TestCloseable closeable = new TestCloseable();
        ArrayList<Object> expectedResults = new ArrayList<Object>();
        for (Map<String, Object> map : this.inputs) {
            expectedResults.add(map.get("x"));
        }
        List lineIterators = this.fileList.stream().map(s -> new JsonIterator(TYPE_REF, (InputStream)s, (Closeable)closeable, this.objectMapper)).collect(Collectors.toList());
        InputRowParser stringParser = TransformSpec.NONE.decorate((InputRowParser)new StringInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"x")))), Charset.defaultCharset().name()));
        try (SqlFirehose firehose = new SqlFirehose(lineIterators.iterator(), stringParser, (Closeable)closeable);){
            ArrayList results = new ArrayList();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (inputRow == null) {
                    results.add(null);
                    continue;
                }
                results.add(inputRow.getDimension("x").get(0));
            }
            Assert.assertEquals(expectedResults, results);
        }
    }

    @Test
    public void testFirehoseTransformingParser() throws Exception {
        TestCloseable closeable = new TestCloseable();
        ArrayList<String> expectedResults = new ArrayList<String>();
        for (Map<String, Object> map : this.inputs) {
            expectedResults.add(map.get("x") + "foo");
        }
        List lineIterators = this.fileList.stream().map(s -> new JsonIterator(TYPE_REF, (InputStream)s, (Closeable)closeable, this.objectMapper)).collect(Collectors.toList());
        TransformingStringInputRowParser stringParser = new TransformingStringInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"x")))), Charset.defaultCharset().name(), new TransformSpec(null, (List)ImmutableList.of((Object)new ExpressionTransform("xfoo", "concat(x,'foo')", ExprMacroTable.nil()))));
        try (SqlFirehose firehose = new SqlFirehose(lineIterators.iterator(), (InputRowParser)stringParser, (Closeable)closeable);){
            ArrayList results = new ArrayList();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (inputRow == null) {
                    results.add(null);
                    continue;
                }
                results.add(inputRow.getDimension("xfoo").get(0));
            }
            Assert.assertEquals(expectedResults, results);
        }
    }

    @Test
    public void testClose() throws IOException {
        File file = File.createTempFile("test", "", TEST_DIR);
        TestCloseable closeable = new TestCloseable();
        try (FileOutputStream fos = new FileOutputStream(file);){
            JsonGenerator jg = this.objectMapper.getFactory().createGenerator((OutputStream)fos);
            jg.writeStartArray();
            jg.writeEndArray();
            jg.close();
        }
        JsonIterator jsonIterator = new JsonIterator(TYPE_REF, (InputStream)new FileInputStream(file), (Closeable)closeable, this.objectMapper);
        SqlFirehose firehose = new SqlFirehose((Iterator)ImmutableList.of((Object)jsonIterator).iterator(), this.parser, (Closeable)closeable);
        firehose.hasMore();
        firehose.close();
        Assert.assertTrue((boolean)closeable.closed);
    }

    @After
    public void teardown() throws IOException {
        FileUtils.forceDelete((File)TEST_DIR);
    }

    private static final class TestCloseable
    implements Closeable {
        private boolean closed;

        private TestCloseable() {
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

