/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.SegmentLazyLoadFailCallback;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.loading.CacheTestSegmentCacheManager;
import org.apache.druid.segment.loading.CacheTestSegmentLoader;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoader;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.StorageLocationConfig;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.SegmentChangeRequestDrop;
import org.apache.druid.server.coordination.SegmentChangeRequestLoad;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordination.TestStorageLocation;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class SegmentLoadDropHandlerTest {
    public static final int COUNT = 50;
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private SegmentLoadDropHandler segmentLoadDropHandler;
    private DataSegmentAnnouncer announcer;
    private File infoDir;
    private TestStorageLocation testStorageLocation;
    private AtomicInteger announceCount;
    private ConcurrentSkipListSet<DataSegment> segmentsAnnouncedByMe;
    private CacheTestSegmentCacheManager segmentCacheManager;
    private SegmentLoader segmentLoader;
    private SegmentManager segmentManager;
    private List<Runnable> scheduledRunnable;
    private SegmentLoaderConfig segmentLoaderConfig;
    private SegmentLoaderConfig noAnnouncerSegmentLoaderConfig;
    private SegmentLoaderConfig segmentLoaderConfigNoLocations;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private List<StorageLocationConfig> locations;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    public SegmentLoadDropHandlerTest() {
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
    }

    @Before
    public void setUp() throws IOException {
        try {
            this.testStorageLocation = new TestStorageLocation(this.temporaryFolder);
            this.infoDir = this.testStorageLocation.getInfoDir();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.locations = Collections.singletonList(this.testStorageLocation.toStorageLocationConfig());
        this.scheduledRunnable = new ArrayList<Runnable>();
        this.segmentCacheManager = new CacheTestSegmentCacheManager();
        this.segmentLoader = new CacheTestSegmentLoader();
        this.segmentManager = new SegmentManager(this.segmentLoader);
        this.segmentsAnnouncedByMe = new ConcurrentSkipListSet();
        this.announceCount = new AtomicInteger(0);
        this.announcer = new DataSegmentAnnouncer(){

            public void announceSegment(DataSegment segment) {
                SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.add(segment);
                SegmentLoadDropHandlerTest.this.announceCount.incrementAndGet();
            }

            public void unannounceSegment(DataSegment segment) {
                SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.remove(segment);
                SegmentLoadDropHandlerTest.this.announceCount.decrementAndGet();
            }

            public void announceSegments(Iterable<DataSegment> segments) {
                for (DataSegment segment : segments) {
                    SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.add(segment);
                }
                SegmentLoadDropHandlerTest.this.announceCount.addAndGet(Iterables.size(segments));
            }

            public void unannounceSegments(Iterable<DataSegment> segments) {
                for (DataSegment segment : segments) {
                    SegmentLoadDropHandlerTest.this.segmentsAnnouncedByMe.remove(segment);
                }
                SegmentLoadDropHandlerTest.this.announceCount.addAndGet(-Iterables.size(segments));
            }
        };
        this.segmentLoaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.testStorageLocation.getInfoDir();
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public List<StorageLocationConfig> getLocations() {
                return SegmentLoadDropHandlerTest.this.locations;
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        };
        this.noAnnouncerSegmentLoaderConfig = new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.testStorageLocation.getInfoDir();
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 0;
            }

            public List<StorageLocationConfig> getLocations() {
                return SegmentLoadDropHandlerTest.this.locations;
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        };
        this.segmentLoaderConfigNoLocations = new SegmentLoaderConfig(){

            public int getNumLoadingThreads() {
                return 5;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }

            public int getDropSegmentDelayMillis() {
                return 0;
            }
        };
        this.scheduledExecutorFactory = new ScheduledExecutorFactory(){

            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return new ScheduledThreadPoolExecutor(corePoolSize, Execs.makeThreadFactory((String)nameFormat)){

                    @Override
                    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
                        SegmentLoadDropHandlerTest.this.scheduledRunnable.add(command);
                        return null;
                    }
                };
            }
        };
        this.segmentLoadDropHandler = new SegmentLoadDropHandler(this.jsonMapper, this.segmentLoaderConfig, this.announcer, (DataSegmentServerAnnouncer)Mockito.mock(DataSegmentServerAnnouncer.class), this.segmentManager, (SegmentCacheManager)this.segmentCacheManager, this.scheduledExecutorFactory.create(5, "SegmentLoadDropHandlerTest-[%d]"), new ServerTypeConfig(ServerType.HISTORICAL));
    }

    @Test
    public void testSegmentLoading1() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment = this.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.segmentLoadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)this.segmentCacheManager.getSegmentsInTrash().contains(segment));
        this.segmentLoadDropHandler.stop();
    }

    @Test
    public void testSegmentLoading2() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment = this.makeSegment("test", "1", Intervals.of((String)"P1d/2011-04-01"));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP);
        Assert.assertFalse((boolean)this.segmentsAnnouncedByMe.contains(segment));
        this.segmentLoadDropHandler.addSegment(segment, DataSegmentChangeCallback.NOOP);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        Assert.assertTrue((boolean)this.segmentsAnnouncedByMe.contains(segment));
        Assert.assertFalse((String)"segment files shouldn't be deleted", (boolean)this.segmentCacheManager.getSegmentsInTrash().contains(segment));
        this.segmentLoadDropHandler.stop();
    }

    @Test
    public void testLoadCache() throws Exception {
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-03")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-04")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-05")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T01")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T03")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T05")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"PT1h/2011-04-04T06")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        for (DataSegment segment : segments) {
            this.testStorageLocation.writeSegmentInfoToCache(segment);
        }
        this.testStorageLocation.checkInfoCache(segments);
        Assert.assertTrue((boolean)this.segmentManager.getDataSourceCounts().isEmpty());
        this.segmentLoadDropHandler.start();
        Assert.assertTrue((!this.segmentManager.getDataSourceCounts().isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)11L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((long)650L, (long)this.announceCount.get());
        this.segmentLoadDropHandler.stop();
        for (DataSegment segment : segments) {
            this.testStorageLocation.deleteSegmentInfoFromCache(segment);
        }
        Assert.assertEquals((long)0L, (long)this.infoDir.listFiles().length);
        Assert.assertTrue((boolean)this.infoDir.delete());
    }

    private DataSegment makeSegment(String dataSource, String version, Interval interval) {
        return new DataSegment(dataSource, interval, version, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"interval", (Object)interval, (Object)"cacheDir", (Object)this.infoDir), Arrays.asList("dim1", "dim2", "dim3"), Arrays.asList("metric1", "metric2"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 123L);
    }

    @Test
    public void testStartStop() throws Exception {
        SegmentLoadDropHandler handler = new SegmentLoadDropHandler(this.jsonMapper, new SegmentLoaderConfig(){

            public File getInfoDir() {
                return SegmentLoadDropHandlerTest.this.infoDir;
            }

            public int getNumLoadingThreads() {
                return 5;
            }

            public List<StorageLocationConfig> getLocations() {
                return SegmentLoadDropHandlerTest.this.locations;
            }

            public int getAnnounceIntervalMillis() {
                return 50;
            }
        }, this.announcer, (DataSegmentServerAnnouncer)Mockito.mock(DataSegmentServerAnnouncer.class), this.segmentManager, (SegmentCacheManager)this.segmentCacheManager, new ServerTypeConfig(ServerType.HISTORICAL));
        HashSet<DataSegment> segments = new HashSet<DataSegment>();
        for (int i = 0; i < 50; ++i) {
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test" + i, "2", Intervals.of((String)"P1d/2011-04-02")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-01")));
            segments.add(this.makeSegment("test_two" + i, "1", Intervals.of((String)"P1d/2011-04-02")));
        }
        for (DataSegment segment : segments) {
            this.testStorageLocation.writeSegmentInfoToCache(segment);
        }
        this.testStorageLocation.checkInfoCache(segments);
        Assert.assertTrue((boolean)this.segmentManager.getDataSourceCounts().isEmpty());
        handler.start();
        Assert.assertTrue((!this.segmentManager.getDataSourceCounts().isEmpty() ? 1 : 0) != 0);
        for (int i = 0; i < 50; ++i) {
            Assert.assertEquals((long)3L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test" + i)));
            Assert.assertEquals((long)2L, (long)((Long)this.segmentManager.getDataSourceCounts().get("test_two" + i)));
        }
        Assert.assertEquals((long)250L, (long)this.announceCount.get());
        handler.stop();
        for (DataSegment segment : segments) {
            this.testStorageLocation.deleteSegmentInfoFromCache(segment);
        }
        Assert.assertEquals((long)0L, (long)this.infoDir.listFiles().length);
        Assert.assertTrue((boolean)this.infoDir.delete());
    }

    @Test(timeout=60000L)
    public void testProcessBatch() throws Exception {
        this.segmentLoadDropHandler.start();
        DataSegment segment1 = this.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        DataSegment segment2 = this.makeSegment("batchtest2", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1), (Object)new SegmentChangeRequestDrop(segment2));
        ListenableFuture future = this.segmentLoadDropHandler.processBatch((List)batch);
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.PENDING, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus());
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(1)).getStatus());
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)this.segmentLoadDropHandler.processBatch((List)ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1))).get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus());
        this.segmentLoadDropHandler.stop();
    }

    @Test(timeout=60000L)
    public void testProcessBatchDuplicateLoadRequestsWhenFirstRequestFailsSecondRequestShouldSucceed() throws Exception {
        SegmentManager segmentManager = (SegmentManager)Mockito.mock(SegmentManager.class);
        Mockito.when((Object)segmentManager.loadSegment((DataSegment)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (SegmentLazyLoadFailCallback)ArgumentMatchers.any(), (ExecutorService)ArgumentMatchers.any())).thenThrow(new Throwable[]{new RuntimeException("segment loading failure test")}).thenReturn((Object)true);
        SegmentLoadDropHandler segmentLoadDropHandler = new SegmentLoadDropHandler(this.jsonMapper, this.segmentLoaderConfig, this.announcer, (DataSegmentServerAnnouncer)Mockito.mock(DataSegmentServerAnnouncer.class), segmentManager, (SegmentCacheManager)this.segmentCacheManager, this.scheduledExecutorFactory.create(5, "SegmentLoadDropHandlerTest-[%d]"), new ServerTypeConfig(ServerType.HISTORICAL));
        segmentLoadDropHandler.start();
        DataSegment segment1 = this.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        ListenableFuture future = segmentLoadDropHandler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.STATE.FAILED, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus().getState());
        future = segmentLoadDropHandler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.STATE.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus().getState());
        segmentLoadDropHandler.stop();
    }

    @Test(timeout=60000L)
    public void testProcessBatchLoadDropLoadSequenceForSameSegment() throws Exception {
        SegmentManager segmentManager = (SegmentManager)Mockito.mock(SegmentManager.class);
        Mockito.when((Object)segmentManager.loadSegment((DataSegment)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (SegmentLazyLoadFailCallback)ArgumentMatchers.any(), (ExecutorService)ArgumentMatchers.any())).thenReturn((Object)true);
        ((SegmentManager)Mockito.doNothing().when((Object)segmentManager)).dropSegment((DataSegment)ArgumentMatchers.any());
        SegmentLoadDropHandler segmentLoadDropHandler = new SegmentLoadDropHandler(this.jsonMapper, this.noAnnouncerSegmentLoaderConfig, this.announcer, (DataSegmentServerAnnouncer)Mockito.mock(DataSegmentServerAnnouncer.class), segmentManager, (SegmentCacheManager)this.segmentCacheManager, this.scheduledExecutorFactory.create(5, "SegmentLoadDropHandlerTest-[%d]"), new ServerTypeConfig(ServerType.HISTORICAL));
        segmentLoadDropHandler.start();
        DataSegment segment1 = this.makeSegment("batchtest1", "1", Intervals.of((String)"P1d/2011-04-01"));
        ImmutableList batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        ListenableFuture future = segmentLoadDropHandler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        List result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.STATE.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus().getState());
        this.scheduledRunnable.clear();
        batch = ImmutableList.of((Object)new SegmentChangeRequestDrop(segment1));
        future = segmentLoadDropHandler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.STATE.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus().getState());
        this.scheduledRunnable.clear();
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).loadSegment((DataSegment)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (SegmentLazyLoadFailCallback)ArgumentMatchers.any(), (ExecutorService)ArgumentMatchers.any());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).dropSegment((DataSegment)ArgumentMatchers.any());
        batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        future = segmentLoadDropHandler.processBatch((List)batch);
        Assert.assertEquals((long)this.scheduledRunnable.size(), (long)0L);
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.STATE.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus().getState());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).loadSegment((DataSegment)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (SegmentLazyLoadFailCallback)ArgumentMatchers.any(), (ExecutorService)ArgumentMatchers.any());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).dropSegment((DataSegment)ArgumentMatchers.any());
        batch = ImmutableList.of((Object)new SegmentChangeRequestLoad(segment1));
        future = segmentLoadDropHandler.processBatch((List)batch);
        for (Runnable runnable : this.scheduledRunnable) {
            runnable.run();
        }
        result = (List)future.get();
        Assert.assertEquals((Object)SegmentLoadDropHandler.Status.STATE.SUCCESS, (Object)((SegmentLoadDropHandler.DataSegmentChangeRequestAndStatus)result.get(0)).getStatus().getState());
        this.scheduledRunnable.clear();
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)2))).loadSegment((DataSegment)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), (SegmentLazyLoadFailCallback)ArgumentMatchers.any(), (ExecutorService)ArgumentMatchers.any());
        ((SegmentManager)Mockito.verify((Object)segmentManager, (VerificationMode)Mockito.times((int)1))).dropSegment((DataSegment)ArgumentMatchers.any());
        segmentLoadDropHandler.stop();
    }
}

