/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListeningExecutorService;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.curator.framework.api.ChildrenDeletable;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.druid.client.BatchServerInventoryView;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.DruidDataSource;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.curator.CuratorTestBase;
import org.apache.druid.curator.CuratorUtils;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.curator.discovery.NoopServiceAnnouncer;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.metadata.MetadataRuleManager;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.BalancerStrategyFactory;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.CostBalancerStrategyFactory;
import org.apache.druid.server.coordinator.CuratorLoadQueuePeon;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.LoadPeonCallback;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.CompactSegments;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroup;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDutyGroups;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.EmitClusterStatsAndMetrics;
import org.apache.druid.server.coordinator.duty.KillSupervisorsCustomDuty;
import org.apache.druid.server.coordinator.duty.LogUsedSegments;
import org.apache.druid.server.coordinator.rules.ForeverBroadcastDistributionRule;
import org.apache.druid.server.coordinator.rules.ForeverLoadRule;
import org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.druid.server.initialization.ZkPathsConfig;
import org.apache.druid.server.lookup.cache.LookupCoordinatorManager;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidCoordinatorTest
extends CuratorTestBase {
    private static final String LOADPATH = "/druid/loadqueue/localhost:1234";
    private static final long COORDINATOR_START_DELAY = 1L;
    private static final long COORDINATOR_PERIOD = 100L;
    private DruidCoordinator coordinator;
    private SegmentsMetadataManager segmentsMetadataManager;
    private DataSourcesSnapshot dataSourcesSnapshot;
    private DruidCoordinatorRuntimeParams coordinatorRuntimeParams;
    private BatchServerInventoryView serverInventoryView;
    private ScheduledExecutorFactory scheduledExecutorFactory;
    private DruidServer druidServer;
    private ConcurrentMap<String, LoadQueuePeon> loadManagementPeons;
    private LoadQueuePeon loadQueuePeon;
    private MetadataRuleManager metadataRuleManager;
    private CountDownLatch leaderAnnouncerLatch;
    private CountDownLatch leaderUnannouncerLatch;
    private PathChildrenCache pathChildrenCache;
    private DruidCoordinatorConfig druidCoordinatorConfig;
    private ObjectMapper objectMapper;
    private DruidNode druidNode;
    private LatchableServiceEmitter serviceEmitter = new LatchableServiceEmitter();

    @Before
    public void setUp() throws Exception {
        this.druidServer = (DruidServer)EasyMock.createMock(DruidServer.class);
        this.serverInventoryView = (BatchServerInventoryView)EasyMock.createMock(BatchServerInventoryView.class);
        this.segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createNiceMock(SegmentsMetadataManager.class);
        this.dataSourcesSnapshot = (DataSourcesSnapshot)EasyMock.createNiceMock(DataSourcesSnapshot.class);
        this.coordinatorRuntimeParams = (DruidCoordinatorRuntimeParams)EasyMock.createNiceMock(DruidCoordinatorRuntimeParams.class);
        this.metadataRuleManager = (MetadataRuleManager)EasyMock.createNiceMock(MetadataRuleManager.class);
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorCompactionConfig>(CoordinatorCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        this.setupServerAndCurator();
        this.curator.start();
        this.curator.blockUntilConnected();
        this.curator.create().creatingParentsIfNeeded().forPath(LOADPATH);
        this.objectMapper = new DefaultObjectMapper();
        this.druidCoordinatorConfig = new TestDruidCoordinatorConfig(new Duration(1L), new Duration(100L), null, null, null, new Duration(100L), null, null, null, null, null, null, null, null, null, null, 10, new Duration((Object)"PT0s"));
        this.pathChildrenCache = new PathChildrenCache(this.curator, LOADPATH, true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache-%d"));
        this.loadQueuePeon = new CuratorLoadQueuePeon(this.curator, LOADPATH, this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon-%d"), this.druidCoordinatorConfig);
        this.loadQueuePeon.start();
        this.druidNode = new DruidNode("hey", "what", false, Integer.valueOf(1234), null, true, false);
        this.loadManagementPeons = new ConcurrentHashMap<String, LoadQueuePeon>();
        this.scheduledExecutorFactory = new ScheduledExecutorFactory(){

            public ScheduledExecutorService create(int corePoolSize, String nameFormat) {
                return Executors.newSingleThreadScheduledExecutor();
            }
        };
        this.leaderAnnouncerLatch = new CountDownLatch(1);
        this.leaderUnannouncerLatch = new CountDownLatch(1);
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, configManager, this.segmentsMetadataManager, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, null, new HashSet(), new CoordinatorCustomDutyGroups((Set)ImmutableSet.of()), (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
    }

    @After
    public void tearDown() throws Exception {
        this.loadQueuePeon.stop();
        this.pathChildrenCache.close();
        this.tearDownServerAndCurator();
    }

    @Test
    public void testMoveSegment() {
        DataSegment segment = (DataSegment)EasyMock.createNiceMock(DataSegment.class);
        EasyMock.expect((Object)segment.getId()).andReturn((Object)SegmentId.dummy((String)"dummySegment"));
        EasyMock.expect((Object)segment.getDataSource()).andReturn((Object)"dummyDataSource");
        EasyMock.replay((Object[])new Object[]{segment});
        this.loadQueuePeon = (LoadQueuePeon)EasyMock.createNiceMock(LoadQueuePeon.class);
        EasyMock.expect((Object)this.loadQueuePeon.getLoadQueueSize()).andReturn((Object)new Long(1L));
        this.loadQueuePeon.markSegmentToDrop(segment);
        EasyMock.expectLastCall().once();
        Capture loadCallbackCapture = Capture.newInstance();
        Capture dropCallbackCapture = Capture.newInstance();
        this.loadQueuePeon.loadSegment((DataSegment)EasyMock.anyObject(DataSegment.class), (LoadPeonCallback)EasyMock.capture((Capture)loadCallbackCapture));
        EasyMock.expectLastCall().once();
        this.loadQueuePeon.dropSegment((DataSegment)EasyMock.anyObject(DataSegment.class), (LoadPeonCallback)EasyMock.capture((Capture)dropCallbackCapture));
        EasyMock.expectLastCall().once();
        this.loadQueuePeon.unmarkSegmentToDrop(segment);
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)this.loadQueuePeon.getSegmentsToDrop()).andReturn(new HashSet()).once();
        EasyMock.replay((Object[])new Object[]{this.loadQueuePeon});
        ImmutableDruidDataSource druidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)druidDataSource.getSegment((SegmentId)EasyMock.anyObject(SegmentId.class))).andReturn((Object)segment);
        EasyMock.replay((Object[])new Object[]{druidDataSource});
        EasyMock.expect((Object)this.segmentsMetadataManager.getImmutableDataSourceWithUsedSegments(EasyMock.anyString())).andReturn((Object)druidDataSource);
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSource(EasyMock.anyString())).andReturn((Object)druidDataSource).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
        this.scheduledExecutorFactory = (ScheduledExecutorFactory)EasyMock.createNiceMock(ScheduledExecutorFactory.class);
        EasyMock.replay((Object[])new Object[]{this.scheduledExecutorFactory});
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        ImmutableDruidDataSource dataSource = (ImmutableDruidDataSource)EasyMock.createMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)dataSource.getSegments()).andReturn(Collections.singletonList(segment)).anyTimes();
        EasyMock.replay((Object[])new Object[]{dataSource});
        EasyMock.expect((Object)this.druidServer.toImmutableDruidServer()).andReturn((Object)new ImmutableDruidServer(new DruidServerMetadata("from", null, null, 5L, ServerType.HISTORICAL, null, 0), 1L, ImmutableMap.of((Object)"dummyDataSource", (Object)dataSource), 1)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{this.druidServer});
        DruidServer druidServer2 = (DruidServer)EasyMock.createMock(DruidServer.class);
        EasyMock.expect((Object)druidServer2.toImmutableDruidServer()).andReturn((Object)new ImmutableDruidServer(new DruidServerMetadata("to", null, null, 5L, ServerType.HISTORICAL, null, 0), 1L, ImmutableMap.of((Object)"dummyDataSource", (Object)dataSource), 1)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{druidServer2});
        this.loadManagementPeons.put("from", this.loadQueuePeon);
        this.loadManagementPeons.put("to", this.loadQueuePeon);
        EasyMock.expect((Object)this.serverInventoryView.isSegmentLoadedByServer("to", segment)).andReturn((Object)true).once();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        this.mockCoordinatorRuntimeParams();
        this.coordinator.moveSegment(this.coordinatorRuntimeParams, this.druidServer.toImmutableDruidServer(), druidServer2.toImmutableDruidServer(), segment, null);
        LoadPeonCallback loadCallback = (LoadPeonCallback)loadCallbackCapture.getValue();
        loadCallback.execute();
        LoadPeonCallback dropCallback = (LoadPeonCallback)dropCallbackCapture.getValue();
        dropCallback.execute();
        EasyMock.verify((Object[])new Object[]{this.druidServer, druidServer2, this.loadQueuePeon, this.serverInventoryView, this.metadataRuleManager});
        EasyMock.verify((Object[])new Object[]{this.coordinatorRuntimeParams});
    }

    private void mockCoordinatorRuntimeParams() {
        EasyMock.expect((Object)this.coordinatorRuntimeParams.getDataSourcesSnapshot()).andReturn((Object)this.dataSourcesSnapshot).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.coordinatorRuntimeParams});
    }

    @Test(timeout=60000L)
    public void testCoordinatorRun() throws Exception {
        String dataSource = "dataSource1";
        String tier = "hot";
        ForeverLoadRule foreverLoadRule = new ForeverLoadRule((Map)ImmutableMap.of((Object)tier, (Object)2));
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)foreverLoadRule)).atLeastOnce();
        EasyMock.expect((Object)this.metadataRuleManager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)dataSource, (Object)ImmutableList.of((Object)foreverLoadRule))).atLeastOnce();
        this.metadataRuleManager.stop();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager});
        DruidDataSource[] dataSources = new DruidDataSource[]{new DruidDataSource(dataSource, Collections.emptyMap())};
        DataSegment dataSegment = new DataSegment(dataSource, Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSources[0].addSegment(dataSegment);
        this.setupSegmentsMetadataMock(dataSources[0]);
        ImmutableDruidDataSource immutableDruidDataSource = (ImmutableDruidDataSource)EasyMock.createNiceMock(ImmutableDruidDataSource.class);
        EasyMock.expect((Object)immutableDruidDataSource.getSegments()).andReturn((Object)ImmutableSet.of((Object)dataSegment)).atLeastOnce();
        EasyMock.replay((Object[])new Object[]{immutableDruidDataSource});
        this.druidServer = new DruidServer("server1", "localhost", null, 5L, ServerType.HISTORICAL, tier, 0);
        this.loadManagementPeons.put("server1", this.loadQueuePeon);
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)this.druidServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        Assert.assertTrue((boolean)this.coordinator.isLeader());
        Assert.assertEquals((Object)this.druidNode.getHostAndPort(), (Object)this.coordinator.getCurrentLeader());
        this.pathChildrenCache.start();
        CountDownLatch assignSegmentLatch = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(1, this.pathChildrenCache, (Map<String, DataSegment>)ImmutableMap.of((Object)"2010-01-01T00:00:00.000Z_2010-01-02T00:00:00.000Z", (Object)dataSegment), this.druidServer);
        assignSegmentLatch.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)dataSource, (Object)100.0), (Object)this.coordinator.getLoadStatus());
        Object2IntMap numsUnavailableUsedSegmentsPerDataSource = this.coordinator.computeNumsUnavailableUsedSegmentsPerDataSource();
        Assert.assertEquals((long)1L, (long)numsUnavailableUsedSegmentsPerDataSource.size());
        Assert.assertEquals((long)0L, (long)numsUnavailableUsedSegmentsPerDataSource.getInt((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTier();
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSource = (Object2LongMap)underReplicationCountsPerDataSourcePerTier.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSource.get((Object)dataSource));
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSource.getLong((Object)dataSource));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTierUsingClusterView();
        Assert.assertNotNull((Object)underReplicationCountsPerDataSourcePerTier);
        Assert.assertEquals((long)1L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Object2LongMap underRepliicationCountsPerDataSourceUsingClusterView = (Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get(tier);
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceUsingClusterView);
        Assert.assertEquals((long)1L, (long)underRepliicationCountsPerDataSourceUsingClusterView.size());
        Assert.assertNotNull((Object)underRepliicationCountsPerDataSourceUsingClusterView.get((Object)dataSource));
        Assert.assertEquals((long)0L, (long)underRepliicationCountsPerDataSourceUsingClusterView.getLong((Object)dataSource));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        Assert.assertFalse((boolean)this.coordinator.isLeader());
        Assert.assertNull((Object)this.coordinator.getCurrentLeader());
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testCoordinatorTieredRun() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        IntervalLoadRule hotTier = new IntervalLoadRule(Intervals.of((String)"2018-01-01/P1M"), (Map)ImmutableMap.of((Object)"hot", (Object)1));
        ForeverLoadRule coldTier = new ForeverLoadRule((Map)ImmutableMap.of((Object)"cold", (Object)1));
        String loadPathCold = "/druid/loadqueue/cold:1234";
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        ImmutableMap dataSegments = ImmutableMap.of((Object)"2018-01-02T00:00:00.000Z_2018-01-03T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2018-01-03T00:00:00.000Z_2018-01-04T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2017-01-01T00:00:00.000Z_2017-01-02T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        CuratorLoadQueuePeon loadQueuePeonCold = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/cold:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_cold_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_cold-%d"), this.druidCoordinatorConfig);
        PathChildrenCache pathChildrenCacheCold = new PathChildrenCache(this.curator, "/druid/loadqueue/cold:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_cold-%d"));
        this.loadManagementPeons.putAll((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)this.loadQueuePeon, (Object)"cold", (Object)loadQueuePeonCold));
        loadQueuePeonCold.start();
        this.pathChildrenCache.start();
        pathChildrenCacheCold.start();
        DruidDataSource[] druidDataSources = new DruidDataSource[]{new DruidDataSource("dataSource", Collections.emptyMap())};
        dataSegments.values().forEach(arg_0 -> ((DruidDataSource)druidDataSources[0]).addSegment(arg_0));
        this.setupSegmentsMetadataMock(druidDataSources[0]);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)hotTier, (Object)coldTier)).atLeastOnce();
        EasyMock.expect((Object)this.metadataRuleManager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)"dataSource", (Object)ImmutableList.of((Object)hotTier, (Object)coldTier))).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        CountDownLatch assignSegmentLatchHot = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(2, this.pathChildrenCache, (Map<String, DataSegment>)dataSegments, hotServer);
        CountDownLatch assignSegmentLatchCold = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(1, pathChildrenCacheCold, (Map<String, DataSegment>)dataSegments, coldServer);
        assignSegmentLatchHot.await();
        assignSegmentLatchCold.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getLoadStatus());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTier();
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTierUsingClusterView();
        Assert.assertEquals((long)2L, (long)underReplicationCountsPerDataSourcePerTierUsingClusterView.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("cold")).getLong((Object)"dataSource"));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test(timeout=60000L)
    public void testComputeUnderReplicationCountsPerDataSourcePerTierForSegmentsWithBroadcastRule() throws Exception {
        String dataSource = "dataSource";
        String hotTierName = "hot";
        String coldTierName = "cold";
        String tierName1 = "tier1";
        String tierName2 = "tier2";
        ForeverBroadcastDistributionRule broadcastDistributionRule = new ForeverBroadcastDistributionRule();
        String loadPathCold = "/druid/loadqueue/cold:1234";
        String loadPathBroker1 = "/druid/loadqueue/broker1:1234";
        String loadPathBroker2 = "/druid/loadqueue/broker2:1234";
        String loadPathPeon = "/druid/loadqueue/peon:1234";
        DruidServer hotServer = new DruidServer("hot", "hot", null, 5L, ServerType.HISTORICAL, "hot", 0);
        DruidServer coldServer = new DruidServer("cold", "cold", null, 5L, ServerType.HISTORICAL, "cold", 0);
        DruidServer brokerServer1 = new DruidServer("broker1", "broker1", null, 5L, ServerType.BROKER, "tier1", 0);
        DruidServer brokerServer2 = new DruidServer("broker2", "broker2", null, 5L, ServerType.BROKER, "tier2", 0);
        DruidServer peonServer = new DruidServer("peon", "peon", null, 5L, ServerType.INDEXER_EXECUTOR, "tier2", 0);
        ImmutableMap dataSegments = ImmutableMap.of((Object)"2018-01-02T00:00:00.000Z_2018-01-03T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-02/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2018-01-03T00:00:00.000Z_2018-01-04T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2018-01-03/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L), (Object)"2017-01-01T00:00:00.000Z_2017-01-02T00:00:00.000Z", (Object)new DataSegment("dataSource", Intervals.of((String)"2017-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L));
        CuratorLoadQueuePeon loadQueuePeonCold = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/cold:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_cold_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_cold-%d"), this.druidCoordinatorConfig);
        CuratorLoadQueuePeon loadQueuePeonBroker1 = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/broker1:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_broker1_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_broker1-%d"), this.druidCoordinatorConfig);
        CuratorLoadQueuePeon loadQueuePeonBroker2 = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/broker2:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_broker2_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_broker2-%d"), this.druidCoordinatorConfig);
        CuratorLoadQueuePeon loadQueuePeonPoenServer = new CuratorLoadQueuePeon(this.curator, "/druid/loadqueue/peon:1234", this.objectMapper, Execs.scheduledSingleThreaded((String)"coordinator_test_load_queue_peon_peon_scheduled-%d"), Execs.singleThreaded((String)"coordinator_test_load_queue_peon_peon-%d"), this.druidCoordinatorConfig);
        PathChildrenCache pathChildrenCacheCold = new PathChildrenCache(this.curator, "/druid/loadqueue/cold:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_cold-%d"));
        PathChildrenCache pathChildrenCacheBroker1 = new PathChildrenCache(this.curator, "/druid/loadqueue/broker1:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_broker1-%d"));
        PathChildrenCache pathChildrenCacheBroker2 = new PathChildrenCache(this.curator, "/druid/loadqueue/broker2:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_broker2-%d"));
        PathChildrenCache pathChildrenCachePeon = new PathChildrenCache(this.curator, "/druid/loadqueue/peon:1234", true, true, Execs.singleThreaded((String)"coordinator_test_path_children_cache_peon-%d"));
        this.loadManagementPeons.putAll((Map<String, LoadQueuePeon>)ImmutableMap.of((Object)"hot", (Object)this.loadQueuePeon, (Object)"cold", (Object)loadQueuePeonCold, (Object)"broker1", (Object)loadQueuePeonBroker1, (Object)"broker2", (Object)loadQueuePeonBroker2, (Object)"peon", (Object)loadQueuePeonPoenServer));
        loadQueuePeonCold.start();
        loadQueuePeonBroker1.start();
        loadQueuePeonBroker2.start();
        loadQueuePeonPoenServer.start();
        this.pathChildrenCache.start();
        pathChildrenCacheCold.start();
        pathChildrenCacheBroker1.start();
        pathChildrenCacheBroker2.start();
        pathChildrenCachePeon.start();
        DruidDataSource[] druidDataSources = new DruidDataSource[]{new DruidDataSource("dataSource", Collections.emptyMap())};
        dataSegments.values().forEach(arg_0 -> ((DruidDataSource)druidDataSources[0]).addSegment(arg_0));
        this.setupSegmentsMetadataMock(druidDataSources[0]);
        EasyMock.expect((Object)this.metadataRuleManager.getRulesWithDefault(EasyMock.anyString())).andReturn((Object)ImmutableList.of((Object)broadcastDistributionRule)).atLeastOnce();
        EasyMock.expect((Object)this.metadataRuleManager.getAllRules()).andReturn((Object)ImmutableMap.of((Object)"dataSource", (Object)ImmutableList.of((Object)broadcastDistributionRule))).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.getInventory()).andReturn((Object)ImmutableList.of((Object)hotServer, (Object)coldServer, (Object)brokerServer1, (Object)brokerServer2, (Object)peonServer)).atLeastOnce();
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.metadataRuleManager, this.serverInventoryView});
        this.coordinator.start();
        this.leaderAnnouncerLatch.await();
        CountDownLatch assignSegmentLatchHot = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, this.pathChildrenCache, (Map<String, DataSegment>)dataSegments, hotServer);
        CountDownLatch assignSegmentLatchCold = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCacheCold, (Map<String, DataSegment>)dataSegments, coldServer);
        CountDownLatch assignSegmentLatchBroker1 = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCacheBroker1, (Map<String, DataSegment>)dataSegments, brokerServer1);
        CountDownLatch assignSegmentLatchBroker2 = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCacheBroker2, (Map<String, DataSegment>)dataSegments, brokerServer2);
        CountDownLatch assignSegmentLatchPeon = this.createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(3, pathChildrenCachePeon, (Map<String, DataSegment>)dataSegments, peonServer);
        assignSegmentLatchHot.await();
        assignSegmentLatchCold.await();
        assignSegmentLatchBroker1.await();
        assignSegmentLatchBroker2.await();
        assignSegmentLatchPeon.await();
        CountDownLatch coordinatorRunLatch = new CountDownLatch(2);
        this.serviceEmitter.latch = coordinatorRunLatch;
        coordinatorRunLatch.await();
        Assert.assertEquals((Object)ImmutableMap.of((Object)"dataSource", (Object)100.0), (Object)this.coordinator.getLoadStatus());
        Map underReplicationCountsPerDataSourcePerTier = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTier();
        Assert.assertEquals((long)4L, (long)underReplicationCountsPerDataSourcePerTier.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("cold")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("tier1")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTier.get("tier2")).getLong((Object)"dataSource"));
        Map underReplicationCountsPerDataSourcePerTierUsingClusterView = this.coordinator.computeUnderReplicationCountsPerDataSourcePerTierUsingClusterView();
        Assert.assertEquals((long)4L, (long)underReplicationCountsPerDataSourcePerTierUsingClusterView.size());
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("hot")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("cold")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("tier1")).getLong((Object)"dataSource"));
        Assert.assertEquals((long)0L, (long)((Object2LongMap)underReplicationCountsPerDataSourcePerTierUsingClusterView.get("tier2")).getLong((Object)"dataSource"));
        this.coordinator.stop();
        this.leaderUnannouncerLatch.await();
        EasyMock.verify((Object[])new Object[]{this.serverInventoryView});
        EasyMock.verify((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.verify((Object[])new Object[]{this.metadataRuleManager});
    }

    @Test
    public void testBalancerThreadNumber() {
        DruidCoordinator c;
        CoordinatorDynamicConfig dynamicConfig = (CoordinatorDynamicConfig)EasyMock.createNiceMock(CoordinatorDynamicConfig.class);
        EasyMock.expect((Object)dynamicConfig.getBalancerComputeThreads()).andReturn((Object)5).times(2);
        EasyMock.expect((Object)dynamicConfig.getBalancerComputeThreads()).andReturn((Object)10).once();
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(dynamicConfig)).anyTimes();
        ScheduledExecutorFactory scheduledExecutorFactory = (ScheduledExecutorFactory)EasyMock.createNiceMock(ScheduledExecutorFactory.class);
        EasyMock.replay((Object[])new Object[]{configManager, dynamicConfig, scheduledExecutorFactory});
        DruidCoordinator druidCoordinator = c = new DruidCoordinator(this.druidCoordinatorConfig, null, configManager, null, null, null, () -> null, null, scheduledExecutorFactory, null, null, null, null, null, null, new CoordinatorCustomDutyGroups((Set)ImmutableSet.of()), null, null, null, null, ZkEnablementConfig.ENABLED);
        druidCoordinator.getClass();
        DruidCoordinator.DutiesRunnable duty = new DruidCoordinator.DutiesRunnable(druidCoordinator, Collections.emptyList(), 0, "TEST");
        Assert.assertEquals((long)0L, (long)c.getCachedBalancerThreadNumber());
        Assert.assertNull((Object)c.getBalancerExec());
        duty.initBalancerExecutor();
        System.out.println("c.getCachedBalancerThreadNumber(): " + c.getCachedBalancerThreadNumber());
        Assert.assertEquals((long)5L, (long)c.getCachedBalancerThreadNumber());
        ListeningExecutorService firstExec = c.getBalancerExec();
        Assert.assertNotNull((Object)firstExec);
        duty.initBalancerExecutor();
        Assert.assertEquals((long)5L, (long)c.getCachedBalancerThreadNumber());
        ListeningExecutorService secondExec = c.getBalancerExec();
        Assert.assertNotNull((Object)secondExec);
        Assert.assertTrue((firstExec == secondExec ? 1 : 0) != 0);
        duty.initBalancerExecutor();
        Assert.assertEquals((long)10L, (long)c.getCachedBalancerThreadNumber());
        ListeningExecutorService thirdExec = c.getBalancerExec();
        Assert.assertNotNull((Object)thirdExec);
        Assert.assertFalse((secondExec == thirdExec ? 1 : 0) != 0);
        Assert.assertFalse((firstExec == thirdExec ? 1 : 0) != 0);
    }

    @Test
    public void testCompactSegmentsDutyWhenCustomDutyGroupEmpty() {
        CoordinatorCustomDutyGroups emptyCustomDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of());
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, null, this.segmentsMetadataManager, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, (Set)ImmutableSet.of(), new HashSet(), emptyCustomDutyGroups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
        List indexingDuties = this.coordinator.makeIndexingServiceDuties();
        Assert.assertTrue((boolean)indexingDuties.stream().anyMatch(coordinatorDuty -> coordinatorDuty instanceof CompactSegments));
        List compactSegmentsDutyFromCustomGroups = this.coordinator.getCompactSegmentsDutyFromCustomGroups();
        Assert.assertTrue((boolean)compactSegmentsDutyFromCustomGroups.isEmpty());
        CompactSegments duty = this.coordinator.initializeCompactSegmentsDuty();
        Assert.assertNotNull((Object)duty);
        Assert.assertEquals((Object)this.druidCoordinatorConfig.getCompactionSkipLockedIntervals(), (Object)duty.isSkipLockedIntervals());
    }

    @Test
    public void testInitializeCompactSegmentsDutyWhenCustomDutyGroupDoesNotContainsCompactSegments() {
        CoordinatorCustomDutyGroup group = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), null)));
        CoordinatorCustomDutyGroups customDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)group));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, null, this.segmentsMetadataManager, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, (Set)ImmutableSet.of(), new HashSet(), customDutyGroups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
        List indexingDuties = this.coordinator.makeIndexingServiceDuties();
        Assert.assertTrue((boolean)indexingDuties.stream().anyMatch(coordinatorDuty -> coordinatorDuty instanceof CompactSegments));
        List compactSegmentsDutyFromCustomGroups = this.coordinator.getCompactSegmentsDutyFromCustomGroups();
        Assert.assertTrue((boolean)compactSegmentsDutyFromCustomGroups.isEmpty());
        CompactSegments duty = this.coordinator.initializeCompactSegmentsDuty();
        Assert.assertNotNull((Object)duty);
        Assert.assertEquals((Object)this.druidCoordinatorConfig.getCompactionSkipLockedIntervals(), (Object)duty.isSkipLockedIntervals());
    }

    @Test
    public void testInitializeCompactSegmentsDutyWhenCustomDutyGroupContainsCompactSegments() {
        TestDruidCoordinatorConfig differentConfigUsedInCustomGroup = new TestDruidCoordinatorConfig(new Duration(1L), new Duration(100L), null, null, null, new Duration(100L), null, null, null, null, null, null, null, null, null, null, 10, new Duration((Object)"PT0s"), false);
        CoordinatorCustomDutyGroup compactSegmentCustomGroup = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)new CompactSegments((DruidCoordinatorConfig)differentConfigUsedInCustomGroup, null, null)));
        CoordinatorCustomDutyGroups customDutyGroups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)compactSegmentCustomGroup));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, null, this.segmentsMetadataManager, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, (Set)ImmutableSet.of(), new HashSet(), customDutyGroups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
        List indexingDuties = this.coordinator.makeIndexingServiceDuties();
        Assert.assertTrue((boolean)indexingDuties.stream().noneMatch(coordinatorDuty -> coordinatorDuty instanceof CompactSegments));
        List compactSegmentsDutyFromCustomGroups = this.coordinator.getCompactSegmentsDutyFromCustomGroups();
        Assert.assertFalse((boolean)compactSegmentsDutyFromCustomGroups.isEmpty());
        Assert.assertEquals((long)1L, (long)compactSegmentsDutyFromCustomGroups.size());
        Assert.assertNotNull(compactSegmentsDutyFromCustomGroups.get(0));
        Assert.assertTrue((boolean)(compactSegmentsDutyFromCustomGroups.get(0) instanceof CompactSegments));
        CompactSegments duty = this.coordinator.initializeCompactSegmentsDuty();
        Assert.assertNotNull((Object)duty);
        Assert.assertNotEquals((Object)this.druidCoordinatorConfig.getCompactionSkipLockedIntervals(), (Object)duty.isSkipLockedIntervals());
        Assert.assertEquals((Object)differentConfigUsedInCustomGroup.getCompactionSkipLockedIntervals(), (Object)duty.isSkipLockedIntervals());
    }

    @Test(timeout=3000L)
    public void testCoordinatorCustomDutyGroupsRunAsExpected() throws Exception {
        JacksonConfigManager configManager = (JacksonConfigManager)EasyMock.createNiceMock(JacksonConfigManager.class);
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorDynamicConfig>(CoordinatorDynamicConfig.builder().build())).anyTimes();
        EasyMock.expect((Object)configManager.watch((String)EasyMock.eq((Object)"coordinator.compaction.config"), (Class)EasyMock.anyObject(Class.class), EasyMock.anyObject())).andReturn(new AtomicReference<CoordinatorCompactionConfig>(CoordinatorCompactionConfig.empty())).anyTimes();
        EasyMock.replay((Object[])new Object[]{configManager});
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        DruidDataSource dataSource = new DruidDataSource("dataSource1", Collections.emptyMap());
        DataSegment dataSegment = new DataSegment("dataSource1", Intervals.of((String)"2010-01-01/P1D"), "v1", null, null, null, null, Integer.valueOf(9), 0L);
        dataSource.addSegment(dataSegment);
        DataSourcesSnapshot dataSourcesSnapshot = new DataSourcesSnapshot((Map)ImmutableMap.of((Object)dataSource.getName(), (Object)dataSource.toImmutableDruidDataSource()));
        EasyMock.expect((Object)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.expect((Object)this.serverInventoryView.isStarted()).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.serverInventoryView});
        final CountDownLatch latch1 = new CountDownLatch(1);
        CoordinatorCustomDuty duty1 = new CoordinatorCustomDuty(){

            public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
                latch1.countDown();
                return params;
            }
        };
        CoordinatorCustomDutyGroup group1 = new CoordinatorCustomDutyGroup("group1", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)duty1));
        final CountDownLatch latch2 = new CountDownLatch(1);
        CoordinatorCustomDuty duty2 = new CoordinatorCustomDuty(){

            public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
                latch2.countDown();
                return params;
            }
        };
        CoordinatorCustomDutyGroup group2 = new CoordinatorCustomDutyGroup("group2", Duration.standardSeconds((long)1L), (List)ImmutableList.of((Object)duty2));
        CoordinatorCustomDutyGroups groups = new CoordinatorCustomDutyGroups((Set)ImmutableSet.of((Object)group1, (Object)group2));
        this.coordinator = new DruidCoordinator(this.druidCoordinatorConfig, new ZkPathsConfig(){

            public String getBase() {
                return "druid";
            }
        }, configManager, this.segmentsMetadataManager, (ServerInventoryView)this.serverInventoryView, this.metadataRuleManager, () -> this.curator, (ServiceEmitter)this.serviceEmitter, this.scheduledExecutorFactory, null, null, (ServiceAnnouncer)new NoopServiceAnnouncer(){

            public void announce(DruidNode node) {
                DruidCoordinatorTest.this.leaderAnnouncerLatch.countDown();
            }

            public void unannounce(DruidNode node) {
                DruidCoordinatorTest.this.leaderUnannouncerLatch.countDown();
            }
        }, this.druidNode, this.loadManagementPeons, null, new HashSet(), groups, (BalancerStrategyFactory)new CostBalancerStrategyFactory(), (LookupCoordinatorManager)EasyMock.createNiceMock(LookupCoordinatorManager.class), (DruidLeaderSelector)new TestDruidLeaderSelector(), null, ZkEnablementConfig.ENABLED);
        this.coordinator.start();
        latch1.await();
        latch2.await();
    }

    @Test
    public void testEmitClusterStatsAndMetricsAddedWhenNotInDutyList() {
        DruidCoordinator druidCoordinator = this.coordinator;
        druidCoordinator.getClass();
        DruidCoordinator.DutiesRunnable dutyRunnable = new DruidCoordinator.DutiesRunnable(druidCoordinator, (List)ImmutableList.of((Object)new LogUsedSegments()), 0, "TEST");
        List duties = dutyRunnable.getDuties();
        int emitDutyFound = 0;
        for (CoordinatorDuty duty : duties) {
            if (!(duty instanceof EmitClusterStatsAndMetrics)) continue;
            ++emitDutyFound;
        }
        Assert.assertEquals((long)1L, (long)emitDutyFound);
    }

    @Test
    public void testEmitClusterStatsAndMetricsNotAddedAgainWhenInDutyList() {
        DruidCoordinator druidCoordinator = this.coordinator;
        druidCoordinator.getClass();
        DruidCoordinator.DutiesRunnable dutyRunnable = new DruidCoordinator.DutiesRunnable(druidCoordinator, (List)ImmutableList.of((Object)new LogUsedSegments(), (Object)new EmitClusterStatsAndMetrics(this.coordinator, "TEST", false)), 0, "TEST");
        List duties = dutyRunnable.getDuties();
        int emitDutyFound = 0;
        for (CoordinatorDuty duty : duties) {
            if (!(duty instanceof EmitClusterStatsAndMetrics)) continue;
            ++emitDutyFound;
        }
        Assert.assertEquals((long)1L, (long)emitDutyFound);
    }

    private CountDownLatch createCountDownLatchAndSetPathChildrenCacheListenerWithLatch(int latchCount, PathChildrenCache pathChildrenCache, Map<String, DataSegment> segments, DruidServer server) {
        CountDownLatch countDownLatch = new CountDownLatch(latchCount);
        pathChildrenCache.getListenable().addListener((client, event) -> {
            DataSegment segment;
            if (CuratorUtils.isChildAdded((PathChildrenCacheEvent)event) && (segment = DruidCoordinatorTest.findSegmentRelatedToCuratorEvent(segments, event)) != null && server.getSegment(segment.getId()) == null) {
                if (countDownLatch.getCount() > 0L) {
                    server.addDataSegment(segment);
                    ((ChildrenDeletable)this.curator.delete().guaranteed()).forPath(event.getData().getPath());
                    countDownLatch.countDown();
                } else {
                    Assert.fail((String)("The segment path " + event.getData().getPath() + " is not expected"));
                }
            }
        });
        return countDownLatch;
    }

    private void setupSegmentsMetadataMock(DruidDataSource dataSource) {
        EasyMock.expect((Object)this.segmentsMetadataManager.isPollingDatabasePeriodically()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.iterateAllUsedSegments()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.getImmutableDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        DataSourcesSnapshot dataSourcesSnapshot = new DataSourcesSnapshot((Map)ImmutableMap.of((Object)dataSource.getName(), (Object)dataSource.toImmutableDruidDataSource()));
        EasyMock.expect((Object)this.segmentsMetadataManager.getSnapshotOfDataSourcesWithAllUsedSegments()).andReturn((Object)dataSourcesSnapshot).anyTimes();
        EasyMock.expect((Object)this.segmentsMetadataManager.retrieveAllDataSourceNames()).andReturn(Collections.singleton(dataSource.getName())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.segmentsMetadataManager});
        EasyMock.expect((Object)this.dataSourcesSnapshot.iterateAllUsedSegmentsInSnapshot()).andReturn((Object)dataSource.getSegments()).anyTimes();
        EasyMock.expect((Object)this.dataSourcesSnapshot.getDataSourcesWithAllUsedSegments()).andReturn(Collections.singleton(dataSource.toImmutableDruidDataSource())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.dataSourcesSnapshot});
    }

    @Nullable
    private static DataSegment findSegmentRelatedToCuratorEvent(Map<String, DataSegment> dataSegments, PathChildrenCacheEvent event) {
        return dataSegments.entrySet().stream().filter(x -> event.getData().getPath().contains((CharSequence)x.getKey())).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static class LatchableServiceEmitter
    extends ServiceEmitter {
        private CountDownLatch latch;

        private LatchableServiceEmitter() {
            super("", "", null);
        }

        public void emit(Event event) {
            if (this.latch != null && "segment/count".equals(event.toMap().get("metric"))) {
                this.latch.countDown();
            }
        }
    }

    private static class TestDruidLeaderSelector
    implements DruidLeaderSelector {
        private volatile DruidLeaderSelector.Listener listener;
        private volatile String leader;

        private TestDruidLeaderSelector() {
        }

        public String getCurrentLeader() {
            return this.leader;
        }

        public boolean isLeader() {
            return this.leader != null;
        }

        public int localTerm() {
            return 0;
        }

        public void registerListener(DruidLeaderSelector.Listener listener) {
            this.listener = listener;
            this.leader = "what:1234";
            listener.becomeLeader();
        }

        public void unregisterListener() {
            this.leader = null;
            this.listener.stopBeingLeader();
        }
    }
}

