/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillSupervisors;
import org.joda.time.Duration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillSupervisorsTest {
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KillSupervisors killSupervisors;

    @Test
    public void testRunSkipIfLastRunLessThanPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, new Duration(Long.MAX_VALUE), new Duration((Object)"PT1S"), null, null, null, null, null, null, null, 10, null);
        this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.mockMetadataSupervisorManager});
    }

    @Test
    public void testRunNotSkipIfLastRunMoreThanPeriod() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, new Duration((Object)"PT6S"), new Duration((Object)"PT1S"), null, null, null, null, null, null, null, 10, null);
        this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataSupervisorManager)Mockito.verify((Object)this.mockMetadataSupervisorManager)).removeTerminatedSupervisorsOlderThan(ArgumentMatchers.anyLong());
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)ArgumentMatchers.any(ServiceEventBuilder.class));
    }

    @Test
    public void testConstructorFailIfInvalidPeriod() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, new Duration((Object)"PT3S"), new Duration((Object)"PT1S"), null, null, null, null, null, null, null, 10, null);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Coordinator supervisor kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
    }

    @Test
    public void testConstructorFailIfInvalidRetainDuration() {
        TestDruidCoordinatorConfig druidCoordinatorConfig = new TestDruidCoordinatorConfig(null, null, null, new Duration((Object)"PT5S"), null, null, null, new Duration((Object)"PT6S"), new Duration((Object)"PT-1S"), null, null, null, null, null, null, null, 10, null);
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("Coordinator supervisor kill retainDuration must be >= 0");
        this.killSupervisors = new KillSupervisors((DruidCoordinatorConfig)druidCoordinatorConfig, this.mockMetadataSupervisorManager);
    }
}

