/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.metadata.SegmentsMetadataManager;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.TestDruidCoordinatorConfig;
import org.apache.druid.server.coordinator.duty.KillUnusedSegments;
import org.easymock.EasyMock;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=Enclosed.class)
public class KillUnusedSegmentsTest {

    public static class FindIntervalsTest {
        @Test
        public void testFindIntervalForKill() {
            this.testFindIntervalForKill(null, null);
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of(), null);
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015")), Intervals.of((String)"2014/2015"));
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2016/2017")), Intervals.of((String)"2014/2017"));
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2014/2015"), (Object)Intervals.of((String)"2015/2016")), Intervals.of((String)"2014/2016"));
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2016"), (Object)Intervals.of((String)"2014/2015")), Intervals.of((String)"2014/2016"));
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2017"), (Object)Intervals.of((String)"2014/2016")), Intervals.of((String)"2014/2017"));
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2019"), (Object)Intervals.of((String)"2014/2016"), (Object)Intervals.of((String)"2018/2020")), Intervals.of((String)"2014/2020"));
            this.testFindIntervalForKill((List<Interval>)ImmutableList.of((Object)Intervals.of((String)"2015/2019"), (Object)Intervals.of((String)"2014/2016"), (Object)Intervals.of((String)"2018/2020"), (Object)Intervals.of((String)"2021/2022")), Intervals.of((String)"2014/2022"));
        }

        private void testFindIntervalForKill(List<Interval> segmentIntervals, Interval expected) {
            SegmentsMetadataManager segmentsMetadataManager = (SegmentsMetadataManager)EasyMock.createMock(SegmentsMetadataManager.class);
            EasyMock.expect((Object)segmentsMetadataManager.getUnusedSegmentIntervals(EasyMock.anyString(), (DateTime)EasyMock.anyObject(DateTime.class), EasyMock.anyInt())).andReturn(segmentIntervals);
            EasyMock.replay((Object[])new Object[]{segmentsMetadataManager});
            IndexingServiceClient indexingServiceClient = (IndexingServiceClient)EasyMock.createMock(IndexingServiceClient.class);
            KillUnusedSegments unusedSegmentsKiller = new KillUnusedSegments(segmentsMetadataManager, indexingServiceClient, (DruidCoordinatorConfig)new TestDruidCoordinatorConfig(null, null, Duration.parse((String)"PT76400S"), null, new Duration(1L), Duration.parse((String)"PT86400S"), Duration.parse((String)"PT86400S"), null, null, null, null, null, null, null, null, null, 1000, Duration.ZERO));
            Assert.assertEquals((Object)expected, (Object)unusedSegmentsKiller.findIntervalForKill("test", 10000));
        }
    }

    @RunWith(value=MockitoJUnitRunner.class)
    public static class MockedTest {
        private static final Set<String> ALL_DATASOURCES = ImmutableSet.of((Object)"DS1", (Object)"DS2", (Object)"DS3");
        private static final int MAX_SEGMENTS_TO_KILL = 10;
        private static final Duration COORDINATOR_KILL_PERIOD = Duration.standardMinutes((long)2L);
        private static final Duration DURATION_TO_RETAIN = Duration.standardDays((long)1L);
        private static final Duration INDEXING_PERIOD = Duration.standardMinutes((long)1L);
        @Mock
        private SegmentsMetadataManager segmentsMetadataManager;
        @Mock
        private IndexingServiceClient indexingServiceClient;
        @Mock(answer=Answers.RETURNS_DEEP_STUBS)
        private DruidCoordinatorConfig config;
        @Mock
        private DruidCoordinatorRuntimeParams params;
        @Mock
        private CoordinatorDynamicConfig coordinatorDynamicConfig;
        private KillUnusedSegments target;

        @Before
        public void setup() {
            ((DruidCoordinatorRuntimeParams)Mockito.doReturn((Object)this.coordinatorDynamicConfig).when((Object)this.params)).getCoordinatorDynamicConfig();
            ((SegmentsMetadataManager)Mockito.doReturn(ALL_DATASOURCES).when((Object)this.segmentsMetadataManager)).retrieveAllDataSourceNames();
            ((DruidCoordinatorConfig)Mockito.doReturn((Object)COORDINATOR_KILL_PERIOD).when((Object)this.config)).getCoordinatorKillPeriod();
            ((DruidCoordinatorConfig)Mockito.doReturn((Object)DURATION_TO_RETAIN).when((Object)this.config)).getCoordinatorKillDurationToRetain();
            ((DruidCoordinatorConfig)Mockito.doReturn((Object)INDEXING_PERIOD).when((Object)this.config)).getCoordinatorIndexingPeriod();
            ((DruidCoordinatorConfig)Mockito.doReturn((Object)10).when((Object)this.config)).getCoordinatorKillMaxSegments();
            this.target = new KillUnusedSegments(this.segmentsMetadataManager, this.indexingServiceClient, this.config);
        }

        @Test
        public void testRunWihNoIntervalShouldNotKillAnySegments() {
            this.target.run(this.params);
            ((IndexingServiceClient)Mockito.verify((Object)this.indexingServiceClient, (VerificationMode)Mockito.never())).killUnusedSegments(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class));
        }

        @Test
        public void testRunWihSpecificDatasourceAndNoIntervalShouldNotKillAnySegments() {
            Mockito.when((Object)this.coordinatorDynamicConfig.getSpecificDataSourcesToKillUnusedSegmentsIn()).thenReturn(Collections.singleton("DS1"));
            this.target.run(this.params);
            ((IndexingServiceClient)Mockito.verify((Object)this.indexingServiceClient, (VerificationMode)Mockito.never())).killUnusedSegments(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), (Interval)ArgumentMatchers.any(Interval.class));
        }
    }
}

