/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.log;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.server.QueryStats;
import org.apache.druid.server.RequestLogLine;
import org.apache.druid.server.log.DefaultRequestLogEvent;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRequestLogEventTest {
    private ObjectMapper objectMapper = new DefaultObjectMapper();

    @Test
    public void testDefaultRequestLogEventSerde() throws Exception {
        RequestLogLine nativeLine = RequestLogLine.forNative((Query)new TimeseriesQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), true, VirtualColumns.EMPTY, null, Granularities.ALL, (List)ImmutableList.of(), (List)ImmutableList.of(), 5, (Map)ImmutableMap.of((Object)"key", (Object)"value")), (DateTime)DateTimes.of((int)2019, (int)12, (int)12, (int)3, (int)1), (String)"127.0.0.1", (QueryStats)new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)13L, (Object)"query/bytes", (Object)10L, (Object)"success", (Object)true, (Object)"identity", (Object)"allowAll")));
        DefaultRequestLogEvent defaultRequestLogEvent = new DefaultRequestLogEvent(ImmutableMap.of((Object)"service", (Object)"druid-service", (Object)"host", (Object)"127.0.0.1"), "feed", nativeLine);
        String logEventJson = this.objectMapper.writeValueAsString((Object)defaultRequestLogEvent);
        String expected = "{\"feed\":\"feed\",\"query\":{\"queryType\":\"timeseries\",\"dataSource\":{\"type\":\"table\",\"name\":\"dummy\"},\"intervals\":{\"type\":\"intervals\",\"intervals\":[\"2015-01-01T00:00:00.000Z/2015-01-02T00:00:00.000Z\"]},\"descending\":true,\"virtualColumns\":[],\"filter\":null,\"granularity\":{\"type\":\"all\"},\"aggregations\":[],\"postAggregations\":[],\"limit\":5,\"context\":{\"key\":\"value\"}},\"host\":\"127.0.0.1\",\"timestamp\":\"2019-12-12T03:01:00.000Z\",\"service\":\"druid-service\",\"sql\":null,\"sqlQueryContext\":{},\"remoteAddr\":\"127.0.0.1\",\"queryStats\":{\"query/time\":13,\"query/bytes\":10,\"success\":true,\"identity\":\"allowAll\"}}";
        Assert.assertEquals((Object)this.objectMapper.readTree(expected), (Object)this.objectMapper.readTree(logEventJson));
    }

    @Test
    public void testDefaultRequestLogEventToMap() {
        String feed = "test";
        DateTime timestamp = DateTimes.of((int)2019, (int)12, (int)12, (int)3, (int)1);
        String service = "druid-service";
        String host = "127.0.0.1";
        TimeseriesQuery query = new TimeseriesQuery((DataSource)new TableDataSource("dummy"), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)ImmutableList.of((Object)Intervals.of((String)"2015-01-01/2015-01-02"))), true, VirtualColumns.EMPTY, null, Granularities.ALL, (List)ImmutableList.of(), (List)ImmutableList.of(), 5, (Map)ImmutableMap.of((Object)"key", (Object)"value"));
        QueryStats queryStats = new QueryStats((Map)ImmutableMap.of((Object)"query/time", (Object)13L, (Object)"query/bytes", (Object)10L, (Object)"success", (Object)true, (Object)"identity", (Object)"allowAll"));
        RequestLogLine nativeLine = RequestLogLine.forNative((Query)query, (DateTime)timestamp, (String)"127.0.0.1", (QueryStats)queryStats);
        DefaultRequestLogEvent defaultRequestLogEvent = new DefaultRequestLogEvent(ImmutableMap.of((Object)"service", (Object)"druid-service", (Object)"host", (Object)"127.0.0.1"), "test", nativeLine);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("feed", "test");
        expected.put("timestamp", (String)timestamp);
        expected.put("service", "druid-service");
        expected.put("host", "127.0.0.1");
        expected.put("query", (String)query);
        expected.put("remoteAddr", "127.0.0.1");
        expected.put("queryStats", (String)queryStats);
        Assert.assertEquals(expected, (Object)defaultRequestLogEvent.toMap());
    }

    @Test
    public void testDefaultRequestLogEventToMapSQL() {
        String feed = "test";
        DateTime timestamp = DateTimes.of((int)2019, (int)12, (int)12, (int)3, (int)1);
        String service = "druid-service";
        String host = "127.0.0.1";
        String sql = "select * from 1337";
        QueryStats queryStats = new QueryStats((Map)ImmutableMap.of((Object)"sqlQuery/time", (Object)13L, (Object)"sqlQuery/bytes", (Object)10L, (Object)"success", (Object)true, (Object)"identity", (Object)"allowAll"));
        RequestLogLine nativeLine = RequestLogLine.forSql((String)"select * from 1337", (Map)ImmutableMap.of(), (DateTime)timestamp, (String)"127.0.0.1", (QueryStats)queryStats);
        DefaultRequestLogEvent defaultRequestLogEvent = new DefaultRequestLogEvent(ImmutableMap.of((Object)"service", (Object)"druid-service", (Object)"host", (Object)"127.0.0.1"), "test", nativeLine);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("feed", "test");
        expected.put("timestamp", (String)timestamp);
        expected.put("service", "druid-service");
        expected.put("host", "127.0.0.1");
        expected.put("sql", "select * from 1337");
        expected.put("sqlQueryContext", (String)ImmutableMap.of());
        expected.put("remoteAddr", "127.0.0.1");
        expected.put("queryStats", (String)queryStats);
        Assert.assertEquals(expected, (Object)defaultRequestLogEvent.toMap());
    }
}

