/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.metrics;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.CreationException;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.BasicMonitorScheduler;
import org.apache.druid.java.util.metrics.ClockDriftSafeMonitorScheduler;
import org.apache.druid.java.util.metrics.MonitorScheduler;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.metrics.DataSourceTaskIdHolder;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class MetricsModuleTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSimpleInjection() {
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, false, null, null, true, false));
            }
        }));
        DataSourceTaskIdHolder dimensionIdHolder = new DataSourceTaskIdHolder();
        injector.injectMembers((Object)dimensionIdHolder);
        Assert.assertNull((Object)dimensionIdHolder.getDataSource());
        Assert.assertNull((Object)dimensionIdHolder.getTaskId());
    }

    @Test
    public void testSimpleInjectionWithValues() {
        String dataSource = "some datasource";
        String taskId = "some task";
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, false, null, null, true, false));
                binder.bind(Key.get(String.class, (Annotation)Names.named((String)"druidDataSource"))).toInstance((Object)"some datasource");
                binder.bind(Key.get(String.class, (Annotation)Names.named((String)"druidTaskId"))).toInstance((Object)"some task");
            }
        }));
        DataSourceTaskIdHolder dimensionIdHolder = new DataSourceTaskIdHolder();
        injector.injectMembers((Object)dimensionIdHolder);
        Assert.assertEquals((Object)"some datasource", (Object)dimensionIdHolder.getDataSource());
        Assert.assertEquals((Object)"some task", (Object)dimensionIdHolder.getTaskId());
    }

    @Test
    public void testGetBasicMonitorSchedulerByDefault() {
        MonitorScheduler monitorScheduler = (MonitorScheduler)MetricsModuleTest.createInjector(new Properties()).getInstance(MonitorScheduler.class);
        Assert.assertSame(BasicMonitorScheduler.class, monitorScheduler.getClass());
    }

    @Test
    public void testGetClockDriftSafeMonitorSchedulerViaConfig() {
        Properties properties = new Properties();
        properties.setProperty(StringUtils.format((String)"%s.schedulerClassName", (Object[])new Object[]{"druid.monitoring"}), ClockDriftSafeMonitorScheduler.class.getName());
        MonitorScheduler monitorScheduler = (MonitorScheduler)MetricsModuleTest.createInjector(properties).getInstance(MonitorScheduler.class);
        Assert.assertSame(ClockDriftSafeMonitorScheduler.class, monitorScheduler.getClass());
    }

    @Test
    public void testGetBasicMonitorSchedulerViaConfig() {
        Properties properties = new Properties();
        properties.setProperty(StringUtils.format((String)"%s.schedulerClassName", (Object[])new Object[]{"druid.monitoring"}), BasicMonitorScheduler.class.getName());
        MonitorScheduler monitorScheduler = (MonitorScheduler)MetricsModuleTest.createInjector(properties).getInstance(MonitorScheduler.class);
        Assert.assertSame(BasicMonitorScheduler.class, monitorScheduler.getClass());
    }

    @Test
    public void testGetMonitorSchedulerUnknownSchedulerException() {
        Properties properties = new Properties();
        properties.setProperty(StringUtils.format((String)"%s.schedulerClassName", (Object[])new Object[]{"druid.monitoring"}), "UnknownScheduler");
        this.expectedException.expect(CreationException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(IllegalArgumentException.class));
        this.expectedException.expectMessage("Unknown monitor scheduler[UnknownScheduler]");
        MetricsModuleTest.createInjector(properties).getInstance(MonitorScheduler.class);
    }

    private static Injector createInjector(Properties properties) {
        return Guice.createInjector((Module[])new Module[]{new JacksonModule(), new LifecycleModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bindScope(LazySingleton.class, Scopes.SINGLETON);
            binder.bind(ServiceEmitter.class).toInstance((Object)new NoopServiceEmitter());
            binder.bind(Properties.class).toInstance((Object)properties);
        }, new MetricsModule()});
    }
}

