/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.client.indexing.ClientKillUnusedSegmentsTaskQuery;
import org.apache.druid.client.indexing.IndexingService;
import org.apache.druid.client.indexing.IndexingServiceClient;
import org.apache.druid.client.indexing.IndexingTotalWorkerCapacityInfo;
import org.apache.druid.client.indexing.IndexingWorkerInfo;
import org.apache.druid.client.indexing.SamplerResponse;
import org.apache.druid.client.indexing.SamplerSpec;
import org.apache.druid.client.indexing.TaskPayloadResponse;
import org.apache.druid.client.indexing.TaskStatus;
import org.apache.druid.client.indexing.TaskStatusResponse;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.timeline.DataSegment;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class HttpIndexingServiceClient
implements IndexingServiceClient {
    private static final Logger log = new Logger(HttpIndexingServiceClient.class);
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;

    @Inject
    public HttpIndexingServiceClient(ObjectMapper jsonMapper, @IndexingService DruidLeaderClient druidLeaderClient) {
        this.jsonMapper = jsonMapper;
        this.druidLeaderClient = druidLeaderClient;
    }

    @Override
    public void killUnusedSegments(String idPrefix, String dataSource, Interval interval) {
        String taskId = IdUtils.newTaskId((String)idPrefix, (String)"kill", (String)dataSource, (Interval)interval);
        ClientKillUnusedSegmentsTaskQuery taskQuery = new ClientKillUnusedSegmentsTaskQuery(taskId, dataSource, interval, false);
        this.runTask(taskId, taskQuery);
    }

    @Override
    public String compactSegments(String idPrefix, List<DataSegment> segments, int compactionTaskPriority, @Nullable ClientCompactionTaskQueryTuningConfig tuningConfig, @Nullable ClientCompactionTaskGranularitySpec granularitySpec, @Nullable ClientCompactionTaskDimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, @Nullable ClientCompactionTaskTransformSpec transformSpec, @Nullable Boolean dropExisting, @Nullable Map<String, Object> context) {
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Expect non-empty segments to compact");
        String dataSource = segments.get(0).getDataSource();
        Preconditions.checkArgument((boolean)segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), (Object)"Segments must have the same dataSource");
        context = context == null ? new HashMap<String, Object>() : context;
        context.put("priority", compactionTaskPriority);
        String taskId = IdUtils.newTaskId((String)idPrefix, (String)"compact", (String)dataSource, null);
        Granularity segmentGranularity = granularitySpec == null ? null : granularitySpec.getSegmentGranularity();
        ClientCompactionTaskQuery taskQuery = new ClientCompactionTaskQuery(taskId, dataSource, new ClientCompactionIOConfig(ClientCompactionIntervalSpec.fromSegments(segments, segmentGranularity), dropExisting), tuningConfig, granularitySpec, dimensionsSpec, metricsSpec, transformSpec, context);
        return this.runTask(taskId, taskQuery);
    }

    @Override
    public String runTask(String taskId, Object taskObject) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/task").setContent("application/json", this.jsonMapper.writeValueAsBytes(taskObject)));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                if (!Strings.isNullOrEmpty((String)response.getContent())) {
                    throw new ISE("Failed to post task[%s] with error[%s].", new Object[]{taskId, response.getContent()});
                }
                throw new ISE("Failed to post task[%s]. Please check overlord log", new Object[]{taskId});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String returnedTaskId = (String)resultMap.get("task");
            Preconditions.checkState((boolean)taskId.equals(returnedTaskId), (String)"Got a different taskId[%s]. Expected taskId[%s]", (Object[])new Object[]{returnedTaskId, taskId});
            return taskId;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String cancelTask(String taskId) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, StringUtils.format((String)"/druid/indexer/v1/task/%s/shutdown", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Failed to cancel task[%s]", new Object[]{taskId});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(response.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            String cancelledTaskId = (String)resultMap.get("task");
            Preconditions.checkNotNull((Object)cancelledTaskId, (String)"Null task id returned for task[%s]", (Object[])new Object[]{taskId});
            Preconditions.checkState((boolean)taskId.equals(cancelledTaskId), (String)"Requested to cancel task[%s], but another task[%s] was cancelled!", (Object[])new Object[]{taskId, cancelledTaskId});
            return cancelledTaskId;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getTotalWorkerCapacity() {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/workers").setHeader("Content-Type", "application/json"));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while getting available cluster capacity. status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            Collection workers = (Collection)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Collection<IndexingWorkerInfo>>(){});
            return workers.stream().mapToInt(workerInfo -> workerInfo.getWorker().getCapacity()).sum();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getTotalWorkerCapacityWithAutoScale() {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, "/druid/indexer/v1/totalWorkerCapacity").setHeader("Content-Type", "application/json"));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while getting total worker capacity. status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
            }
            IndexingTotalWorkerCapacityInfo indexingTotalWorkerCapacityInfo = (IndexingTotalWorkerCapacityInfo)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<IndexingTotalWorkerCapacityInfo>(){});
            return indexingTotalWorkerCapacityInfo.getMaximumCapacityWithAutoScale();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<TaskStatusPlus> getActiveTasks() {
        ArrayList<TaskStatusPlus> tasks = new ArrayList<TaskStatusPlus>();
        HashSet<String> taskIdsSeen = new HashSet<String>();
        Iterable activeTasks = Iterables.concat(this.getTasks("waitingTasks"), this.getTasks("pendingTasks"), this.getTasks("runningTasks"));
        for (TaskStatusPlus task : activeTasks) {
            if (!taskIdsSeen.add(task.getId())) continue;
            tasks.add(task);
        }
        return tasks;
    }

    private List<TaskStatusPlus> getTasks(String endpointSuffix) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/%s", (Object[])new Object[]{endpointSuffix})));
            if (!responseHolder.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while fetching the status of tasks", new Object[0]);
            }
            return (List)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<List<TaskStatusPlus>>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public TaskStatusResponse getTaskStatus(String taskId) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/task/%s/status", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            return (TaskStatusResponse)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<TaskStatusResponse>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, TaskStatus> getTaskStatuses(Set<String> taskIds) throws InterruptedException {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/taskStatus").setContent("application/json", this.jsonMapper.writeValueAsBytes(taskIds)));
            return (Map)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<Map<String, TaskStatus>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public TaskStatusPlus getLastCompleteTask() {
        List<TaskStatusPlus> completeTaskStatuses = this.getTasks("completeTasks?n=1");
        return completeTaskStatuses.isEmpty() ? null : completeTaskStatuses.get(0);
    }

    @Override
    public TaskPayloadResponse getTaskPayload(String taskId) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/task/%s", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            return (TaskPayloadResponse)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<TaskPayloadResponse>(){});
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public Map<String, Object> getTaskReport(String taskId) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/indexer/v1/task/%s/reports", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})));
            if (responseHolder.getContent().length() == 0 || !HttpResponseStatus.OK.equals((Object)responseHolder.getStatus())) {
                if (responseHolder.getStatus() == HttpResponseStatus.NOT_FOUND) {
                    log.info("Report not found for taskId [%s] because [%s]", new Object[]{taskId, responseHolder.getContent()});
                } else {
                    log.info("Non OK response status [%s] for taskId [%s] because [%s]", new Object[]{responseHolder.getStatus(), taskId, responseHolder.getContent()});
                }
                return null;
            }
            return (Map)this.jsonMapper.readValue(responseHolder.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, List<Interval>> getLockedIntervals(Map<String, Integer> minTaskPriority) {
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/lockedIntervals").setContent("application/json", this.jsonMapper.writeValueAsBytes(minTaskPriority)));
            Map response = (Map)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<Map<String, List<Interval>>>(){});
            return response == null ? Collections.emptyMap() : response;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SamplerResponse sample(SamplerSpec samplerSpec) {
        try {
            StringFullResponseHolder response = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.POST, "/druid/indexer/v1/sampler").setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)samplerSpec)));
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                if (!Strings.isNullOrEmpty((String)response.getContent())) {
                    throw new ISE("Failed to sample with sampler spec[%s], response[%s].", new Object[]{samplerSpec, response.getContent()});
                }
                throw new ISE("Failed to sample with sampler spec[%s]. Please check overlord log", new Object[]{samplerSpec});
            }
            return (SamplerResponse)this.jsonMapper.readValue(response.getContent(), SamplerResponse.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int killPendingSegments(String dataSource, DateTime end) {
        String endPoint = StringUtils.format((String)"/druid/indexer/v1/pendingSegments/%s?interval=%s", (Object[])new Object[]{StringUtils.urlEncode((String)dataSource), new Interval((ReadableInstant)DateTimes.MIN, (ReadableInstant)end)});
        try {
            StringFullResponseHolder responseHolder = this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.DELETE, endPoint));
            if (!responseHolder.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while killing pendingSegments of dataSource[%s] created until [%s]", new Object[]{dataSource, end});
            }
            Map resultMap = (Map)this.jsonMapper.readValue(responseHolder.getContent(), JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
            Object numDeletedObject = resultMap.get("numDeleted");
            return (Integer)Preconditions.checkNotNull(numDeletedObject, (Object)"numDeletedObject");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

