/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskInfo;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.metadata.EntryExistsException;
import org.apache.druid.metadata.MetadataStorageActionHandler;
import org.apache.druid.metadata.MetadataStorageActionHandlerTypes;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.metadata.PasswordProviderRedactionMixIn;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.TaskLookup;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.FoldController;
import org.skife.jdbi.v2.Folder3;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.StatementException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.ByteArrayMapper;

public abstract class SQLMetadataStorageActionHandler<EntryType, StatusType, LogType, LockType>
implements MetadataStorageActionHandler<EntryType, StatusType, LogType, LockType> {
    private static final EmittingLogger log = new EmittingLogger(SQLMetadataStorageActionHandler.class);
    private final SQLMetadataConnector connector;
    private final ObjectMapper jsonMapper;
    private final TypeReference<EntryType> entryType;
    private final TypeReference<StatusType> statusType;
    private final TypeReference<LogType> logType;
    private final TypeReference<LockType> lockType;
    private final String entryTypeName;
    private final String entryTable;
    private final String logTable;
    private final String lockTable;
    private final TaskInfoMapper<EntryType, StatusType> taskInfoMapper;

    public SQLMetadataStorageActionHandler(SQLMetadataConnector connector, ObjectMapper jsonMapper, MetadataStorageActionHandlerTypes<EntryType, StatusType, LogType, LockType> types, String entryTypeName, String entryTable, String logTable, String lockTable) {
        this.connector = connector;
        this.jsonMapper = jsonMapper.copy().addMixIn(PasswordProvider.class, PasswordProviderRedactionMixIn.class);
        this.entryType = types.getEntryType();
        this.statusType = types.getStatusType();
        this.logType = types.getLogType();
        this.lockType = types.getLockType();
        this.entryTypeName = entryTypeName;
        this.entryTable = entryTable;
        this.logTable = logTable;
        this.lockTable = lockTable;
        this.taskInfoMapper = new TaskInfoMapper<EntryType, StatusType>(jsonMapper, this.entryType, this.statusType);
    }

    protected SQLMetadataConnector getConnector() {
        return this.connector;
    }

    protected ObjectMapper getJsonMapper() {
        return this.jsonMapper;
    }

    protected TypeReference<StatusType> getStatusType() {
        return this.statusType;
    }

    protected String getEntryTable() {
        return this.entryTable;
    }

    protected String getLogTable() {
        return this.logTable;
    }

    protected String getEntryTypeName() {
        return this.entryTypeName;
    }

    public TypeReference<EntryType> getEntryType() {
        return this.entryType;
    }

    public void insert(String id, DateTime timestamp, String dataSource, EntryType entry, boolean active, StatusType status) throws EntryExistsException {
        try {
            this.getConnector().retryWithHandle(handle -> {
                String sql = StringUtils.format((String)"INSERT INTO %s (id, created_date, datasource, payload, active, status_payload) VALUES (:id, :created_date, :datasource, :payload, :active, :status_payload)", (Object[])new Object[]{this.getEntryTable()});
                ((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(sql).bind("id", id)).bind("created_date", timestamp.toString())).bind("datasource", dataSource)).bind("payload", this.jsonMapper.writeValueAsBytes(entry))).bind("active", active)).bind("status_payload", this.jsonMapper.writeValueAsBytes(status))).execute();
                return null;
            }, (Predicate<Throwable>)((Predicate)e -> this.getConnector().isTransientException((Throwable)e) && (!SQLMetadataStorageActionHandler.isStatementException(e) || !this.getEntry(id).isPresent())));
        }
        catch (Exception e2) {
            if (SQLMetadataStorageActionHandler.isStatementException(e2) && this.getEntry(id).isPresent()) {
                throw new EntryExistsException(id, (Throwable)e2);
            }
            Throwables.propagateIfPossible((Throwable)e2);
            throw new RuntimeException(e2);
        }
    }

    public static boolean isStatementException(Throwable e) {
        return e instanceof StatementException || e instanceof CallbackFailedException && e.getCause() instanceof StatementException;
    }

    public boolean setStatus(final String entryId, final boolean active, final StatusType status) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)((Update)handle.createStatement(StringUtils.format((String)"UPDATE %s SET active = :active, status_payload = :status_payload WHERE id = :id AND active = TRUE", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.entryTable})).bind("id", entryId)).bind("active", active)).bind("status_payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(status))).execute() == 1;
            }
        });
    }

    public Optional<EntryType> getEntry(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<EntryType>>(){

            public Optional<EntryType> withHandle(Handle handle) throws Exception {
                byte[] res = (byte[])((Query)handle.createQuery(StringUtils.format((String)"SELECT payload FROM %s WHERE id = :id", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.entryTable})).bind("id", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.entryType));
            }
        });
    }

    public Optional<StatusType> getStatus(final String entryId) {
        return (Optional)this.connector.retryWithHandle(new HandleCallback<Optional<StatusType>>(){

            public Optional<StatusType> withHandle(Handle handle) throws Exception {
                byte[] res = (byte[])((Query)handle.createQuery(StringUtils.format((String)"SELECT status_payload FROM %s WHERE id = :id", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.entryTable})).bind("id", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).first();
                return Optional.fromNullable(res == null ? null : SQLMetadataStorageActionHandler.this.jsonMapper.readValue(res, SQLMetadataStorageActionHandler.this.statusType));
            }
        });
    }

    @Nullable
    public TaskInfo<EntryType, StatusType> getTaskInfo(String entryId) {
        return (TaskInfo)this.connector.retryWithHandle(handle -> {
            String query = StringUtils.format((String)"SELECT id, status_payload, payload, datasource, created_date FROM %s WHERE id = :id", (Object[])new Object[]{this.entryTable});
            return (TaskInfo)((Query)handle.createQuery(query).bind("id", entryId)).map(this.taskInfoMapper).first();
        });
    }

    public List<TaskInfo<EntryType, StatusType>> getTaskInfos(Map<TaskLookup.TaskLookupType, TaskLookup> taskLookups, @Nullable String dataSource) {
        return (List)this.getConnector().retryTransaction((handle, status) -> {
            ArrayList tasks = new ArrayList();
            block4: for (Map.Entry entry : taskLookups.entrySet()) {
                switch ((TaskLookup.TaskLookupType)entry.getKey()) {
                    case ACTIVE: {
                        Query<Map<String, Object>> query = this.createActiveTaskInfoQuery(handle, dataSource);
                        tasks.addAll(query.map(this.taskInfoMapper).list());
                        continue block4;
                    }
                    case COMPLETE: {
                        TaskLookup.CompleteTaskLookup completeTaskLookup = (TaskLookup.CompleteTaskLookup)entry.getValue();
                        Query<Map<String, Object>> query = this.createCompletedTaskInfoQuery(handle, completeTaskLookup.getTasksCreatedPriorTo(), completeTaskLookup.getMaxTaskStatuses(), dataSource);
                        tasks.addAll(query.map(this.taskInfoMapper).list());
                        continue block4;
                    }
                }
                throw new IAE("Unknown TaskLookupType: [%s]", new Object[]{entry.getKey()});
            }
            return tasks;
        }, 3, 10);
    }

    protected Query<Map<String, Object>> createCompletedTaskInfoQuery(Handle handle, DateTime timestamp, @Nullable Integer maxNumStatuses, @Nullable String dataSource) {
        String sql = StringUtils.format((String)("SELECT   id,   status_payload,   created_date,   datasource,   payload FROM   %s WHERE " + this.getWhereClauseForInactiveStatusesSinceQuery(dataSource) + "ORDER BY created_date DESC"), (Object[])new Object[]{this.getEntryTable()});
        if (maxNumStatuses != null) {
            sql = this.decorateSqlWithLimit(sql);
        }
        Query query = (Query)handle.createQuery(sql).bind("start", timestamp.toString());
        if (maxNumStatuses != null) {
            query = (Query)query.bind("n", maxNumStatuses);
        }
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    protected abstract String decorateSqlWithLimit(String var1);

    private String getWhereClauseForInactiveStatusesSinceQuery(@Nullable String datasource) {
        String sql = StringUtils.format((String)"active = FALSE AND created_date >= :start ", (Object[])new Object[0]);
        if (datasource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }

    private Query<Map<String, Object>> createActiveTaskInfoQuery(Handle handle, @Nullable String dataSource) {
        String sql = StringUtils.format((String)("SELECT   id,   status_payload,   payload,   datasource,   created_date FROM   %s WHERE " + this.getWhereClauseForActiveStatusesQuery(dataSource) + "ORDER BY created_date"), (Object[])new Object[]{this.entryTable});
        Query query = handle.createQuery(sql);
        if (dataSource != null) {
            query = (Query)query.bind("ds", dataSource);
        }
        return query;
    }

    private String getWhereClauseForActiveStatusesQuery(String dataSource) {
        String sql = StringUtils.format((String)"active = TRUE ", (Object[])new Object[0]);
        if (dataSource != null) {
            sql = sql + " AND datasource = :ds ";
        }
        return sql;
    }

    public boolean addLock(final String entryId, final LockType lock) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return SQLMetadataStorageActionHandler.this.addLock(handle, entryId, lock);
            }
        });
    }

    private boolean addLock(Handle handle, String entryId, LockType lock) throws JsonProcessingException {
        String statement = StringUtils.format((String)"INSERT INTO %1$s (%2$s_id, lock_payload) VALUES (:entryId, :payload)", (Object[])new Object[]{this.lockTable, this.entryTypeName});
        return ((Update)((Update)handle.createStatement(statement).bind("entryId", entryId)).bind("payload", this.jsonMapper.writeValueAsBytes(lock))).execute() == 1;
    }

    public boolean replaceLock(String entryId, long oldLockId, LockType newLock) {
        return (Boolean)this.connector.retryTransaction((handle, transactionStatus) -> {
            int numDeletedRows = this.removeLock(handle, oldLockId);
            if (numDeletedRows != 1) {
                transactionStatus.setRollbackOnly();
                String message = numDeletedRows == 0 ? StringUtils.format((String)"Cannot find lock[%d]", (Object[])new Object[]{oldLockId}) : StringUtils.format((String)"Found multiple locks for lockId[%d]", (Object[])new Object[]{oldLockId});
                throw new RuntimeException(message);
            }
            return this.addLock(handle, entryId, newLock);
        }, 3, 10);
    }

    public void removeLock(final long lockId) {
        this.connector.retryWithHandle(new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                SQLMetadataStorageActionHandler.this.removeLock(handle, lockId);
                return null;
            }
        });
    }

    public void removeTasksOlderThan(long timestamp) {
        DateTime dateTime = DateTimes.utc((long)timestamp);
        this.connector.retryWithHandle(handle -> {
            ((Update)handle.createStatement(this.getSqlRemoveLogsOlderThan()).bind("date_time", dateTime.toString())).execute();
            ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE created_date < :date_time AND active = false", (Object[])new Object[]{this.entryTable})).bind("date_time", dateTime.toString())).execute();
            return null;
        });
    }

    private int removeLock(Handle handle, long lockId) {
        return ((Update)handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE id = :id", (Object[])new Object[]{this.lockTable})).bind("id", lockId)).execute();
    }

    public boolean addLog(final String entryId, final LogType log) {
        return this.connector.retryWithHandle(new HandleCallback<Boolean>(){

            public Boolean withHandle(Handle handle) throws Exception {
                return ((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (%2$s_id, log_payload) VALUES (:entryId, :payload)", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName})).bind("entryId", entryId)).bind("payload", SQLMetadataStorageActionHandler.this.jsonMapper.writeValueAsBytes(log))).execute() == 1;
            }
        });
    }

    public List<LogType> getLogs(final String entryId) {
        return (List)this.connector.retryWithHandle(new HandleCallback<List<LogType>>(){

            public List<LogType> withHandle(Handle handle) {
                return (List)((Query)handle.createQuery(StringUtils.format((String)"SELECT log_payload FROM %1$s WHERE %2$s_id = :entryId", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.logTable, SQLMetadataStorageActionHandler.this.entryTypeName})).bind("entryId", entryId)).map((ResultSetMapper)ByteArrayMapper.FIRST).fold(new ArrayList(), (list, bytes, control, ctx) -> {
                    try {
                        list.add(SQLMetadataStorageActionHandler.this.jsonMapper.readValue(bytes, SQLMetadataStorageActionHandler.this.logType));
                        return list;
                    }
                    catch (IOException e) {
                        log.makeAlert((Throwable)e, "Failed to deserialize log", new Object[0]).addData("entryId", (Object)entryId).addData("payload", (Object)StringUtils.fromUtf8((byte[])bytes)).emit();
                        throw new SQLException(e);
                    }
                });
            }
        });
    }

    @Deprecated
    public String getSqlRemoveLogsOlderThan() {
        return StringUtils.format((String)"DELETE a FROM %s a INNER JOIN %s b ON a.%s_id = b.id WHERE b.created_date < :date_time and b.active = false", (Object[])new Object[]{this.logTable, this.entryTable, this.entryTypeName});
    }

    public Map<Long, LockType> getLocks(final String entryId) {
        return (Map)this.connector.retryWithHandle(new HandleCallback<Map<Long, LockType>>(){

            public Map<Long, LockType> withHandle(Handle handle) {
                return (Map)((Query)handle.createQuery(StringUtils.format((String)"SELECT id, lock_payload FROM %1$s WHERE %2$s_id = :entryId", (Object[])new Object[]{SQLMetadataStorageActionHandler.this.lockTable, SQLMetadataStorageActionHandler.this.entryTypeName})).bind("entryId", entryId)).map(new ResultSetMapper<Pair<Long, LockType>>(){

                    public Pair<Long, LockType> map(int index, ResultSet r, StatementContext ctx) throws SQLException {
                        try {
                            return Pair.of((Object)r.getLong("id"), (Object)SQLMetadataStorageActionHandler.this.jsonMapper.readValue(r.getBytes("lock_payload"), SQLMetadataStorageActionHandler.this.lockType));
                        }
                        catch (IOException e) {
                            log.makeAlert((Throwable)e, "Failed to deserialize " + SQLMetadataStorageActionHandler.this.lockType.getType(), new Object[0]).addData("id", (Object)r.getLong("id")).addData("lockPayload", (Object)StringUtils.fromUtf8((byte[])r.getBytes("lock_payload"))).emit();
                            throw new SQLException(e);
                        }
                    }
                }).fold((Object)Maps.newLinkedHashMap(), new Folder3<Map<Long, LockType>, Pair<Long, LockType>>(){

                    public Map<Long, LockType> fold(Map<Long, LockType> accumulator, Pair<Long, LockType> lock, FoldController control, StatementContext ctx) {
                        accumulator.put((Long)lock.lhs, lock.rhs);
                        return accumulator;
                    }
                });
            }
        });
    }

    @Nullable
    public Long getLockId(String entryId, LockType lock) {
        return this.getLocks(entryId).entrySet().stream().filter(entry -> entry.getValue().equals(lock)).map(Map.Entry::getKey).findAny().orElse(null);
    }

    static class TaskInfoMapper<EntryType, StatusType>
    implements ResultSetMapper<TaskInfo<EntryType, StatusType>> {
        private final ObjectMapper objectMapper;
        private final TypeReference<EntryType> entryType;
        private final TypeReference<StatusType> statusType;

        TaskInfoMapper(ObjectMapper objectMapper, TypeReference<EntryType> entryType, TypeReference<StatusType> statusType) {
            this.objectMapper = objectMapper;
            this.entryType = entryType;
            this.statusType = statusType;
        }

        public TaskInfo<EntryType, StatusType> map(int index, ResultSet resultSet, StatementContext context) throws SQLException {
            Object status;
            Object task;
            try {
                task = this.objectMapper.readValue(resultSet.getBytes("payload"), this.entryType);
            }
            catch (IOException e) {
                log.warn("Encountered exception[%s] while deserializing task payload, setting payload to null", new Object[]{e.getMessage()});
                task = null;
            }
            try {
                status = this.objectMapper.readValue(resultSet.getBytes("status_payload"), this.statusType);
            }
            catch (IOException e) {
                log.error((Throwable)e, "Encountered exception while deserializing task status_payload", new Object[0]);
                throw new SQLException(e);
            }
            TaskInfo taskInfo = new TaskInfo(resultSet.getString("id"), DateTimes.of((String)resultSet.getString("created_date")), status, resultSet.getString("datasource"), task);
            return taskInfo;
        }
    }
}

