/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multiset;
import com.google.common.collect.TreeMultiset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.indexing.granularity.UniformGranularitySpec;
import org.apache.druid.segment.transform.TransformSpec;

public class DataSchema {
    private static final Logger log = new Logger(DataSchema.class);
    private final String dataSource;
    private final AggregatorFactory[] aggregators;
    private final GranularitySpec granularitySpec;
    private final TransformSpec transformSpec;
    private final Map<String, Object> parserMap;
    private final ObjectMapper objectMapper;
    private TimestampSpec timestampSpec;
    private DimensionsSpec dimensionsSpec;
    private InputRowParser inputRowParser;

    @JsonCreator
    public DataSchema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestampSpec") @Nullable TimestampSpec timestampSpec, @JsonProperty(value="dimensionsSpec") @Nullable DimensionsSpec dimensionsSpec, @JsonProperty(value="metricsSpec") AggregatorFactory[] aggregators, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="transformSpec") TransformSpec transformSpec, @Deprecated @JsonProperty(value="parser") @Nullable Map<String, Object> parserMap, @JacksonInject ObjectMapper objectMapper) {
        DataSchema.validateDatasourceName(dataSource);
        this.dataSource = dataSource;
        this.timestampSpec = timestampSpec;
        this.aggregators = aggregators == null ? new AggregatorFactory[]{} : aggregators;
        DimensionsSpec dimensionsSpec2 = this.dimensionsSpec = dimensionsSpec == null ? null : DataSchema.computeDimensionsSpec((TimestampSpec)Preconditions.checkNotNull((Object)timestampSpec, (Object)"timestampSpec"), dimensionsSpec, this.aggregators);
        if (granularitySpec == null) {
            log.warn("No granularitySpec has been specified. Using UniformGranularitySpec as default.", new Object[0]);
            this.granularitySpec = new UniformGranularitySpec(null, null, null);
        } else {
            this.granularitySpec = granularitySpec;
        }
        this.transformSpec = transformSpec == null ? TransformSpec.NONE : transformSpec;
        this.parserMap = parserMap;
        this.objectMapper = objectMapper;
        DataSchema.computeAndValidateOutputFieldNames(this.dimensionsSpec, this.aggregators);
        if (this.granularitySpec.isRollup() && this.aggregators.length == 0) {
            log.warn("Rollup is enabled for dataSource [%s] but no metricsSpec has been provided. Are you sure this is what you want?", new Object[]{dataSource});
        }
    }

    @VisibleForTesting
    public DataSchema(String dataSource, TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators, GranularitySpec granularitySpec, TransformSpec transformSpec) {
        this(dataSource, timestampSpec, dimensionsSpec, aggregators, granularitySpec, transformSpec, null, null);
    }

    @Deprecated
    public DataSchema(String dataSource, Map<String, Object> parserMap, AggregatorFactory[] aggregators, GranularitySpec granularitySpec, TransformSpec transformSpec, ObjectMapper objectMapper) {
        this(dataSource, null, null, aggregators, granularitySpec, transformSpec, parserMap, objectMapper);
    }

    private static void validateDatasourceName(String dataSource) {
        IdUtils.validateId((String)"dataSource", (String)dataSource);
    }

    private static DimensionsSpec computeDimensionsSpec(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators) {
        Set<String> inputFieldNames = DataSchema.computeInputFieldNames(timestampSpec, dimensionsSpec, aggregators);
        Set<String> outputFieldNames = DataSchema.computeAndValidateOutputFieldNames(dimensionsSpec, aggregators);
        HashSet<String> additionalDimensionExclusions = new HashSet<String>();
        additionalDimensionExclusions.addAll(inputFieldNames);
        additionalDimensionExclusions.addAll(outputFieldNames);
        additionalDimensionExclusions.removeAll(dimensionsSpec.getDimensionNames());
        return dimensionsSpec.withDimensionExclusions(additionalDimensionExclusions);
    }

    private static Set<String> computeInputFieldNames(TimestampSpec timestampSpec, DimensionsSpec dimensionsSpec, AggregatorFactory[] aggregators) {
        HashSet<String> fields = new HashSet<String>();
        fields.add(timestampSpec.getTimestampColumn());
        fields.addAll(dimensionsSpec.getDimensionNames());
        Arrays.stream(aggregators).flatMap(aggregator -> aggregator.requiredFields().stream()).forEach(fields::add);
        return fields;
    }

    private static Set<String> computeAndValidateOutputFieldNames(@Nullable DimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] aggregators) {
        String field;
        int i;
        TreeMap<String, Multiset> fields = new TreeMap<String, Multiset>();
        fields.computeIfAbsent("__time", k -> TreeMultiset.create()).add((Object)StringUtils.format((String)"primary timestamp (%s cannot appear as a dimension or metric)", (Object[])new Object[]{"__time"}));
        if (dimensionsSpec != null) {
            for (i = 0; i < dimensionsSpec.getDimensions().size(); ++i) {
                field = ((DimensionSchema)dimensionsSpec.getDimensions().get(i)).getName();
                if (Strings.isNullOrEmpty((String)field)) {
                    throw new IAE("Encountered dimension with null or empty name at position %d", new Object[]{i});
                }
                fields.computeIfAbsent(field, k -> TreeMultiset.create()).add((Object)"dimensions list");
            }
        }
        if (aggregators != null) {
            for (i = 0; i < aggregators.length; ++i) {
                field = aggregators[i].getName();
                if (Strings.isNullOrEmpty((String)field)) {
                    throw new IAE("Encountered metric with null or empty name at position %d", new Object[]{i});
                }
                fields.computeIfAbsent(field, k -> TreeMultiset.create()).add((Object)"metricsSpec list");
            }
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Map.Entry fieldEntry : fields.entrySet()) {
            if (((Multiset)fieldEntry.getValue()).entrySet().stream().mapToInt(Multiset.Entry::getCount).sum() <= 1) continue;
            errors.add(StringUtils.format((String)"[%s] seen in %s", (Object[])new Object[]{fieldEntry.getKey(), ((Multiset)fieldEntry.getValue()).entrySet().stream().map(entry -> StringUtils.format((String)"%s%s", (Object[])new Object[]{entry.getElement(), entry.getCount() == 1 ? "" : StringUtils.format((String)" (%d occurrences)", (Object[])new Object[]{entry.getCount()})})).collect(Collectors.joining(", "))}));
        }
        if (errors.isEmpty()) {
            return fields.keySet();
        }
        throw new IAE("Cannot specify a column more than once: %s", new Object[]{String.join((CharSequence)"; ", errors)});
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Nullable
    @JsonProperty(value="timestampSpec")
    private TimestampSpec getGivenTimestampSpec() {
        return this.timestampSpec;
    }

    public TimestampSpec getTimestampSpec() {
        if (this.timestampSpec == null) {
            this.timestampSpec = ((InputRowParser)Preconditions.checkNotNull((Object)this.getParser(), (Object)"inputRowParser")).getParseSpec().getTimestampSpec();
        }
        return this.timestampSpec;
    }

    @Nullable
    @JsonProperty(value="dimensionsSpec")
    private DimensionsSpec getGivenDimensionsSpec() {
        return this.dimensionsSpec;
    }

    public DimensionsSpec getDimensionsSpec() {
        if (this.dimensionsSpec == null) {
            this.dimensionsSpec = DataSchema.computeDimensionsSpec(this.getTimestampSpec(), ((InputRowParser)Preconditions.checkNotNull((Object)this.getParser(), (Object)"inputRowParser")).getParseSpec().getDimensionsSpec(), this.aggregators);
        }
        return this.dimensionsSpec;
    }

    @JsonProperty(value="metricsSpec")
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public GranularitySpec getGranularitySpec() {
        return this.granularitySpec;
    }

    @JsonProperty
    public TransformSpec getTransformSpec() {
        return this.transformSpec;
    }

    @Deprecated
    @JsonProperty(value="parser")
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getParserMap() {
        return this.parserMap;
    }

    @Nullable
    public InputRowParser getParser() {
        if (this.inputRowParser == null) {
            if (this.parserMap == null) {
                return null;
            }
            this.inputRowParser = this.transformSpec.decorate((InputRowParser)this.objectMapper.convertValue(this.parserMap, InputRowParser.class));
            ParseSpec parseSpec = this.inputRowParser.getParseSpec();
            parseSpec = parseSpec.withDimensionsSpec(DataSchema.computeDimensionsSpec(parseSpec.getTimestampSpec(), parseSpec.getDimensionsSpec(), this.aggregators));
            if (this.timestampSpec != null) {
                parseSpec = parseSpec.withTimestampSpec(this.timestampSpec);
            }
            if (this.dimensionsSpec != null) {
                parseSpec = parseSpec.withDimensionsSpec(this.dimensionsSpec);
            }
            this.inputRowParser = this.inputRowParser.withParseSpec(parseSpec);
        }
        return this.inputRowParser;
    }

    public DataSchema withGranularitySpec(GranularitySpec granularitySpec) {
        return new DataSchema(this.dataSource, this.timestampSpec, this.dimensionsSpec, this.aggregators, granularitySpec, this.transformSpec, this.parserMap, this.objectMapper);
    }

    public DataSchema withTransformSpec(TransformSpec transformSpec) {
        return new DataSchema(this.dataSource, this.timestampSpec, this.dimensionsSpec, this.aggregators, this.granularitySpec, transformSpec, this.parserMap, this.objectMapper);
    }

    public DataSchema withDimensionsSpec(DimensionsSpec dimensionsSpec) {
        return new DataSchema(this.dataSource, this.timestampSpec, dimensionsSpec, this.aggregators, this.granularitySpec, this.transformSpec, this.parserMap, this.objectMapper);
    }

    public String toString() {
        return "DataSchema{dataSource='" + this.dataSource + '\'' + ", aggregators=" + Arrays.toString(this.aggregators) + ", granularitySpec=" + this.granularitySpec + ", transformSpec=" + this.transformSpec + ", parserMap=" + this.parserMap + ", timestampSpec=" + this.timestampSpec + ", dimensionsSpec=" + this.dimensionsSpec + ", inputRowParser=" + this.inputRowParser + '}';
    }
}

