/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.appenderator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentWithState;

public class AppenderatorDriverMetadata {
    private final Map<String, List<SegmentWithState>> segments;
    private final Map<String, String> lastSegmentIds;
    private final Object callerMetadata;

    @JsonCreator
    public AppenderatorDriverMetadata(@JsonProperty(value="segments") Map<String, List<SegmentWithState>> segments, @JsonProperty(value="lastSegmentIds") Map<String, String> lastSegmentIds, @JsonProperty(value="callerMetadata") Object callerMetadata, @JsonProperty(value="activeSegments") Map<String, List<SegmentIdWithShardSpec>> activeSegments, @JsonProperty(value="publishPendingSegments") Map<String, List<SegmentIdWithShardSpec>> publishPendingSegments) {
        Preconditions.checkState((segments != null || activeSegments != null && publishPendingSegments != null ? 1 : 0) != 0, (String)"Metadata should either have segments with state information or both active segments and publish pending segments information. segments [%s], activeSegments [%s], publishPendingSegments [%s]", (Object[])new Object[]{segments, activeSegments, publishPendingSegments});
        if (segments == null) {
            HashMap<String, List<SegmentWithState>> newMetadata = new HashMap<String, List<SegmentWithState>>();
            HashSet activeSegmentsAlreadySeen = new HashSet();
            activeSegments.forEach((sequence, sequenceSegments) -> newMetadata.put((String)sequence, sequenceSegments.stream().map(segmentIdentifier -> {
                activeSegmentsAlreadySeen.add(segmentIdentifier.asSegmentId());
                return SegmentWithState.newSegment(segmentIdentifier);
            }).collect(Collectors.toList())));
            publishPendingSegments.forEach((sequence, sequenceSegments) -> {
                List segmentWithStates = newMetadata.computeIfAbsent((String)sequence, seq -> new ArrayList());
                sequenceSegments.stream().filter(segmentIdentifier -> !activeSegmentsAlreadySeen.contains(segmentIdentifier.asSegmentId())).map(segmentIdentifier -> SegmentWithState.newSegment(segmentIdentifier, SegmentWithState.SegmentState.APPEND_FINISHED)).forEach(segmentWithStates::add);
            });
            this.segments = newMetadata;
        } else {
            this.segments = segments;
        }
        this.lastSegmentIds = lastSegmentIds;
        this.callerMetadata = callerMetadata;
    }

    public AppenderatorDriverMetadata(Map<String, List<SegmentWithState>> segments, Map<String, String> lastSegmentIds, Object callerMetadata) {
        this(segments, lastSegmentIds, callerMetadata, null, null);
    }

    @JsonProperty
    public Map<String, List<SegmentWithState>> getSegments() {
        return this.segments;
    }

    @JsonProperty
    public Map<String, String> getLastSegmentIds() {
        return this.lastSegmentIds;
    }

    @JsonProperty
    public Object getCallerMetadata() {
        return this.callerMetadata;
    }

    public String toString() {
        return "AppenderatorDriverMetadata{segments=" + this.segments + ", lastSegmentIds=" + this.lastSegmentIds + ", callerMetadata=" + this.callerMetadata + '}';
    }
}

