/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.DateTime;

public class TimedShutoffFirehoseFactory
implements FirehoseFactory<InputRowParser> {
    private static final EmittingLogger log = new EmittingLogger(FirehoseFactory.class);
    private final FirehoseFactory delegateFactory;
    private final DateTime shutoffTime;

    @JsonCreator
    public TimedShutoffFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegateFactory, @JsonProperty(value="shutoffTime") DateTime shutoffTime) {
        this.delegateFactory = delegateFactory;
        this.shutoffTime = shutoffTime;
    }

    public Firehose connect(InputRowParser parser, File temporaryDirectory) throws IOException {
        return new TimedShutoffFirehose(parser, temporaryDirectory);
    }

    @JsonProperty(value="delegate")
    public FirehoseFactory getDelegateFactory() {
        return this.delegateFactory;
    }

    @JsonProperty(value="shutoffTime")
    public DateTime getShutoffTime() {
        return this.shutoffTime;
    }

    class TimedShutoffFirehose
    implements Firehose {
        private final Firehose firehose;
        private final ScheduledExecutorService shutdownExec;
        @GuardedBy(value="this")
        private boolean closed = false;

        TimedShutoffFirehose(InputRowParser parser, File temporaryDirectory) throws IOException {
            this.firehose = TimedShutoffFirehoseFactory.this.delegateFactory.connect(parser, temporaryDirectory);
            this.shutdownExec = Execs.scheduledSingleThreaded((String)"timed-shutoff-firehose-%d");
            this.shutdownExec.schedule(() -> {
                log.info("Closing delegate firehose.", new Object[0]);
                try {
                    this.close();
                }
                catch (IOException e) {
                    log.warn((Throwable)e, "Failed to close delegate firehose, ignoring.", new Object[0]);
                }
            }, TimedShutoffFirehoseFactory.this.shutoffTime.getMillis() - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            log.info("Firehose created, will shut down at: %s", new Object[]{TimedShutoffFirehoseFactory.this.shutoffTime});
        }

        public boolean hasMore() throws IOException {
            return this.firehose.hasMore();
        }

        @Nullable
        public InputRow nextRow() throws IOException {
            return this.firehose.nextRow();
        }

        public synchronized void close() throws IOException {
            if (!this.closed) {
                this.closed = true;
                Closeable[] closeableArray = new Closeable[1];
                closeableArray[0] = this.shutdownExec::shutdownNow;
                CloseableUtils.closeAll((Closeable)this.firehose, (Closeable[])closeableArray);
            }
        }
    }
}

