/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;

public class KillSupervisors
implements CoordinatorDuty {
    private static final Logger log = new Logger(KillSupervisors.class);
    private final long period;
    private final long retainDuration;
    private long lastKillTime = 0L;
    private final MetadataSupervisorManager metadataSupervisorManager;

    @Inject
    public KillSupervisors(DruidCoordinatorConfig config, MetadataSupervisorManager metadataSupervisorManager) {
        this.metadataSupervisorManager = metadataSupervisorManager;
        this.period = config.getCoordinatorSupervisorKillPeriod().getMillis();
        Preconditions.checkArgument((this.period >= config.getCoordinatorMetadataStoreManagementPeriod().getMillis() ? 1 : 0) != 0, (Object)"Coordinator supervisor kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        this.retainDuration = config.getCoordinatorSupervisorKillDurationToRetain().getMillis();
        Preconditions.checkArgument((this.retainDuration >= 0L ? 1 : 0) != 0, (Object)"Coordinator supervisor kill retainDuration must be >= 0");
        Preconditions.checkArgument((this.retainDuration < System.currentTimeMillis() ? 1 : 0) != 0, (Object)"Coordinator supervisor kill retainDuration cannot be greater than current time in ms");
        log.debug("Supervisor Kill Task scheduling enabled with period [%s], retainDuration [%s]", new Object[]{this.period, this.retainDuration});
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastKillTime + this.period < currentTimeMillis) {
            this.lastKillTime = currentTimeMillis;
            long timestamp = currentTimeMillis - this.retainDuration;
            try {
                int supervisorRemoved = this.metadataSupervisorManager.removeTerminatedSupervisorsOlderThan(timestamp);
                ServiceEmitter emitter = params.getEmitter();
                emitter.emit(new ServiceMetricEvent.Builder().build("metadata/kill/supervisor/count", (Number)supervisorRemoved));
                log.info("Finished running KillSupervisors duty. Removed %,d supervisor specs", new Object[]{supervisorRemoved});
            }
            catch (Exception e) {
                log.error((Throwable)e, "Failed to kill terminated supervisor metadata", new Object[0]);
            }
        }
        return params;
    }
}

