/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.server.coordinator.CoordinatorStats;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.Overshadowable;
import org.apache.druid.timeline.VersionedIntervalTimeline;

public class MarkAsUnusedOvershadowedSegments
implements CoordinatorDuty {
    private final DruidCoordinator coordinator;

    public MarkAsUnusedOvershadowedSegments(DruidCoordinator coordinator) {
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (!params.coordinatorIsLeadingEnoughTimeToMarkAsUnusedOvershadowedSegements()) {
            return params;
        }
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        HashMap<String, VersionedIntervalTimeline<String, DataSegment>> timelines = new HashMap<String, VersionedIntervalTimeline<String, DataSegment>>();
        for (SortedSet sortedSet : cluster.getSortedHistoricalsByTier()) {
            for (ServerHolder serverHolder : sortedSet) {
                this.addSegmentsFromServer(serverHolder, timelines);
            }
        }
        for (ServerHolder serverHolder : cluster.getBrokers()) {
            this.addSegmentsFromServer(serverHolder, timelines);
        }
        for (DataSegment dataSegment : params.getUsedSegments()) {
            VersionedIntervalTimeline timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null || !timeline.isOvershadowed(dataSegment.getInterval(), (Object)dataSegment.getVersion(), (Overshadowable)dataSegment)) continue;
            this.coordinator.markSegmentAsUnused(dataSegment);
            stats.addToGlobalStat("overShadowedCount", 1L);
        }
        return params.buildFromExisting().withCoordinatorStats(stats).build();
    }

    private void addSegmentsFromServer(ServerHolder serverHolder, Map<String, VersionedIntervalTimeline<String, DataSegment>> timelines) {
        ImmutableDruidServer server = serverHolder.getServer();
        for (ImmutableDruidDataSource dataSource : server.getDataSources()) {
            VersionedIntervalTimeline timeline = timelines.computeIfAbsent(dataSource.getName(), dsName -> new VersionedIntervalTimeline(Comparator.naturalOrder()));
            VersionedIntervalTimeline.addSegments((VersionedIntervalTimeline)timeline, dataSource.getSegments().iterator());
        }
    }
}

