/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.scheduling;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.server.QueryPrioritizationStrategy;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class ThresholdBasedQueryPrioritizationStrategy
implements QueryPrioritizationStrategy {
    private static final int DEFAULT_SEGMENT_THRESHOLD = Integer.MAX_VALUE;
    private static final int DEFAULT_ADJUSTMENT = 5;
    private final int segmentCountThreshold;
    private final int adjustment;
    private final Optional<Duration> periodThreshold;
    private final Optional<Duration> durationThreshold;

    @JsonCreator
    public ThresholdBasedQueryPrioritizationStrategy(@JsonProperty(value="periodThreshold") @Nullable String periodThresholdString, @JsonProperty(value="durationThreshold") @Nullable String durationThresholdString, @JsonProperty(value="segmentCountThreshold") @Nullable Integer segmentCountThreshold, @JsonProperty(value="adjustment") @Nullable Integer adjustment) {
        this.segmentCountThreshold = segmentCountThreshold == null ? Integer.MAX_VALUE : segmentCountThreshold;
        this.adjustment = adjustment == null ? 5 : adjustment;
        this.periodThreshold = periodThresholdString == null ? Optional.empty() : Optional.of(new Period((Object)periodThresholdString).toDurationFrom((ReadableInstant)DateTimes.nowUtc()));
        this.durationThreshold = durationThresholdString == null ? Optional.empty() : Optional.of(new Period((Object)durationThresholdString).toStandardDuration());
        Preconditions.checkArgument((segmentCountThreshold != null || this.periodThreshold.isPresent() || this.durationThreshold.isPresent() ? 1 : 0) != 0, (Object)"periodThreshold, durationThreshold, or segmentCountThreshold must be set");
    }

    @Override
    public <T> Optional<Integer> computePriority(QueryPlus<T> query, Set<SegmentServerSelector> segments) {
        boolean violatesSegmentThreshold;
        Query theQuery = query.getQuery();
        boolean violatesPeriodThreshold = this.periodThreshold.map(duration -> {
            DateTime periodThresholdStartDate = DateTimes.nowUtc().minus((ReadableDuration)duration);
            return theQuery.getIntervals().stream().anyMatch(interval -> interval.getStart().isBefore((ReadableInstant)periodThresholdStartDate));
        }).orElse(false);
        boolean violatesDurationThreshold = this.durationThreshold.map(duration -> theQuery.getDuration().isLongerThan((ReadableDuration)duration)).orElse(false);
        boolean bl = violatesSegmentThreshold = segments.size() > this.segmentCountThreshold;
        if (violatesPeriodThreshold || violatesDurationThreshold || violatesSegmentThreshold) {
            int adjustedPriority = QueryContexts.getPriority((Query)theQuery) - this.adjustment;
            return Optional.of(adjustedPriority);
        }
        return Optional.empty();
    }
}

