/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ErrorListenerPathAndBytesable;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.druid.curator.CuratorModule;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.StartupInjectorBuilder;
import org.apache.druid.testing.junit.LoggerCaptureRule;
import org.apache.logging.log4j.Level;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.contrib.java.lang.system.ExpectedSystemExit;

public final class CuratorModuleTest {
    private static final String CURATOR_HOST_KEY = "druid.zk.service.host";
    private static final String CURATOR_CONNECTION_TIMEOUT_MS_KEY = "druid.zk.service.connectionTimeoutMs";
    private static final String EXHIBITOR_HOSTS_KEY = "druid.exhibitor.service.hosts";
    @Rule
    public final ExpectedSystemExit exit = ExpectedSystemExit.none();
    @Rule
    public final LoggerCaptureRule logger = new LoggerCaptureRule(CuratorModule.class);

    @Test
    public void defaultEnsembleProvider() {
        Injector injector = this.newInjector(new Properties());
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be FixedEnsembleProvider", (boolean)(ensembleProvider instanceof FixedEnsembleProvider));
        Assert.assertEquals((String)"The connectionString should be 'localhost'", (Object)"localhost", (Object)ensembleProvider.getConnectionString());
    }

    @Test
    public void fixedZkHosts() {
        Properties props = new Properties();
        props.setProperty(CURATOR_HOST_KEY, "hostA");
        Injector injector = this.newInjector(props);
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be FixedEnsembleProvider", (boolean)(ensembleProvider instanceof FixedEnsembleProvider));
        Assert.assertEquals((String)"The connectionString should be 'hostA'", (Object)"hostA", (Object)ensembleProvider.getConnectionString());
    }

    @Test
    public void exhibitorEnsembleProvider() {
        Properties props = new Properties();
        props.setProperty(CURATOR_HOST_KEY, "hostA");
        props.setProperty(EXHIBITOR_HOSTS_KEY, "[\"hostB\"]");
        Injector injector = this.newInjector(props);
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be ExhibitorEnsembleProvider", (boolean)(ensembleProvider instanceof ExhibitorEnsembleProvider));
    }

    @Test
    public void emptyExhibitorHosts() {
        Properties props = new Properties();
        props.setProperty(CURATOR_HOST_KEY, "hostB");
        props.setProperty(EXHIBITOR_HOSTS_KEY, "[]");
        Injector injector = this.newInjector(props);
        injector.getInstance(CuratorFramework.class);
        EnsembleProvider ensembleProvider = (EnsembleProvider)injector.getInstance(EnsembleProvider.class);
        Assert.assertTrue((String)"EnsembleProvider should be FixedEnsembleProvider", (boolean)(ensembleProvider instanceof FixedEnsembleProvider));
        Assert.assertEquals((String)"The connectionString should be 'hostB'", (Object)"hostB", (Object)ensembleProvider.getConnectionString());
    }

    @Test
    public void exitsJvmWhenMaxRetriesExceeded() throws Exception {
        Properties props = new Properties();
        props.setProperty(CURATOR_CONNECTION_TIMEOUT_MS_KEY, "0");
        Injector injector = this.newInjector(props);
        CuratorFramework curatorFramework = CuratorModuleTest.createCuratorFramework(injector, 0);
        curatorFramework.start();
        this.exit.expectSystemExitWithStatus(1);
        this.logger.clearLogEvents();
        ((ErrorListenerPathAndBytesable)curatorFramework.create().inBackground()).forPath("/foo");
        List loggingEvents = this.logger.getLogEvents();
        Assert.assertTrue((String)("Logging events: " + loggingEvents), (boolean)loggingEvents.stream().anyMatch(l -> l.getLevel().equals((Object)Level.ERROR) && l.getMessage().getFormattedMessage().equals("Unhandled error in Curator, stopping server.")));
    }

    @Ignore(value="Verifies changes in https://github.com/apache/druid/pull/8458, but overkill for regular testing")
    @Test
    public void ignoresDeprecatedCuratorConfigProperties() {
        Properties props = new Properties();
        String deprecatedPropName = "druid.zk.service.terminateDruidProcessOnConnectFail";
        props.setProperty(deprecatedPropName, "true");
        Injector injector = this.newInjector(props);
        try {
            injector.getInstance(CuratorFramework.class);
        }
        catch (Exception e) {
            Assert.fail((String)("Deprecated curator config was not ignored:\n" + e));
        }
    }

    private Injector newInjector(Properties props) {
        return ((StartupInjectorBuilder)new StartupInjectorBuilder().add(new Module[]{new LifecycleModule(), new CuratorModule(), binder -> binder.bind(Properties.class).toInstance((Object)props)})).build();
    }

    private static CuratorFramework createCuratorFramework(Injector injector, int maxRetries) {
        CuratorFramework curatorFramework = (CuratorFramework)injector.getInstance(CuratorFramework.class);
        RetryPolicy retryPolicy = curatorFramework.getZookeeperClient().getRetryPolicy();
        Assert.assertThat((Object)retryPolicy, (Matcher)CoreMatchers.instanceOf(ExponentialBackoffRetry.class));
        RetryPolicy adjustedRetryPolicy = CuratorModuleTest.adjustRetryPolicy((BoundedExponentialBackoffRetry)retryPolicy, maxRetries);
        curatorFramework.getZookeeperClient().setRetryPolicy(adjustedRetryPolicy);
        return curatorFramework;
    }

    private static RetryPolicy adjustRetryPolicy(BoundedExponentialBackoffRetry origRetryPolicy, int maxRetries) {
        return new BoundedExponentialBackoffRetry(origRetryPolicy.getBaseSleepTimeMs(), origRetryPolicy.getMaxSleepTimeMs(), maxRetries);
    }
}

