/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowListPlusRawValues;
import org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.segment.realtime.firehose.InlineFirehose;
import org.junit.Assert;
import org.junit.Test;

public class InlineFirehoseTest {
    private static final String DIMENSION_0 = "timestamp";
    private static final String DIMENSION_1 = "value";
    private static final List<String> DIMENSIONS = Arrays.asList("timestamp", "value");
    private static final String DELIMITER = ",";
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private static final StringInputRowParser PARSER = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(DIMENSIONS)), ",", DIMENSIONS, false, 0), CHARSET.name());
    private static final String EMPTY = "";
    private static final String TIMESTAMP_0 = "0";
    private static final String VALUE_0 = "a";
    private static final String NOT_EMPTY = "0,a";
    private static final String PARSEABLE = "0,a";
    private static final String NOT_PARSEABLE = "a,0";
    private static final String TIMESTAMP_1 = "1";
    private static final String VALUE_1 = "b";
    private static final String LINE_0 = "0,a";
    private static final String LINE_1 = "1,b";
    private static final String MULTILINE = "0,a\n1,b";

    @Test
    public void testHasMoreEmpty() {
        InlineFirehose target = InlineFirehoseTest.create(EMPTY);
        Assert.assertFalse((boolean)target.hasMore());
    }

    @Test
    public void testHasMoreNotEmpty() {
        InlineFirehose target = InlineFirehoseTest.create("0,a");
        Assert.assertTrue((boolean)target.hasMore());
    }

    @Test(expected=NoSuchElementException.class)
    public void testNextRowEmpty() {
        InlineFirehose target = InlineFirehoseTest.create(EMPTY);
        target.nextRow();
    }

    @Test
    public void testNextRowNotEmpty() {
        InlineFirehose target = InlineFirehoseTest.create("0,a");
        InputRow row = target.nextRow();
        InlineFirehoseTest.assertRowValue(VALUE_0, row);
    }

    @Test(expected=NoSuchElementException.class)
    public void testNextRowWithRawEmpty() {
        InlineFirehose target = InlineFirehoseTest.create(EMPTY);
        target.nextRowWithRaw();
    }

    @Test
    public void testNextRowWithRawParseable() {
        String data = "0,a";
        InlineFirehose target = InlineFirehoseTest.create("0,a");
        InputRowListPlusRawValues rowPlusRaw = target.nextRowWithRaw();
        InputRow row = (InputRow)Iterables.getOnlyElement((Iterable)rowPlusRaw.getInputRows());
        InlineFirehoseTest.assertRowValue(VALUE_0, row);
        Map raw = rowPlusRaw.getRawValues();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(DIMENSION_0, TIMESTAMP_0);
        expected.put(DIMENSION_1, VALUE_0);
        Assert.assertEquals(expected, (Object)raw);
        Assert.assertNull((Object)rowPlusRaw.getParseException());
    }

    @Test
    public void testNextRowWithRawNotParseable() {
        String data = NOT_PARSEABLE;
        InlineFirehose target = InlineFirehoseTest.create(NOT_PARSEABLE);
        InputRowListPlusRawValues rowPlusRaw = target.nextRowWithRaw();
        Assert.assertNull((Object)rowPlusRaw.getInputRows());
        Map raw = rowPlusRaw.getRawValues();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(DIMENSION_0, VALUE_0);
        expected.put(DIMENSION_1, TIMESTAMP_0);
        Assert.assertEquals(expected, (Object)raw);
        Assert.assertNotNull((Object)rowPlusRaw.getParseException());
    }

    @Test
    public void testCloseOpen() throws IOException {
        InlineFirehose target = InlineFirehoseTest.create("0,a");
        target.close();
        try {
            target.nextRow();
            Assert.fail((String)"Should not be able to read from closed firehose");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testCloseNotOpen() {
        InlineFirehose target = InlineFirehoseTest.create("0,a");
        try {
            target.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Should be able to close an opened firehose");
        }
        try {
            target.close();
        }
        catch (IOException e) {
            Assert.fail((String)"Should be able to close a closed firehose");
        }
    }

    @Test
    public void testMultiline() {
        InlineFirehose target = InlineFirehoseTest.create(MULTILINE);
        Assert.assertTrue((boolean)target.hasMore());
        InputRow row0 = target.nextRow();
        InlineFirehoseTest.assertRowValue(VALUE_0, row0);
        InputRowListPlusRawValues rowPlusRaw = target.nextRowWithRaw();
        InlineFirehoseTest.assertRowValue(VALUE_1, (InputRow)Iterables.getOnlyElement((Iterable)rowPlusRaw.getInputRows()));
        Map raw = rowPlusRaw.getRawValues();
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put(DIMENSION_0, TIMESTAMP_1);
        expected.put(DIMENSION_1, VALUE_1);
        Assert.assertEquals(expected, (Object)raw);
        Assert.assertNull((Object)rowPlusRaw.getParseException());
        Assert.assertFalse((boolean)target.hasMore());
    }

    private static InlineFirehose create(String data) {
        return new InlineFirehose(data, PARSER);
    }

    private static void assertRowValue(String expected, InputRow row) {
        Assert.assertNotNull((Object)row);
        List values = row.getDimension(DIMENSION_1);
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertEquals((Object)expected, values.get(0));
    }
}

