/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.Row;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.data.input.impl.ParseSpec;
import org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.input.SqlTestUtils;
import org.apache.druid.segment.TestHelper;
import org.apache.druid.segment.realtime.firehose.SqlFirehoseFactory;
import org.apache.druid.segment.transform.TransformSpec;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;

public class SqlFirehoseFactoryTest {
    private static final List<File> FIREHOSE_TMP_DIRS = new ArrayList<File>();
    private static File TEST_DIR;
    private final String TABLE_NAME_1 = "FOOS_TABLE_1";
    private final String TABLE_NAME_2 = "FOOS_TABLE_2";
    private final List<String> SQLLIST1 = ImmutableList.of((Object)"SELECT timestamp,a,b FROM FOOS_TABLE_1");
    private final List<String> SQLLIST2 = ImmutableList.of((Object)"SELECT timestamp,a,b FROM FOOS_TABLE_1", (Object)"SELECT timestamp,a,b FROM FOOS_TABLE_2");
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper mapper = TestHelper.makeSmileMapper();
    private final InputRowParser parser = TransformSpec.NONE.decorate((InputRowParser)new MapInputRowParser((ParseSpec)new TimeAndDimsParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("timestamp", "a", "b"))))));
    private TestDerbyConnector derbyConnector;

    @BeforeClass
    public static void setup() throws IOException {
        TEST_DIR = File.createTempFile(SqlFirehoseFactoryTest.class.getSimpleName(), "testDir");
        FileUtils.forceDelete((File)TEST_DIR);
        org.apache.druid.java.util.common.FileUtils.mkdirp((File)TEST_DIR);
    }

    @AfterClass
    public static void teardown() throws IOException {
        FileUtils.forceDelete((File)TEST_DIR);
        for (File dir : FIREHOSE_TMP_DIRS) {
            FileUtils.forceDelete((File)dir);
        }
    }

    private void assertResult(List<Row> rows, List<String> sqls) {
        Assert.assertEquals((long)(10 * sqls.size()), (long)rows.size());
        rows.sort(Comparator.comparing(Row::getTimestamp).thenComparingInt(r -> Integer.valueOf((String)r.getDimension("a").get(0))).thenComparingInt(r -> Integer.valueOf((String)r.getDimension("b").get(0))));
        int rowCount = 0;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < sqls.size(); ++j) {
                Row row = rows.get(rowCount);
                String timestampSt = StringUtils.format((String)"2011-01-12T00:0%s:00.000Z", (Object[])new Object[]{i});
                Assert.assertEquals((Object)timestampSt, (Object)row.getTimestamp().toString());
                Assert.assertEquals((long)i, (long)Integer.valueOf((String)row.getDimension("a").get(0)).intValue());
                Assert.assertEquals((long)i, (long)Integer.valueOf((String)row.getDimension("b").get(0)).intValue());
                ++rowCount;
            }
        }
    }

    private void assertNumRemainingCacheFiles(File firehoseTmpDir, int expectedNumFiles) {
        String[] files = firehoseTmpDir.list();
        Assert.assertNotNull((Object)files);
        Assert.assertEquals((long)expectedNumFiles, (long)files.length);
    }

    private File createFirehoseTmpDir(String dirSuffix) throws IOException {
        File firehoseTempDir = File.createTempFile(SqlFirehoseFactoryTest.class.getSimpleName(), dirSuffix);
        FileUtils.forceDelete((File)firehoseTempDir);
        org.apache.druid.java.util.common.FileUtils.mkdirp((File)firehoseTempDir);
        FIREHOSE_TMP_DIRS.add(firehoseTempDir);
        return firehoseTempDir;
    }

    @Test
    public void testWithoutCacheAndFetch() throws Exception {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable("FOOS_TABLE_1", 10);
        SqlFirehoseFactory factory = new SqlFirehoseFactory(this.SQLLIST1, Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
        ArrayList<Row> rows = new ArrayList<Row>();
        File firehoseTmpDir = this.createFirehoseTmpDir("testWithoutCacheAndFetch");
        try (Firehose firehose = factory.connect(this.parser, firehoseTmpDir);){
            while (firehose.hasMore()) {
                rows.add((Row)firehose.nextRow());
            }
        }
        this.assertResult(rows, this.SQLLIST1);
        this.assertNumRemainingCacheFiles(firehoseTmpDir, 0);
        testUtils.dropTable("FOOS_TABLE_1");
    }

    @Test
    public void testWithoutCache() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable("FOOS_TABLE_1", 10);
        SqlFirehoseFactory factory = new SqlFirehoseFactory(this.SQLLIST1, Long.valueOf(0L), null, null, null, true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
        ArrayList<Row> rows = new ArrayList<Row>();
        File firehoseTmpDir = this.createFirehoseTmpDir("testWithoutCache");
        try (Firehose firehose = factory.connect(this.parser, firehoseTmpDir);){
            while (firehose.hasMore()) {
                rows.add((Row)firehose.nextRow());
            }
        }
        this.assertResult(rows, this.SQLLIST1);
        this.assertNumRemainingCacheFiles(firehoseTmpDir, 0);
        testUtils.dropTable("FOOS_TABLE_1");
    }

    @Test
    public void testWithCacheAndFetch() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable("FOOS_TABLE_1", 10);
        testUtils.createAndUpdateTable("FOOS_TABLE_2", 10);
        SqlFirehoseFactory factory = new SqlFirehoseFactory(this.SQLLIST2, null, null, Long.valueOf(0L), null, true, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), this.mapper);
        ArrayList<Row> rows = new ArrayList<Row>();
        File firehoseTmpDir = this.createFirehoseTmpDir("testWithCacheAndFetch");
        try (Firehose firehose = factory.connect(this.parser, firehoseTmpDir);){
            while (firehose.hasMore()) {
                rows.add((Row)firehose.nextRow());
            }
        }
        this.assertResult(rows, this.SQLLIST2);
        this.assertNumRemainingCacheFiles(firehoseTmpDir, 2);
        testUtils.dropTable("FOOS_TABLE_1");
        testUtils.dropTable("FOOS_TABLE_2");
    }
}

