/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BadJsonQueryException;
import org.apache.druid.query.DefaultGenericQueryMetricsFactory;
import org.apache.druid.query.DefaultQueryConfig;
import org.apache.druid.query.GenericQueryMetricsFactory;
import org.apache.druid.query.MapQueryToolChestWarehouse;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryToolChestWarehouse;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TruncatedResponseContextException;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.QueryPrioritizationStrategy;
import org.apache.druid.server.QueryResource;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QueryStackTests;
import org.apache.druid.server.ResponseContextConfig;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.log.RequestLogger;
import org.apache.druid.server.log.TestRequestLogger;
import org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ThresholdBasedQueryPrioritizationStrategy;
import org.apache.druid.server.security.Access;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthConfig;
import org.apache.druid.server.security.AuthTestUtils;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.easymock.EasyMock;
import org.joda.time.Interval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryResourceTest {
    private static final QueryToolChestWarehouse WAREHOUSE = new MapQueryToolChestWarehouse((Map)ImmutableMap.of());
    private static final AuthenticationResult AUTHENTICATION_RESULT = new AuthenticationResult("druid", "druid", null, null);
    private final HttpServletRequest testServletRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
    private static final QuerySegmentWalker TEST_SEGMENT_WALKER = new QuerySegmentWalker(){

        public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
            return (queryPlus, responseContext) -> Sequences.empty();
        }

        public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
            return this.getQueryRunnerForIntervals(null, null);
        }
    };
    private static final String SIMPLE_TIMESERIES_QUERY = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2015-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ]\n}";
    private static final String SIMPLE_TIMESERIES_QUERY_SMALLISH_INTERVAL = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2014-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ]\n}";
    private static final String SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY = "{\n    \"queryType\": \"timeseries\",\n    \"dataSource\": \"mmx_metrics\",\n    \"granularity\": \"hour\",\n    \"intervals\": [\n      \"2014-12-17/2015-12-30\"\n    ],\n    \"aggregations\": [\n      {\n        \"type\": \"count\",\n        \"name\": \"rows\"\n      }\n    ],\n    \"context\": { \"priority\": -1 }}";
    private static final ServiceEmitter NOOP_SERVICE_EMITTER = new NoopServiceEmitter();
    private static final DruidNode DRUID_NODE = new DruidNode("broker", "localhost", true, Integer.valueOf(8082), null, true, false);
    private ObjectMapper jsonMapper;
    private ObjectMapper smileMapper;
    private QueryResource queryResource;
    private QueryScheduler queryScheduler;
    private TestRequestLogger testRequestLogger;

    @BeforeClass
    public static void staticSetup() {
        EmittingLogger.registerEmitter((ServiceEmitter)NOOP_SERVICE_EMITTER);
    }

    @Before
    public void setup() {
        Injector injector = GuiceInjectors.makeStartupInjector();
        this.jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
        this.smileMapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Smile.class));
        EasyMock.expect((Object)this.testServletRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("Accept")).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        this.queryScheduler = QueryStackTests.DEFAULT_NOOP_SCHEDULER;
        this.testRequestLogger = new TestRequestLogger();
        this.queryResource = this.createQueryResource(ResponseContextConfig.newConfig((boolean)true));
    }

    private QueryResource createQueryResource(ResponseContextConfig responseContextConfig) {
        return new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.smileMapper, this.queryScheduler, new AuthConfig(), null, responseContextConfig, DRUID_NODE);
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.testServletRequest});
    }

    @Test
    public void testGoodQuery() throws IOException {
        this.expectPermissiveHappyPathAuth();
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testGoodQueryWithQueryConfigOverrideDefault() throws IOException {
        String overrideConfigKey = "priority";
        String overrideConfigValue = "678";
        DefaultQueryConfig overrideConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)overrideConfigKey, (Object)overrideConfigValue));
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)overrideConfig)), this.jsonMapper, this.smileMapper, this.queryScheduler, new AuthConfig(), null, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
        this.expectPermissiveHappyPathAuth();
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((StreamingOutput)response.getEntity()).write((OutputStream)baos);
        List responses = (List)this.jsonMapper.readValue(baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext());
        Assert.assertTrue((boolean)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().containsKey(overrideConfigKey));
        Assert.assertEquals((Object)overrideConfigValue, this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().get(overrideConfigKey));
    }

    @Test
    public void testGoodQueryWithQueryConfigDoesNotOverrideQueryContext() throws IOException {
        String overrideConfigKey = "priority";
        String overrideConfigValue = "678";
        DefaultQueryConfig overrideConfig = new DefaultQueryConfig((Map)ImmutableMap.of((Object)overrideConfigKey, (Object)overrideConfigValue));
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)overrideConfig)), this.jsonMapper, this.smileMapper, this.queryScheduler, new AuthConfig(), null, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
        this.expectPermissiveHappyPathAuth();
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((StreamingOutput)response.getEntity()).write((OutputStream)baos);
        List responses = (List)this.jsonMapper.readValue(baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery());
        Assert.assertNotNull((Object)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext());
        Assert.assertTrue((boolean)this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().containsKey(overrideConfigKey));
        Assert.assertEquals((Object)-1, this.testRequestLogger.getNativeQuerylogs().get(0).getQuery().getContext().get(overrideConfigKey));
    }

    @Test
    public void testTruncatedResponseContextShouldFail() throws IOException {
        this.expectPermissiveHappyPathAuth();
        QueryResource queryResource = this.createQueryResource(ResponseContextConfig.forTest((boolean)true, (int)0));
        Response response = queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertEquals((long)1L, (long)queryResource.getInterruptedQueryCount());
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        String expectedException = new QueryInterruptedException((Throwable)new TruncatedResponseContextException("Serialized response context exceeds the max size[0]", new Object[0]), DRUID_NODE.getHostAndPortToUse()).toString();
        Assert.assertEquals((Object)expectedException, (Object)((QueryInterruptedException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryInterruptedException.class)).toString());
    }

    @Test
    public void testTruncatedResponseContextShouldSucceed() throws IOException {
        this.expectPermissiveHappyPathAuth();
        QueryResource queryResource = this.createQueryResource(ResponseContextConfig.forTest((boolean)false, (int)0));
        Response response = queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGoodQueryWithNullAcceptHeader() throws IOException {
        Object acceptHeader = null;
        String contentTypeHeader = "application/json";
        EasyMock.reset((Object[])new Object[]{this.testServletRequest});
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)this.testServletRequest.getHeader("Accept")).andReturn(acceptHeader).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testGoodQueryWithEmptyAcceptHeader() throws IOException {
        String acceptHeader = "";
        String contentTypeHeader = "application/json";
        EasyMock.reset((Object[])new Object[]{this.testServletRequest});
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)this.testServletRequest.getHeader("Accept")).andReturn((Object)"").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testGoodQueryWithJsonRequestAndSmileAcceptHeader() throws IOException {
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        HttpServletRequest smileRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)smileRequest.getContentType()).andReturn((Object)"application/json").anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        smileRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)smileRequest.getHeader("Accept")).andReturn((Object)"application/x-jackson-smile").anyTimes();
        EasyMock.expect((Object)smileRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{smileRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, smileRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
        EasyMock.verify((Object[])new Object[]{smileRequest});
    }

    @Test
    public void testGoodQueryWithSmileRequestAndSmileAcceptHeader() throws IOException {
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        HttpServletRequest smileRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)smileRequest.getContentType()).andReturn((Object)"application/x-jackson-smile").anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        smileRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)smileRequest.getHeader("Accept")).andReturn((Object)"application/x-jackson-smile").anyTimes();
        EasyMock.expect((Object)smileRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{smileRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(this.smileMapper.writeValueAsBytes((Object)this.jsonMapper.readTree(SIMPLE_TIMESERIES_QUERY))), null, smileRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
        EasyMock.verify((Object[])new Object[]{smileRequest});
    }

    @Test
    public void testGoodQueryWithSmileRequestNoSmileAcceptHeader() throws IOException {
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        HttpServletRequest smileRequest = (HttpServletRequest)EasyMock.createMock(HttpServletRequest.class);
        EasyMock.expect((Object)smileRequest.getContentType()).andReturn((Object)"application/x-jackson-smile").anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        smileRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expect((Object)smileRequest.getHeader("Accept")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getHeader("If-None-Match")).andReturn(null).anyTimes();
        EasyMock.expect((Object)smileRequest.getRemoteAddr()).andReturn((Object)"localhost").anyTimes();
        EasyMock.replay((Object[])new Object[]{smileRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(this.smileMapper.writeValueAsBytes((Object)this.jsonMapper.readTree(SIMPLE_TIMESERIES_QUERY))), null, smileRequest);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/x-jackson-smile", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        Assert.assertNotNull((Object)response);
        EasyMock.verify((Object[])new Object[]{smileRequest});
    }

    @Test
    public void testBadQuery() throws IOException {
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream("Meka Leka Hi Meka Hiney Ho".getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        QueryException e = (QueryException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)"Json parse failed", (Object)e.getErrorCode());
        Assert.assertEquals((Object)BadJsonQueryException.ERROR_CLASS, (Object)e.getErrorClass());
    }

    @Test
    public void testResourceLimitExceeded() throws IOException {
        ByteArrayInputStream badQuery = (ByteArrayInputStream)EasyMock.createMock(ByteArrayInputStream.class);
        EasyMock.expect((Object)badQuery.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andThrow((Throwable)new ResourceLimitExceededException("You require too much of something"));
        EasyMock.replay((Object[])new Object[]{badQuery, this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)badQuery, null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        QueryException e = (QueryException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)"Resource limit exceeded", (Object)e.getErrorCode());
        Assert.assertEquals((Object)ResourceLimitExceededException.class.getName(), (Object)e.getErrorClass());
    }

    @Test
    public void testUnsupportedQueryThrowsException() throws IOException {
        String errorMessage = "This will be support in Druid 9999";
        ByteArrayInputStream badQuery = (ByteArrayInputStream)EasyMock.createMock(ByteArrayInputStream.class);
        EasyMock.expect((Object)badQuery.read((byte[])EasyMock.anyObject(), EasyMock.anyInt(), EasyMock.anyInt())).andThrow((Throwable)new QueryUnsupportedException(errorMessage));
        EasyMock.replay((Object[])new Object[]{badQuery});
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        Response response = this.queryResource.doPost((InputStream)badQuery, null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)501L, (long)response.getStatus());
        QueryException ex = (QueryException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryException.class);
        Assert.assertEquals((Object)errorMessage, (Object)ex.getMessage());
        Assert.assertEquals((Object)"Unsupported query", (Object)ex.getErrorCode());
    }

    @Test
    public void testSecuredQuery() throws Exception {
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().times(1);
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (resource.getName().equals("allow")) {
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), authMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.smileMapper, this.queryScheduler, new AuthConfig(), authMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
        try {
            this.queryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
            Assert.fail((String)"doPost did not throw ForbiddenException for an unauthorized query");
        }
        catch (ForbiddenException forbiddenException) {
            // empty catch block
        }
        Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\"}".getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ((StreamingOutput)response.getEntity()).write((OutputStream)baos);
        List responses = (List)this.jsonMapper.readValue(baos.toByteArray(), (TypeReference)new TypeReference<List<Result<TimeBoundaryResultValue>>>(){});
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)responses.size());
        Assert.assertEquals((long)1L, (long)this.testRequestLogger.getNativeQuerylogs().size());
        Assert.assertEquals((Object)true, this.testRequestLogger.getNativeQuerylogs().get(0).getQueryStats().getStats().get("success"));
        Assert.assertEquals((Object)"druid", this.testRequestLogger.getNativeQuerylogs().get(0).getQueryStats().getStats().get("identity"));
    }

    @Test
    public void testQueryTimeoutException() throws Exception {
        QueryTimeoutException ex;
        QuerySegmentWalker timeoutSegmentWalker = new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                throw new QueryTimeoutException();
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                return this.getQueryRunnerForIntervals(null, null);
            }
        };
        QueryResource timeoutQueryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, timeoutSegmentWalker, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.jsonMapper, this.queryScheduler, new AuthConfig(), null, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
        this.expectPermissiveHappyPathAuth();
        Response response = timeoutQueryResource.doPost((InputStream)new ByteArrayInputStream(SIMPLE_TIMESERIES_QUERY.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((long)504L, (long)response.getStatus());
        try {
            ex = (QueryTimeoutException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryTimeoutException.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((Object)"Query Timed Out!", (Object)ex.getMessage());
        Assert.assertEquals((Object)"Query timeout", (Object)ex.getErrorCode());
        Assert.assertEquals((long)1L, (long)timeoutQueryResource.getTimedOutQueryCount());
    }

    @Test(timeout=60000L)
    public void testSecuredCancelQuery() throws Exception {
        final CountDownLatch waitForCancellationLatch = new CountDownLatch(1);
        final CountDownLatch waitFinishLatch = new CountDownLatch(2);
        final CountDownLatch startAwaitLatch = new CountDownLatch(1);
        final CountDownLatch cancelledCountDownLatch = new CountDownLatch(1);
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (action.equals((Object)Action.READ)) {
                            try {
                                startAwaitLatch.countDown();
                                waitForCancellationLatch.await();
                            }
                            catch (InterruptedException e) {
                                cancelledCountDownLatch.countDown();
                                throw new RuntimeException(e);
                            }
                            return new Access(true);
                        }
                        return new Access(true);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), authMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.smileMapper, this.queryScheduler, new AuthConfig(), authMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
        String queryString = "{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query query = (Query)mapper.readValue("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}", Query.class);
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"test_query_resource_%s")).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Response response = QueryResourceTest.this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}".getBytes(StandardCharsets.UTF_8)), null, QueryResourceTest.this.testServletRequest);
                    Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                waitFinishLatch.countDown();
            }
        });
        this.queryScheduler.registerQueryFuture(query, future);
        startAwaitLatch.await();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Response response = QueryResourceTest.this.queryResource.cancelQuery("id_1", QueryResourceTest.this.testServletRequest);
                Assert.assertEquals((long)Response.Status.ACCEPTED.getStatusCode(), (long)response.getStatus());
                waitForCancellationLatch.countDown();
                waitFinishLatch.countDown();
            }
        });
        waitFinishLatch.await();
        cancelledCountDownLatch.await();
    }

    @Test(timeout=60000L)
    public void testDenySecuredCancelQuery() throws Exception {
        final CountDownLatch waitForCancellationLatch = new CountDownLatch(1);
        final CountDownLatch waitFinishLatch = new CountDownLatch(2);
        final CountDownLatch startAwaitLatch = new CountDownLatch(1);
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().times(1);
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)false);
        EasyMock.expectLastCall().times(1);
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
        AuthorizerMapper authMapper = new AuthorizerMapper(null){

            public Authorizer getAuthorizer(String name) {
                return new Authorizer(){

                    public Access authorize(AuthenticationResult authenticationResult, Resource resource, Action action) {
                        if (action.equals((Object)Action.READ)) {
                            try {
                                waitForCancellationLatch.await();
                            }
                            catch (InterruptedException e) {
                                throw new RuntimeException(e);
                            }
                            return new Access(true);
                        }
                        return new Access(false);
                    }
                };
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, TEST_SEGMENT_WALKER, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), authMapper, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.smileMapper, this.queryScheduler, new AuthConfig(), authMapper, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
        String queryString = "{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}";
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        Query query = (Query)mapper.readValue("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}", Query.class);
        ListenableFuture future = MoreExecutors.listeningDecorator((ExecutorService)Execs.singleThreaded((String)"test_query_resource_%s")).submit(new Runnable(){

            @Override
            public void run() {
                try {
                    startAwaitLatch.countDown();
                    Response response = QueryResourceTest.this.queryResource.doPost((InputStream)new ByteArrayInputStream("{\"queryType\":\"timeBoundary\", \"dataSource\":\"allow\",\"context\":{\"queryId\":\"id_1\"}}".getBytes(StandardCharsets.UTF_8)), null, QueryResourceTest.this.testServletRequest);
                    Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                waitFinishLatch.countDown();
            }
        });
        this.queryScheduler.registerQueryFuture(query, future);
        startAwaitLatch.await();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    QueryResourceTest.this.queryResource.cancelQuery("id_1", QueryResourceTest.this.testServletRequest);
                }
                catch (ForbiddenException e) {
                    waitForCancellationLatch.countDown();
                    waitFinishLatch.countDown();
                }
            }
        });
        waitFinishLatch.await();
    }

    @Test(timeout=10000L)
    public void testTooManyQuery() throws InterruptedException {
        this.expectPermissiveHappyPathAuth();
        CountDownLatch waitTwoScheduled = new CountDownLatch(2);
        CountDownLatch waitAllFinished = new CountDownLatch(3);
        QueryScheduler laningScheduler = new QueryScheduler(2, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)NoQueryLaningStrategy.INSTANCE, new ServerConfig());
        this.createScheduledQueryResource(laningScheduler, Collections.emptyList(), (Collection<CountDownLatch>)ImmutableList.of((Object)waitTwoScheduled));
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY, waitAllFinished, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus()));
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY, waitAllFinished, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus()));
        waitTwoScheduled.await();
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY, waitAllFinished, response -> {
            QueryCapacityExceededException ex;
            Assert.assertEquals((long)429L, (long)response.getStatus());
            try {
                ex = (QueryCapacityExceededException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryCapacityExceededException.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((Object)QueryCapacityExceededException.makeTotalErrorMessage((int)2), (Object)ex.getMessage());
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)ex.getErrorCode());
        });
        waitAllFinished.await();
    }

    @Test(timeout=10000L)
    public void testTooManyQueryInLane() throws InterruptedException {
        this.expectPermissiveHappyPathAuth();
        CountDownLatch waitTwoStarted = new CountDownLatch(2);
        CountDownLatch waitOneScheduled = new CountDownLatch(1);
        CountDownLatch waitAllFinished = new CountDownLatch(3);
        QueryScheduler scheduler = new QueryScheduler(40, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(2)), new ServerConfig());
        this.createScheduledQueryResource(scheduler, (Collection<CountDownLatch>)ImmutableList.of((Object)waitTwoStarted), (Collection<CountDownLatch>)ImmutableList.of((Object)waitOneScheduled));
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY, waitAllFinished, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus()));
        waitOneScheduled.await();
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY_LOW_PRIORITY, waitAllFinished, response -> {
            QueryCapacityExceededException ex;
            Assert.assertEquals((long)429L, (long)response.getStatus());
            try {
                ex = (QueryCapacityExceededException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryCapacityExceededException.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((Object)QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)1), (Object)ex.getMessage());
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)ex.getErrorCode());
        });
        waitTwoStarted.await();
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY, waitAllFinished, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus()));
        waitAllFinished.await();
    }

    @Test(timeout=10000L)
    public void testTooManyQueryInLaneImplicitFromDurationThreshold() throws InterruptedException {
        this.expectPermissiveHappyPathAuth();
        CountDownLatch waitTwoStarted = new CountDownLatch(2);
        CountDownLatch waitOneScheduled = new CountDownLatch(1);
        CountDownLatch waitAllFinished = new CountDownLatch(3);
        QueryScheduler scheduler = new QueryScheduler(40, (QueryPrioritizationStrategy)new ThresholdBasedQueryPrioritizationStrategy(null, "P90D", null, null), (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(1)), new ServerConfig());
        this.createScheduledQueryResource(scheduler, (Collection<CountDownLatch>)ImmutableList.of((Object)waitTwoStarted), (Collection<CountDownLatch>)ImmutableList.of((Object)waitOneScheduled));
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY, waitAllFinished, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus()));
        waitOneScheduled.await();
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY, waitAllFinished, response -> {
            QueryCapacityExceededException ex;
            Assert.assertEquals((long)429L, (long)response.getStatus());
            try {
                ex = (QueryCapacityExceededException)this.jsonMapper.readValue((byte[])response.getEntity(), QueryCapacityExceededException.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Assert.assertEquals((Object)QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)1), (Object)ex.getMessage());
            Assert.assertEquals((Object)"Query capacity exceeded", (Object)ex.getErrorCode());
        });
        waitTwoStarted.await();
        this.assertResponseAndCountdownOrBlockForever(SIMPLE_TIMESERIES_QUERY_SMALLISH_INTERVAL, waitAllFinished, response -> Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus()));
        waitAllFinished.await();
    }

    private void createScheduledQueryResource(final QueryScheduler scheduler, final Collection<CountDownLatch> beforeScheduler, final Collection<CountDownLatch> inScheduler) {
        QuerySegmentWalker texasRanger = new QuerySegmentWalker(){

            public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
                return (queryPlus, responseContext) -> {
                    beforeScheduler.forEach(CountDownLatch::countDown);
                    return scheduler.run(scheduler.prioritizeAndLaneQuery(queryPlus, (Set)ImmutableSet.of()), (Sequence)new LazySequence(() -> {
                        inScheduler.forEach(CountDownLatch::countDown);
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return Sequences.empty();
                    }));
                };
            }

            public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
                return this.getQueryRunnerForIntervals(null, null);
            }
        };
        this.queryResource = new QueryResource(new QueryLifecycleFactory(WAREHOUSE, texasRanger, (GenericQueryMetricsFactory)new DefaultGenericQueryMetricsFactory(), (ServiceEmitter)new NoopServiceEmitter(), (RequestLogger)this.testRequestLogger, new AuthConfig(), AuthTestUtils.TEST_AUTHORIZER_MAPPER, Suppliers.ofInstance((Object)new DefaultQueryConfig((Map)ImmutableMap.of()))), this.jsonMapper, this.smileMapper, scheduler, new AuthConfig(), null, ResponseContextConfig.newConfig((boolean)true), DRUID_NODE);
    }

    private void assertResponseAndCountdownOrBlockForever(String query, CountDownLatch done, Consumer<Response> asserts) {
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                Response response = this.queryResource.doPost((InputStream)new ByteArrayInputStream(query.getBytes(StandardCharsets.UTF_8)), null, this.testServletRequest);
                asserts.accept(response);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            done.countDown();
        });
    }

    private void expectPermissiveHappyPathAuth() {
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authorization-Checked")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Allow-Unsecured-Path")).andReturn(null).anyTimes();
        EasyMock.expect((Object)this.testServletRequest.getAttribute("Druid-Authentication-Result")).andReturn((Object)AUTHENTICATION_RESULT).anyTimes();
        this.testServletRequest.setAttribute("Druid-Authorization-Checked", (Object)true);
        EasyMock.expectLastCall().anyTimes();
        EasyMock.replay((Object[])new Object[]{this.testServletRequest});
    }
}

