/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.ServerHolder;

public final class DruidClusterBuilder {
    @Nullable
    private Set<ServerHolder> realtimes = null;
    private final Map<String, Iterable<ServerHolder>> historicals = new HashMap<String, Iterable<ServerHolder>>();
    @Nullable
    private Set<ServerHolder> brokers = null;

    public static DruidClusterBuilder newBuilder() {
        return new DruidClusterBuilder();
    }

    private DruidClusterBuilder() {
    }

    public DruidClusterBuilder withRealtimes(ServerHolder ... realtimes) {
        this.realtimes = new HashSet<ServerHolder>(Arrays.asList(realtimes));
        return this;
    }

    public DruidClusterBuilder withBrokers(ServerHolder ... brokers) {
        this.brokers = new HashSet<ServerHolder>(Arrays.asList(brokers));
        return this;
    }

    public DruidClusterBuilder addTier(String tierName, ServerHolder ... historicals) {
        if (this.historicals.putIfAbsent(tierName, Arrays.asList(historicals)) != null) {
            throw new IllegalArgumentException("Duplicate tier: " + tierName);
        }
        return this;
    }

    public DruidCluster build() {
        return DruidCluster.createDruidClusterFromBuilderInTest(this.realtimes, this.historicals, this.brokers);
    }
}

