/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.druid.data.input.SegmentsSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.BitmapSerde;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.OnheapIncrementalIndex;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.segment.writeout.TmpFileSegmentWriteOutMediumFactory;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Test;

public class UserCompactionTaskQueryTuningConfigTest {
    private static final ObjectMapper OBJECT_MAPPER = new DefaultObjectMapper();

    @Test
    public void testSerdeNulls() throws IOException {
        UserCompactionTaskQueryTuningConfig config = new UserCompactionTaskQueryTuningConfig(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        String json = OBJECT_MAPPER.writeValueAsString((Object)config);
        Assert.assertFalse((boolean)json.contains("maxRowsPerSegment"));
        UserCompactionTaskQueryTuningConfig fromJson = (UserCompactionTaskQueryTuningConfig)OBJECT_MAPPER.readValue(json, UserCompactionTaskQueryTuningConfig.class);
        Assert.assertEquals((Object)config, (Object)fromJson);
    }

    @Test
    public void testSerde() throws IOException {
        UserCompactionTaskQueryTuningConfig tuningConfig = new UserCompactionTaskQueryTuningConfig(Integer.valueOf(40000), (AppendableIndexSpec)new OnheapIncrementalIndex.Spec(Boolean.valueOf(true)), Long.valueOf(2000L), null, (SplitHintSpec)new SegmentsSplitHintSpec(new HumanReadableBytes(42L), null), (PartitionsSpec)new DynamicPartitionsSpec(Integer.valueOf(1000), Long.valueOf(20000L)), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.LZF, CompressionFactory.LongEncodingStrategy.LONGS), new IndexSpec((BitmapSerdeFactory)new BitmapSerde.DefaultBitmapSerdeFactory(), CompressionStrategy.LZ4, CompressionStrategy.UNCOMPRESSED, CompressionFactory.LongEncodingStrategy.AUTO), Integer.valueOf(2), Long.valueOf(1000L), (SegmentWriteOutMediumFactory)TmpFileSegmentWriteOutMediumFactory.instance(), Integer.valueOf(100), Integer.valueOf(5), Long.valueOf(1000L), new Duration(3000L), Integer.valueOf(7), Integer.valueOf(1000), Integer.valueOf(100), Integer.valueOf(2));
        String json = OBJECT_MAPPER.writeValueAsString((Object)tuningConfig);
        UserCompactionTaskQueryTuningConfig fromJson = (UserCompactionTaskQueryTuningConfig)OBJECT_MAPPER.readValue(json, UserCompactionTaskQueryTuningConfig.class);
        Assert.assertEquals((Object)tuningConfig, (Object)fromJson);
    }
}

