/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryException;
import org.apache.druid.query.QueryInterruptedException;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.utils.CloseableUtils;

public class JsonParserIterator<T>
implements Iterator<T>,
Closeable {
    private static final Logger LOG = new Logger(JsonParserIterator.class);
    private JsonParser jp;
    private ObjectCodec objectCodec;
    private final JavaType typeRef;
    private final Future<InputStream> future;
    private final String url;
    private final String host;
    private final ObjectMapper objectMapper;
    private final boolean hasTimeout;
    private final long timeoutAt;
    private final String queryId;

    public JsonParserIterator(JavaType typeRef, Future<InputStream> future, String url, @Nullable Query<T> query, String host, ObjectMapper objectMapper) {
        this.typeRef = typeRef;
        this.future = future;
        this.url = url;
        if (query != null) {
            this.timeoutAt = (Long)query.getContextValue("queryFailTime", (Object)-1L);
            this.queryId = query.getId();
        } else {
            this.timeoutAt = -1L;
            this.queryId = null;
        }
        this.jp = null;
        this.host = host;
        this.objectMapper = objectMapper;
        this.hasTimeout = this.timeoutAt > -1L;
    }

    @Override
    public boolean hasNext() {
        this.init();
        if (this.jp.isClosed()) {
            return false;
        }
        if (this.jp.getCurrentToken() == JsonToken.END_ARRAY) {
            CloseableUtils.closeAndWrapExceptions((Closeable)this.jp);
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        this.init();
        try {
            Object retVal = this.objectCodec.readValue(this.jp, (ResolvedType)this.typeRef);
            this.jp.nextToken();
            return (T)retVal;
        }
        catch (IOException e) {
            if (this.checkTimeout()) {
                QueryTimeoutException timeoutException = this.timeoutQuery();
                timeoutException.addSuppressed((Throwable)e);
                throw timeoutException;
            }
            throw this.convertException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this.jp != null) {
            this.jp.close();
        }
    }

    private boolean checkTimeout() {
        long timeLeftMillis = this.timeoutAt - System.currentTimeMillis();
        return this.checkTimeout(timeLeftMillis);
    }

    private boolean checkTimeout(long timeLeftMillis) {
        return this.hasTimeout && timeLeftMillis < 1L;
    }

    private void init() {
        if (this.jp == null) {
            try {
                InputStream is;
                long timeLeftMillis = this.timeoutAt - System.currentTimeMillis();
                if (this.checkTimeout(timeLeftMillis)) {
                    throw this.timeoutQuery();
                }
                InputStream inputStream = is = this.hasTimeout ? this.future.get(timeLeftMillis, TimeUnit.MILLISECONDS) : this.future.get();
                if (is == null) {
                    if (this.checkTimeout()) {
                        throw this.timeoutQuery();
                    }
                    throw ResourceLimitExceededException.withMessage((String)"Possibly max scatter-gather bytes limit reached while reading from url[%s].", (Object[])new Object[]{this.url});
                }
                this.jp = this.objectMapper.getFactory().createParser(is);
                JsonToken nextToken = this.jp.nextToken();
                if (nextToken != JsonToken.START_ARRAY) {
                    if (nextToken == JsonToken.START_OBJECT) {
                        throw this.convertException((Throwable)this.jp.getCodec().readValue(this.jp, QueryException.class));
                    }
                    throw this.convertException((Throwable)new IAE("Next token wasn't a START_ARRAY, was[%s] from url[%s]", new Object[]{this.jp.getCurrentToken(), this.url}));
                }
                this.jp.nextToken();
                this.objectCodec = this.jp.getCodec();
            }
            catch (CancellationException | ExecutionException e) {
                throw this.convertException(e.getCause() == null ? e : e.getCause());
            }
            catch (IOException | InterruptedException e) {
                throw this.convertException(e);
            }
            catch (TimeoutException e) {
                throw new QueryTimeoutException(StringUtils.nonStrictFormat((String)"Query [%s] timed out!", (Object[])new Object[]{this.queryId}), this.host);
            }
        }
    }

    private QueryTimeoutException timeoutQuery() {
        return new QueryTimeoutException(StringUtils.nonStrictFormat((String)"url[%s] timed out", (Object[])new Object[]{this.url}), this.host);
    }

    private QueryException convertException(Throwable cause) {
        LOG.warn(cause, "Query [%s] to host [%s] interrupted", new Object[]{this.queryId, this.host});
        if (cause instanceof QueryException) {
            QueryException queryException = (QueryException)cause;
            if (queryException.getErrorCode() == null) {
                return new QueryInterruptedException(queryException.getErrorCode(), queryException.getMessage(), queryException.getErrorClass(), this.host);
            }
            switch (queryException.getErrorCode()) {
                case "Query timeout": {
                    return new QueryTimeoutException(queryException.getErrorCode(), queryException.getMessage(), queryException.getErrorClass(), this.host);
                }
                case "Query capacity exceeded": {
                    return new QueryCapacityExceededException(queryException.getErrorCode(), queryException.getMessage(), queryException.getErrorClass(), this.host);
                }
                case "Unsupported query": {
                    return new QueryUnsupportedException(queryException.getErrorCode(), queryException.getMessage(), queryException.getErrorClass(), this.host);
                }
                case "Resource limit exceeded": {
                    return new ResourceLimitExceededException(queryException.getErrorCode(), queryException.getMessage(), queryException.getErrorClass(), this.host);
                }
            }
            return new QueryInterruptedException(queryException.getErrorCode(), queryException.getMessage(), queryException.getErrorClass(), this.host);
        }
        return new QueryInterruptedException(cause, this.host);
    }
}

