/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.ensemble.EnsembleProvider;
import org.apache.curator.ensemble.exhibitor.DefaultExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.exhibitor.ExhibitorRestClient;
import org.apache.curator.ensemble.exhibitor.Exhibitors;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.CompressionProvider;
import org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.curator.shaded.com.google.common.base.Strings;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.curator.ExhibitorConfig;
import org.apache.druid.curator.PotentiallyGzippedCompressionProvider;
import org.apache.druid.curator.ZkEnablementConfig;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public class CuratorModule
implements Module {
    private static final Logger log = new Logger(CuratorModule.class);
    private static final int BASE_SLEEP_TIME_MS = 1000;
    private static final int MAX_SLEEP_TIME_MS = 45000;
    private static final int MAX_RETRIES = 29;

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.zk.service", ZkEnablementConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.zk.service", CuratorConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.exhibitor.service", ExhibitorConfig.class);
    }

    public static CuratorFramework createCurator(CuratorConfig config, EnsembleProvider ensembleProvider) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        if (!Strings.isNullOrEmpty((String)config.getZkUser()) && !Strings.isNullOrEmpty((String)config.getZkPwd())) {
            builder.authorization(config.getAuthScheme(), StringUtils.format((String)"%s:%s", (Object[])new Object[]{config.getZkUser(), config.getZkPwd()}).getBytes(StandardCharsets.UTF_8));
        }
        BoundedExponentialBackoffRetry retryPolicy = new BoundedExponentialBackoffRetry(1000, 45000, 29);
        return builder.ensembleProvider(ensembleProvider).sessionTimeoutMs(config.getZkSessionTimeoutMs()).connectionTimeoutMs(config.getZkConnectionTimeoutMs()).retryPolicy((RetryPolicy)retryPolicy).compressionProvider((CompressionProvider)new PotentiallyGzippedCompressionProvider(config.getEnableCompression())).aclProvider((ACLProvider)(config.getEnableAcl() ? new SecuredACLProvider() : new DefaultACLProvider())).build();
    }

    @Provides
    @LazySingleton
    public CuratorFramework makeCurator(ZkEnablementConfig zkEnablementConfig, CuratorConfig config, EnsembleProvider ensembleProvider, Lifecycle lifecycle) {
        if (!zkEnablementConfig.isEnabled()) {
            throw new RuntimeException("Zookeeper is disabled, cannot create CuratorFramework.");
        }
        final CuratorFramework framework = CuratorModule.createCurator(config, ensembleProvider);
        framework.getUnhandledErrorListenable().addListener((message, e) -> {
            log.error(e, "Unhandled error in Curator, stopping server.", new Object[0]);
            this.shutdown(lifecycle);
        });
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() {
                log.debug("Starting Curator", new Object[0]);
                framework.start();
            }

            public void stop() {
                log.debug("Stopping Curator", new Object[0]);
                framework.close();
            }
        });
        return framework;
    }

    public static EnsembleProvider createEnsembleProvider(CuratorConfig config, ExhibitorConfig exConfig) {
        if (exConfig.getHosts().isEmpty()) {
            return new FixedEnsembleProvider(config.getZkHosts());
        }
        BoundedExponentialBackoffRetry retryPolicy = new BoundedExponentialBackoffRetry(1000, 45000, 29);
        return new ExhibitorEnsembleProvider(new Exhibitors(exConfig.getHosts(), exConfig.getRestPort(), CuratorModule.newBackupProvider(config.getZkHosts())), (ExhibitorRestClient)new DefaultExhibitorRestClient(exConfig.getUseSsl()), exConfig.getRestUriPath(), exConfig.getPollingMs(), (RetryPolicy)retryPolicy){

            public void start() throws Exception {
                log.debug("Polling the list of ZooKeeper servers for the initial ensemble", new Object[0]);
                this.pollForInitialEnsemble();
                super.start();
            }
        };
    }

    @Provides
    @LazySingleton
    public EnsembleProvider makeEnsembleProvider(CuratorConfig config, ExhibitorConfig exConfig) {
        return CuratorModule.createEnsembleProvider(config, exConfig);
    }

    private static Exhibitors.BackupConnectionStringProvider newBackupProvider(String zkHosts) {
        return () -> zkHosts;
    }

    private void shutdown(Lifecycle lifecycle) {
        try {
            lifecycle.stop();
        }
        catch (Throwable t) {
            log.error(t, "Exception when stopping server after unhandled Curator error.", new Object[0]);
        }
        finally {
            System.exit(1);
        }
    }

    static class SecuredACLProvider
    implements ACLProvider {
        SecuredACLProvider() {
        }

        public List<ACL> getDefaultAcl() {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }

        public List<ACL> getAclForPath(String path) {
            return ZooDefs.Ids.CREATOR_ALL_ACL;
        }
    }
}

