/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.storage.derby;

import com.google.inject.Inject;
import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataStorage;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;

public class DerbyMetadataStorage
extends MetadataStorage {
    private static final Logger log = new Logger(DerbyMetadataStorage.class);
    private final NetworkServerControl server;

    @Inject
    public DerbyMetadataStorage(MetadataStorageConnectorConfig config) {
        try {
            this.server = new NetworkServerControl(InetAddress.getByName(config.getHost()), config.getPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void start() {
        try {
            log.info("Starting Derby Metadata Storage", new Object[0]);
            this.server.start(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void stop() {
        try {
            this.server.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

