/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.lookup;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.druid.client.coordinator.Coordinator;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidLeaderClient;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.query.lookup.LookupBean;
import org.apache.druid.query.lookup.LookupConfig;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.LookupListeningAnnouncerConfig;
import org.apache.druid.query.lookup.LookupSnapshotTaker;
import org.apache.druid.query.lookup.LookupUtils;
import org.apache.druid.query.lookup.LookupsState;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

@ManageLifecycle
public class LookupReferencesManager
implements LookupExtractorFactoryContainerProvider {
    private static final EmittingLogger LOG = new EmittingLogger(LookupReferencesManager.class);
    private static final TypeReference<Map<String, Object>> LOOKUPS_ALL_GENERIC_REFERENCE = new TypeReference<Map<String, Object>>(){};
    @VisibleForTesting
    final AtomicReference<LookupUpdateState> stateRef = new AtomicReference();
    @VisibleForTesting
    final LookupSnapshotTaker lookupSnapshotTaker;
    @VisibleForTesting
    final LifecycleLock lifecycleLock = new LifecycleLock();
    @VisibleForTesting
    Thread mainThread;
    private final boolean testMode;
    private final DruidLeaderClient druidLeaderClient;
    private final ObjectMapper jsonMapper;
    private final LookupListeningAnnouncerConfig lookupListeningAnnouncerConfig;
    private final LookupConfig lookupConfig;

    @Inject
    public LookupReferencesManager(LookupConfig lookupConfig, @Json ObjectMapper objectMapper, @Coordinator DruidLeaderClient druidLeaderClient, LookupListeningAnnouncerConfig lookupListeningAnnouncerConfig) {
        this(lookupConfig, objectMapper, druidLeaderClient, lookupListeningAnnouncerConfig, false);
    }

    @VisibleForTesting
    LookupReferencesManager(LookupConfig lookupConfig, ObjectMapper objectMapper, DruidLeaderClient druidLeaderClient, LookupListeningAnnouncerConfig lookupListeningAnnouncerConfig, boolean testMode) {
        this.lookupSnapshotTaker = Strings.isNullOrEmpty((String)lookupConfig.getSnapshotWorkingDir()) ? null : new LookupSnapshotTaker(objectMapper, lookupConfig.getSnapshotWorkingDir());
        this.druidLeaderClient = druidLeaderClient;
        this.jsonMapper = objectMapper;
        this.lookupListeningAnnouncerConfig = lookupListeningAnnouncerConfig;
        this.lookupConfig = lookupConfig;
        this.testMode = testMode;
    }

    @LifecycleStart
    public void start() throws IOException {
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            LOG.debug("LookupExtractorFactoryContainerProvider starting.", new Object[0]);
            if (!Strings.isNullOrEmpty((String)this.lookupConfig.getSnapshotWorkingDir())) {
                FileUtils.mkdirp((File)new File(this.lookupConfig.getSnapshotWorkingDir()));
            }
            this.loadAllLookupsAndInitStateRef();
            if (!this.testMode) {
                this.mainThread = Execs.makeThread((String)"LookupExtractorFactoryContainerProvider-MainThread", () -> {
                    try {
                        if (!this.lifecycleLock.awaitStarted()) {
                            LOG.error("Lifecycle not started, lookup update notices will not be handled.", new Object[0]);
                            return;
                        }
                        while (!Thread.interrupted() && this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS)) {
                            try {
                                this.handlePendingNotices();
                                LockSupport.parkNanos(this, TimeUnit.MINUTES.toNanos(1L));
                            }
                            catch (Throwable t) {
                                LOG.makeAlert(t, "Error occurred while lookup notice handling.", new Object[0]).emit();
                            }
                        }
                    }
                    catch (Throwable t) {
                        LOG.error(t, "Error while waiting for lifecycle start. lookup updates notices will not be handled", new Object[0]);
                    }
                    finally {
                        LOG.info("Lookup Management loop exited. Lookup notices are not handled anymore.", new Object[0]);
                    }
                }, (boolean)true);
                this.mainThread.start();
            }
            LOG.debug("LookupExtractorFactoryContainerProvider started.", new Object[0]);
            this.lifecycleLock.started();
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    @VisibleForTesting
    void handlePendingNotices() {
        if (this.stateRef.get().pendingNotices.isEmpty()) {
            return;
        }
        LookupUpdateState swappedState = this.atomicallyUpdateStateRef(oldState -> new LookupUpdateState((ImmutableMap<String, LookupExtractorFactoryContainer>)((LookupUpdateState)oldState).lookupMap, (ImmutableList<Notice>)ImmutableList.of(), (ImmutableList<Notice>)((LookupUpdateState)oldState).pendingNotices));
        HashMap<String, LookupExtractorFactoryContainer> lookupMap = new HashMap<String, LookupExtractorFactoryContainer>((Map<String, LookupExtractorFactoryContainer>)swappedState.lookupMap);
        for (Notice notice : swappedState.noticesBeingHandled) {
            try {
                notice.handle(lookupMap);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex, "Exception occurred while handling lookup notice [%s].", new Object[]{notice});
                LOG.makeAlert("Exception occurred while handling lookup notice, with message [%s].", new Object[]{ex.getMessage()}).emit();
            }
        }
        this.takeSnapshot(lookupMap);
        ImmutableMap immutableLookupMap = ImmutableMap.copyOf(lookupMap);
        this.atomicallyUpdateStateRef(oldState -> new LookupUpdateState((ImmutableMap<String, LookupExtractorFactoryContainer>)immutableLookupMap, (ImmutableList<Notice>)((LookupUpdateState)oldState).pendingNotices, (ImmutableList<Notice>)ImmutableList.of()));
    }

    @LifecycleStop
    public void stop() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        LOG.debug("LookupExtractorFactoryContainerProvider is stopping.", new Object[0]);
        if (!this.testMode) {
            this.mainThread.interrupt();
            try {
                this.mainThread.join();
            }
            catch (InterruptedException ex) {
                throw new ISE("failed to stop, mainThread couldn't finish.", new Object[0]);
            }
        }
        for (Map.Entry e : this.stateRef.get().lookupMap.entrySet()) {
            try {
                if (((LookupExtractorFactoryContainer)e.getValue()).getLookupExtractorFactory().close()) {
                    LOG.info("Closed lookup [%s].", new Object[]{e.getKey()});
                    continue;
                }
                LOG.error("Failed to close lookup [%s].", new Object[]{e.getKey()});
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex, "Failed to close lookup [%s].", new Object[]{e.getKey()});
            }
        }
        LOG.debug("LookupExtractorFactoryContainerProvider is stopped.", new Object[0]);
    }

    public void add(String lookupName, LookupExtractorFactoryContainer lookupExtractorFactoryContainer) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.addNotice(new LoadNotice(lookupName, lookupExtractorFactoryContainer, this.lookupConfig.getLookupStartRetries()));
    }

    public void remove(String lookupName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        this.addNotice(new DropNotice(lookupName));
    }

    private void addNotice(Notice notice) {
        this.atomicallyUpdateStateRef(oldState -> {
            if (((LookupUpdateState)oldState).pendingNotices.size() > 10000) {
                throw new ISE("There are too many [%d] pendingNotices.", new Object[]{((LookupUpdateState)oldState).pendingNotices.size()});
            }
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)((LookupUpdateState)oldState).pendingNotices);
            builder.add((Object)notice);
            return new LookupUpdateState((ImmutableMap<String, LookupExtractorFactoryContainer>)((LookupUpdateState)oldState).lookupMap, (ImmutableList<Notice>)builder.build(), (ImmutableList<Notice>)((LookupUpdateState)oldState).noticesBeingHandled);
        });
        LockSupport.unpark(this.mainThread);
    }

    public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        return Optional.ofNullable(this.stateRef.get().lookupMap.get((Object)lookupName));
    }

    public Set<String> getAllLookupNames() {
        return this.stateRef.get().lookupMap.keySet();
    }

    LookupsState<LookupExtractorFactoryContainer> getAllLookupsState() {
        Preconditions.checkState((boolean)this.lifecycleLock.awaitStarted(1L, TimeUnit.MILLISECONDS));
        LookupUpdateState lookupUpdateState = this.stateRef.get();
        HashMap<String, LookupExtractorFactoryContainer> lookupsToLoad = new HashMap<String, LookupExtractorFactoryContainer>();
        HashSet<String> lookupsToDrop = new HashSet<String>();
        this.updateToLoadAndDrop((List<Notice>)lookupUpdateState.noticesBeingHandled, lookupsToLoad, lookupsToDrop);
        this.updateToLoadAndDrop((List<Notice>)lookupUpdateState.pendingNotices, lookupsToLoad, lookupsToDrop);
        return new LookupsState((Map)lookupUpdateState.lookupMap, lookupsToLoad, lookupsToDrop);
    }

    private void updateToLoadAndDrop(List<Notice> notices, Map<String, LookupExtractorFactoryContainer> lookupsToLoad, Set<String> lookupsToDrop) {
        for (Notice notice : notices) {
            if (notice instanceof LoadNotice) {
                LoadNotice loadNotice = (LoadNotice)notice;
                lookupsToLoad.put(loadNotice.lookupName, loadNotice.lookupExtractorFactoryContainer);
                lookupsToDrop.remove(loadNotice.lookupName);
                continue;
            }
            if (notice instanceof DropNotice) {
                DropNotice dropNotice = (DropNotice)notice;
                lookupsToDrop.add(dropNotice.lookupName);
                lookupsToLoad.remove(dropNotice.lookupName);
                continue;
            }
            throw new ISE("Unknown Notice type [%s].", new Object[]{notice.getClass().getName()});
        }
    }

    private void takeSnapshot(Map<String, LookupExtractorFactoryContainer> lookupMap) {
        if (this.lookupSnapshotTaker != null) {
            this.lookupSnapshotTaker.takeSnapshot(this.lookupListeningAnnouncerConfig.getLookupTier(), this.getLookupBeanList(lookupMap));
        }
    }

    private void loadAllLookupsAndInitStateRef() {
        List<LookupBean> lookupBeanList = this.getLookupsList();
        if (lookupBeanList != null) {
            this.startLookups(lookupBeanList);
        } else {
            LOG.debug("No lookups to be loaded at this point.", new Object[0]);
            this.stateRef.set(new LookupUpdateState((ImmutableMap<String, LookupExtractorFactoryContainer>)ImmutableMap.of(), (ImmutableList<Notice>)ImmutableList.of(), (ImmutableList<Notice>)ImmutableList.of()));
        }
    }

    @Nullable
    private List<LookupBean> getLookupsList() {
        List<LookupBean> lookupBeanList;
        if (this.lookupConfig.getEnableLookupSyncOnStartup()) {
            lookupBeanList = this.getLookupListFromCoordinator(this.lookupListeningAnnouncerConfig.getLookupTier());
            if (lookupBeanList == null) {
                LOG.info("Coordinator is unavailable. Loading saved snapshot instead", new Object[0]);
                lookupBeanList = this.getLookupListFromSnapshot();
            }
        } else {
            lookupBeanList = this.getLookupListFromSnapshot();
        }
        return lookupBeanList;
    }

    @Nullable
    private List<LookupBean> getLookupListFromCoordinator(String tier) {
        try {
            MutableBoolean firstAttempt = new MutableBoolean(true);
            Map lookupMap = (Map)RetryUtils.retry(() -> {
                if (firstAttempt.isTrue()) {
                    firstAttempt.setValue(false);
                } else if (this.lookupConfig.getCoordinatorRetryDelay() > 0) {
                    Thread.sleep(this.lookupConfig.getCoordinatorRetryDelay());
                }
                return this.tryGetLookupListFromCoordinator(tier);
            }, e -> true, (int)this.lookupConfig.getCoordinatorFetchRetries());
            if (lookupMap != null) {
                ArrayList<LookupBean> lookupBeanList = new ArrayList<LookupBean>();
                lookupMap.forEach((k, v) -> lookupBeanList.add(new LookupBean(k, null, v)));
                return lookupBeanList;
            }
            return null;
        }
        catch (Exception e2) {
            LOG.error((Throwable)e2, "Error while trying to get lookup list from coordinator for tier[%s]", new Object[]{tier});
            return null;
        }
    }

    @Nullable
    private Map<String, LookupExtractorFactoryContainer> tryGetLookupListFromCoordinator(String tier) throws IOException, InterruptedException {
        StringFullResponseHolder response = this.fetchLookupsForTier(tier);
        if (response.getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
            LOG.warn("No lookups found for tier [%s], response [%s]", new Object[]{tier, response});
            return null;
        }
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new IOE("Error while fetching lookup code from Coordinator with status[%s] and content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        if (response.getContent().startsWith("[")) {
            LOG.info("Failed to retrieve lookup information from coordinator, because coordinator appears to be running on older Druid version. Attempting to load lookups using snapshot instead", new Object[0]);
            return null;
        }
        Map lookupNameToGenericConfig = (Map)this.jsonMapper.readValue(response.getContent(), LOOKUPS_ALL_GENERIC_REFERENCE);
        return LookupUtils.tryConvertObjectMapToLookupConfigMap(lookupNameToGenericConfig, this.jsonMapper);
    }

    @Nullable
    private List<LookupBean> getLookupListFromSnapshot() {
        if (this.lookupSnapshotTaker != null) {
            return this.lookupSnapshotTaker.pullExistingSnapshot(this.lookupListeningAnnouncerConfig.getLookupTier());
        }
        return null;
    }

    private List<LookupBean> getLookupBeanList(Map<String, LookupExtractorFactoryContainer> lookupMap) {
        ArrayList<LookupBean> lookups = new ArrayList<LookupBean>(lookupMap.size());
        for (Map.Entry<String, LookupExtractorFactoryContainer> e : lookupMap.entrySet()) {
            lookups.add(new LookupBean(e.getKey(), null, e.getValue()));
        }
        return lookups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLookups(List<LookupBean> lookupBeanList) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ExecutorService executorService = Execs.multiThreaded((int)this.lookupConfig.getNumLookupLoadingThreads(), (String)"LookupExtractorFactoryContainerProvider-Startup-%s");
        ExecutorCompletionService<Map.Entry<String, LookupExtractorFactoryContainer>> completionService = new ExecutorCompletionService<Map.Entry<String, LookupExtractorFactoryContainer>>(executorService);
        ArrayList<LookupBean> remainingLookups = new ArrayList<LookupBean>(lookupBeanList);
        try {
            LOG.info("Starting lookup loading process.", new Object[0]);
            for (int i = 0; i < this.lookupConfig.getLookupStartRetries() && !remainingLookups.isEmpty(); ++i) {
                LOG.info("Round of attempts #%d, [%d] lookups", new Object[]{i + 1, remainingLookups.size()});
                Map<String, LookupExtractorFactoryContainer> successfulLookups = this.startLookups(remainingLookups, completionService);
                builder.putAll(successfulLookups);
                remainingLookups.removeIf(l -> successfulLookups.containsKey(l.getName()));
            }
            if (!remainingLookups.isEmpty()) {
                LOG.warn("Failed to start the following lookups after [%d] attempts: [%s]", new Object[]{this.lookupConfig.getLookupStartRetries(), remainingLookups});
            }
            this.stateRef.set(new LookupUpdateState((ImmutableMap<String, LookupExtractorFactoryContainer>)builder.build(), (ImmutableList<Notice>)ImmutableList.of(), (ImmutableList<Notice>)ImmutableList.of()));
        }
        catch (InterruptedException | RuntimeException e) {
            LOG.error((Throwable)e, "Failed to finish lookup load process.", new Object[0]);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private Map<String, LookupExtractorFactoryContainer> startLookups(List<LookupBean> lookupBeans, CompletionService<Map.Entry<String, LookupExtractorFactoryContainer>> completionService) throws InterruptedException {
        for (LookupBean lookupBean : lookupBeans) {
            completionService.submit(() -> this.startLookup(lookupBean));
        }
        HashMap<String, LookupExtractorFactoryContainer> successfulLookups = new HashMap<String, LookupExtractorFactoryContainer>();
        for (int i = 0; i < lookupBeans.size(); ++i) {
            Future<Map.Entry<String, LookupExtractorFactoryContainer>> completedFuture = completionService.take();
            try {
                Map.Entry<String, LookupExtractorFactoryContainer> lookupResult = completedFuture.get();
                if (lookupResult == null) continue;
                successfulLookups.put(lookupResult.getKey(), lookupResult.getValue());
                continue;
            }
            catch (ExecutionException e) {
                LOG.error(e.getCause(), "Exception while starting a lookup", new Object[0]);
            }
        }
        return successfulLookups;
    }

    @Nullable
    private Map.Entry<String, LookupExtractorFactoryContainer> startLookup(LookupBean lookupBean) {
        LookupExtractorFactoryContainer container = lookupBean.getContainer();
        LOG.info("Starting lookup [%s]:[%s]", new Object[]{lookupBean.getName(), container});
        try {
            if (container.getLookupExtractorFactory().start()) {
                LOG.info("Started lookup [%s]:[%s]", new Object[]{lookupBean.getName(), container});
                return new AbstractMap.SimpleImmutableEntry<String, LookupExtractorFactoryContainer>(lookupBean.getName(), container);
            }
            LOG.error("Failed to start lookup [%s]:[%s]", new Object[]{lookupBean.getName(), container});
            return null;
        }
        catch (RuntimeException e) {
            throw new RE((Throwable)e, "Failed to start lookup [%s]:[%s]", new Object[]{lookupBean.getName(), container});
        }
    }

    private LookupUpdateState atomicallyUpdateStateRef(Function<LookupUpdateState, LookupUpdateState> fn) {
        LookupUpdateState newState;
        LookupUpdateState old;
        while (!this.stateRef.compareAndSet(old = this.stateRef.get(), newState = fn.apply(old))) {
        }
        return newState;
    }

    private StringFullResponseHolder fetchLookupsForTier(String tier) throws InterruptedException, IOException {
        return this.druidLeaderClient.go(this.druidLeaderClient.makeRequest(HttpMethod.GET, StringUtils.format((String)"/druid/coordinator/v1/lookups/config/%s?detailed=true", (Object[])new Object[]{tier})));
    }

    private static class LookupUpdateState {
        private final ImmutableMap<String, LookupExtractorFactoryContainer> lookupMap;
        private final ImmutableList<Notice> pendingNotices;
        private final ImmutableList<Notice> noticesBeingHandled;

        LookupUpdateState(ImmutableMap<String, LookupExtractorFactoryContainer> lookupMap, ImmutableList<Notice> pendingNotices, ImmutableList<Notice> noticesBeingHandled) {
            this.lookupMap = lookupMap;
            this.pendingNotices = pendingNotices;
            this.noticesBeingHandled = noticesBeingHandled;
        }
    }

    private static class DropNotice
    implements Notice {
        private final String lookupName;

        DropNotice(String lookupName) {
            this.lookupName = lookupName;
        }

        @Override
        public void handle(Map<String, LookupExtractorFactoryContainer> lookupMap) {
            LookupExtractorFactoryContainer lookupExtractorFactoryContainer = lookupMap.remove(this.lookupName);
            if (lookupExtractorFactoryContainer != null) {
                LOG.debug("Removed lookup [%s] with spec [%s].", new Object[]{this.lookupName, lookupExtractorFactoryContainer});
                if (!lookupExtractorFactoryContainer.getLookupExtractorFactory().destroy()) {
                    throw new ISE("destroy method returned false for lookup [%s]:[%s]", new Object[]{this.lookupName, lookupExtractorFactoryContainer});
                }
            }
        }

        public String toString() {
            return "DropNotice{lookupName='" + this.lookupName + '\'' + '}';
        }
    }

    private static class LoadNotice
    implements Notice {
        private final String lookupName;
        private final LookupExtractorFactoryContainer lookupExtractorFactoryContainer;
        private final int startRetries;

        LoadNotice(String lookupName, LookupExtractorFactoryContainer lookupExtractorFactoryContainer, int startRetries) {
            this.lookupName = lookupName;
            this.lookupExtractorFactoryContainer = lookupExtractorFactoryContainer;
            this.startRetries = startRetries;
        }

        @Override
        public void handle(Map<String, LookupExtractorFactoryContainer> lookupMap) throws Exception {
            LookupExtractorFactoryContainer old = lookupMap.get(this.lookupName);
            if (old != null && !this.lookupExtractorFactoryContainer.replaces(old)) {
                LOG.warn("got notice to load lookup [%s] that can't replace existing [%s].", new Object[]{this.lookupExtractorFactoryContainer, old});
                return;
            }
            RetryUtils.retry(() -> {
                if (!this.lookupExtractorFactoryContainer.getLookupExtractorFactory().start()) {
                    throw new ISE("start method returned false for lookup [%s]:[%s]", new Object[]{this.lookupName, this.lookupExtractorFactoryContainer});
                }
                return null;
            }, e -> true, (int)this.startRetries);
            old = lookupMap.put(this.lookupName, this.lookupExtractorFactoryContainer);
            LOG.debug("Loaded lookup [%s] with spec [%s].", new Object[]{this.lookupName, this.lookupExtractorFactoryContainer});
            if (old != null && !old.getLookupExtractorFactory().destroy()) {
                throw new ISE("destroy method returned false for lookup [%s]:[%s]", new Object[]{this.lookupName, old});
            }
        }

        public String toString() {
            return "LoadNotice{lookupName='" + this.lookupName + '\'' + ", lookupExtractorFactoryContainer=" + this.lookupExtractorFactoryContainer + '}';
        }
    }

    @VisibleForTesting
    static interface Notice {
        public void handle(Map<String, LookupExtractorFactoryContainer> var1) throws Exception;
    }
}

