/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Bytes;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.client.selector.QueryableDruidServer;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.easymock.EasyMockRunner;
import org.easymock.EasyMockSupport;
import org.easymock.Mock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=EasyMockRunner.class)
public class CachingClusteredClientCacheKeyManagerTest
extends EasyMockSupport {
    @Mock
    private CacheStrategy<Object, Object, Query<Object>> strategy;
    @Mock
    private Query<Object> query;
    @Mock
    private JoinableFactoryWrapper joinableFactoryWrapper;
    @Mock
    private DataSourceAnalysis dataSourceAnalysis;
    private static final byte[] QUERY_CACHE_KEY = new byte[]{1, 2, 3};
    private static final byte[] JOIN_KEY = new byte[]{4, 5};

    @Before
    public void setup() {
        EasyMock.expect((Object)this.strategy.computeCacheKey(this.query)).andReturn((Object)QUERY_CACHE_KEY).anyTimes();
        EasyMock.expect((Object)this.query.getContextValue("bySegment")).andReturn((Object)false).anyTimes();
    }

    @After
    public void teardown() {
        this.verifyAllUnexpectedCalls();
    }

    @Test
    public void testComputeEtag_nonHistorical() {
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(0), (Object)this.makeRealtimeServerSelector(1));
        String actual = keyManager.computeResultLevelCachingEtag((Set)selectors, QUERY_CACHE_KEY);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testComputeEtag_DifferentHistoricals() {
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual1 = keyManager.computeResultLevelCachingEtag((Set)selectors, QUERY_CACHE_KEY);
        Assert.assertNotNull((Object)actual1);
        selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual2 = keyManager.computeResultLevelCachingEtag((Set)selectors, QUERY_CACHE_KEY);
        Assert.assertNotNull((Object)actual2);
        Assert.assertEquals((String)"cache key should not change for same server selectors", (Object)actual1, (Object)actual2);
        selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(2), (Object)this.makeHistoricalServerSelector(1));
        String actual3 = keyManager.computeResultLevelCachingEtag((Set)selectors, QUERY_CACHE_KEY);
        Assert.assertNotNull((Object)actual3);
        Assert.assertNotEquals((Object)actual1, (Object)actual3);
    }

    @Test
    public void testComputeEtag_DifferentQueryCacheKey() {
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual1 = keyManager.computeResultLevelCachingEtag((Set)selectors, new byte[]{1, 2});
        Assert.assertNotNull((Object)actual1);
        String actual2 = keyManager.computeResultLevelCachingEtag((Set)selectors, new byte[]{3, 4});
        Assert.assertNotNull((Object)actual2);
        Assert.assertNotEquals((Object)actual1, (Object)actual2);
    }

    @Test
    public void testComputeEtag_nonJoinDataSource() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)false);
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual1 = keyManager.computeResultLevelCachingEtag((Set)selectors, QUERY_CACHE_KEY);
        Assert.assertNotNull((Object)actual1);
        selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual2 = keyManager.computeResultLevelCachingEtag((Set)selectors, null);
        Assert.assertNotNull((Object)actual2);
        Assert.assertEquals((Object)actual1, (Object)actual2);
    }

    @Test
    public void testComputeEtag_joinWithUnsupportedCaching() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)true);
        EasyMock.expect((Object)this.joinableFactoryWrapper.computeJoinDataSourceCacheKey(this.dataSourceAnalysis)).andReturn(Optional.empty());
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual = keyManager.computeResultLevelCachingEtag((Set)selectors, null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testComputeEtag_joinWithSupportedCaching() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)true).anyTimes();
        EasyMock.expect((Object)this.joinableFactoryWrapper.computeJoinDataSourceCacheKey(this.dataSourceAnalysis)).andReturn(Optional.of(JOIN_KEY));
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual1 = keyManager.computeResultLevelCachingEtag((Set)selectors, null);
        Assert.assertNotNull((Object)actual1);
        EasyMock.reset((Object[])new Object[]{this.joinableFactoryWrapper});
        EasyMock.expect((Object)this.joinableFactoryWrapper.computeJoinDataSourceCacheKey(this.dataSourceAnalysis)).andReturn(Optional.of(new byte[]{9}));
        EasyMock.replay((Object[])new Object[]{this.joinableFactoryWrapper});
        selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual2 = keyManager.computeResultLevelCachingEtag((Set)selectors, null);
        Assert.assertNotNull((Object)actual2);
        Assert.assertNotEquals((Object)actual1, (Object)actual2);
    }

    @Test
    public void testComputeEtag_noEffectifBySegment() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)false);
        EasyMock.reset((Object[])new Object[]{this.query});
        EasyMock.expect((Object)this.query.getContextValue("bySegment")).andReturn((Object)true).anyTimes();
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual = keyManager.computeResultLevelCachingEtag((Set)selectors, null);
        Assert.assertNotNull((Object)actual);
    }

    @Test
    public void testComputeEtag_noEffectIfUseAndPopulateFalse() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)false);
        this.replayAll();
        CachingClusteredClient.CacheKeyManager keyManager = new CachingClusteredClient.CacheKeyManager(this.query, this.strategy, false, false, this.dataSourceAnalysis, this.joinableFactoryWrapper);
        ImmutableSet selectors = ImmutableSet.of((Object)this.makeHistoricalServerSelector(1), (Object)this.makeHistoricalServerSelector(1));
        String actual = keyManager.computeResultLevelCachingEtag((Set)selectors, null);
        Assert.assertNotNull((Object)actual);
    }

    @Test
    public void testSegmentQueryCacheKey_nonJoinDataSource() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)false);
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        byte[] cacheKey = keyManager.computeSegmentLevelQueryCacheKey();
        Assert.assertArrayEquals((byte[])QUERY_CACHE_KEY, (byte[])cacheKey);
    }

    @Test
    public void testSegmentQueryCacheKey_joinWithUnsupportedCaching() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)true);
        EasyMock.expect((Object)this.joinableFactoryWrapper.computeJoinDataSourceCacheKey(this.dataSourceAnalysis)).andReturn(Optional.empty());
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        byte[] cacheKey = keyManager.computeSegmentLevelQueryCacheKey();
        Assert.assertNull((Object)cacheKey);
    }

    @Test
    public void testSegmentQueryCacheKey_joinWithSupportedCaching() {
        EasyMock.expect((Object)this.dataSourceAnalysis.isJoin()).andReturn((Object)true);
        EasyMock.expect((Object)this.joinableFactoryWrapper.computeJoinDataSourceCacheKey(this.dataSourceAnalysis)).andReturn(Optional.of(JOIN_KEY));
        this.replayAll();
        CachingClusteredClient.CacheKeyManager<Object> keyManager = this.makeKeyManager();
        byte[] cacheKey = keyManager.computeSegmentLevelQueryCacheKey();
        Assert.assertArrayEquals((byte[])Bytes.concat((byte[][])new byte[][]{JOIN_KEY, QUERY_CACHE_KEY}), (byte[])cacheKey);
    }

    @Test
    public void testSegmentQueryCacheKey_noCachingIfBySegment() {
        EasyMock.reset((Object[])new Object[]{this.query});
        EasyMock.expect((Object)this.query.getContextValue("bySegment")).andReturn((Object)true).anyTimes();
        this.replayAll();
        byte[] cacheKey = this.makeKeyManager().computeSegmentLevelQueryCacheKey();
        Assert.assertNull((Object)cacheKey);
    }

    @Test
    public void testSegmentQueryCacheKey_useAndPopulateCacheFalse() {
        this.replayAll();
        Assert.assertNull((Object)new CachingClusteredClient.CacheKeyManager(this.query, this.strategy, false, false, this.dataSourceAnalysis, this.joinableFactoryWrapper).computeSegmentLevelQueryCacheKey());
    }

    private CachingClusteredClient.CacheKeyManager<Object> makeKeyManager() {
        return new CachingClusteredClient.CacheKeyManager(this.query, this.strategy, true, true, this.dataSourceAnalysis, this.joinableFactoryWrapper);
    }

    private SegmentServerSelector makeHistoricalServerSelector(int partitionNumber) {
        return this.makeServerSelector(true, partitionNumber);
    }

    private SegmentServerSelector makeRealtimeServerSelector(int partitionNumber) {
        return this.makeServerSelector(false, partitionNumber);
    }

    private SegmentServerSelector makeServerSelector(boolean isHistorical, int partitionNumber) {
        ServerSelector serverSelector = (ServerSelector)this.mock(ServerSelector.class);
        QueryableDruidServer queryableDruidServer = (QueryableDruidServer)this.mock(QueryableDruidServer.class);
        DruidServer server = (DruidServer)this.mock(DruidServer.class);
        SegmentId segmentId = SegmentId.dummy((String)"data-source", (int)partitionNumber);
        DataSegment segment = new DataSegment(segmentId, null, null, null, (ShardSpec)new NumberedShardSpec(partitionNumber, 10), null, Integer.valueOf(0), 0L);
        EasyMock.expect((Object)server.isSegmentReplicationTarget()).andReturn((Object)isHistorical).anyTimes();
        EasyMock.expect((Object)serverSelector.pick(this.query)).andReturn((Object)queryableDruidServer).anyTimes();
        EasyMock.expect((Object)queryableDruidServer.getServer()).andReturn((Object)server).anyTimes();
        EasyMock.expect((Object)serverSelector.getSegment()).andReturn((Object)segment).anyTimes();
        EasyMock.replay((Object[])new Object[]{serverSelector, queryableDruidServer, server});
        return new SegmentServerSelector(serverSelector, segmentId.toDescriptor());
    }
}

