/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.jackson.JacksonModule;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.metadata.input.SqlInputSource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InputSourceModuleTest {
    private final ObjectMapper mapper = new ObjectMapper();
    private final String SQL_NAMED_TYPE = "sql";

    @Before
    public void setUp() {
        for (Module jacksonModule : new InputSourceModule().getJacksonModules()) {
            this.mapper.registerModule(jacksonModule);
        }
    }

    @Test
    public void testSubTypeRegistration() {
        DeserializationConfig config = this.mapper.getDeserializationConfig();
        AnnotatedClass annotatedClass = AnnotatedClassResolver.resolveWithoutSuperTypes((MapperConfig)config, SqlInputSource.class);
        List subtypes = this.mapper.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)config, annotatedClass).stream().map(NamedType::getName).collect(Collectors.toList());
        Assert.assertNotNull(subtypes);
        Assert.assertEquals((Object)"sql", (Object)Iterables.getOnlyElement(subtypes));
    }

    @Test
    public void testHttpInputSourceDefaultConfig() {
        Properties props = new Properties();
        Injector injector = this.makeInjectorWithProperties(props);
        HttpInputSourceConfig instance = (HttpInputSourceConfig)injector.getInstance(HttpInputSourceConfig.class);
        Assert.assertEquals((Object)new HttpInputSourceConfig(null), (Object)instance);
        Assert.assertEquals((Object)HttpInputSourceConfig.DEFAULT_ALLOWED_PROTOCOLS, (Object)instance.getAllowedProtocols());
    }

    private Injector makeInjectorWithProperties(Properties props) {
        return Guice.createInjector((Iterable)ImmutableList.of((Object)new DruidGuiceExtensions(), (Object)new LifecycleModule(), (Object)new ServerModule(), binder -> {
            binder.bind(Validator.class).toInstance((Object)Validation.buildDefaultValidatorFactory().getValidator());
            binder.bind(JsonConfigurator.class).in(LazySingleton.class);
            binder.bind(Properties.class).toInstance((Object)props);
        }, (Object)new JacksonModule(), (Object)new InputSourceModule()));
    }
}

