/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.server.initialization.JdbcAccessSecurityConfig;
import org.junit.Rule;
import org.skife.jdbi.v2.Batch;
import org.skife.jdbi.v2.DBI;

public class SqlTestUtils {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final TestDerbyFirehoseConnector derbyFirehoseConnector;
    private final TestDerbyConnector derbyConnector;

    public SqlTestUtils(TestDerbyConnector derbyConnector) {
        this.derbyConnector = derbyConnector;
        this.derbyFirehoseConnector = new TestDerbyFirehoseConnector(new MetadataStorageConnectorConfig(), derbyConnector.getDBI());
    }

    public void createAndUpdateTable(String tableName, int numEntries) {
        this.derbyConnector.createTable(tableName, (Iterable)ImmutableList.of((Object)StringUtils.format((String)"CREATE TABLE %1$s (\n  timestamp varchar(255) NOT NULL,\n  a VARCHAR(255) NOT NULL,\n  b VARCHAR(255) NOT NULL\n)", (Object[])new Object[]{tableName})));
        this.derbyConnector.getDBI().withHandle(handle -> {
            Batch batch = handle.createBatch();
            for (int i = 0; i < numEntries; ++i) {
                String timestampSt = StringUtils.format((String)"2011-01-12T00:0%s:00.000Z", (Object[])new Object[]{i});
                batch.add(StringUtils.format((String)"INSERT INTO %1$s (timestamp, a, b) VALUES ('%2$s', '%3$s', '%4$s')", (Object[])new Object[]{tableName, timestampSt, i, i}));
            }
            batch.execute();
            return null;
        });
    }

    public void dropTable(String tableName) {
        this.derbyConnector.getDBI().withHandle(handle -> {
            handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
            return null;
        });
    }

    public TestDerbyFirehoseConnector getDerbyFirehoseConnector() {
        return this.derbyFirehoseConnector;
    }

    private static class TestDerbyFirehoseConnector
    extends SQLFirehoseDatabaseConnector {
        private final DBI dbi;

        private TestDerbyFirehoseConnector(@JsonProperty(value="connectorConfig") MetadataStorageConnectorConfig metadataStorageConnectorConfig, DBI dbi) {
            BasicDataSource datasource = this.getDatasource(metadataStorageConnectorConfig, new JdbcAccessSecurityConfig(){

                public Set<String> getAllowedProperties() {
                    return ImmutableSet.of((Object)"user", (Object)"create");
                }
            });
            datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            datasource.setDriverClassName("org.apache.derby.jdbc.ClientDriver");
            this.dbi = dbi;
        }

        public DBI getDBI() {
            return this.dbi;
        }

        public Set<String> findPropertyKeysFromConnectURL(String connectUri, boolean allowUnknown) {
            return ImmutableSet.of((Object)"user", (Object)"create");
        }
    }
}

