/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.Queries;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.ReferenceCountingSegmentQueryRunner;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TestClusterQuerySegmentWalker
implements QuerySegmentWalker {
    private final Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines;
    private final JoinableFactoryWrapper joinableFactoryWrapper;
    private final QueryRunnerFactoryConglomerate conglomerate;
    @Nullable
    private final QueryScheduler scheduler;

    TestClusterQuerySegmentWalker(Map<String, VersionedIntervalTimeline<String, ReferenceCountingSegment>> timelines, JoinableFactoryWrapper joinableFactoryWrapper, QueryRunnerFactoryConglomerate conglomerate, @Nullable QueryScheduler scheduler) {
        this.timelines = timelines;
        this.joinableFactoryWrapper = joinableFactoryWrapper;
        this.conglomerate = conglomerate;
        this.scheduler = scheduler;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        return (queryPlus, responseContext) -> {
            DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)queryPlus.getQuery().getDataSource());
            if (!analysis.isConcreteTableBased()) {
                throw new ISE("Cannot handle datasource: %s", new Object[]{queryPlus.getQuery().getDataSource()});
            }
            String dataSourceName = ((TableDataSource)analysis.getBaseDataSource()).getName();
            FunctionalIterable segmentDescriptors = FunctionalIterable.create((Iterable)intervals).transformCat(interval -> this.getSegmentsForTable(dataSourceName, (Interval)interval)).transform(WindowedSegment::getDescriptor);
            return this.getQueryRunnerForSegments(queryPlus.getQuery(), (Iterable<SegmentDescriptor>)segmentDescriptors).run(queryPlus, responseContext);
        };
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            throw new ISE("Unknown query type[%s].", new Object[]{query.getClass()});
        }
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)query.getDataSource());
        if (!analysis.isConcreteTableBased()) {
            throw new ISE("Cannot handle datasource: %s", new Object[]{query.getDataSource()});
        }
        String dataSourceName = ((TableDataSource)analysis.getBaseDataSource()).getName();
        QueryToolChest toolChest = factory.getToolchest();
        if (analysis.isQuery() && !toolChest.canPerformSubquery(((QueryDataSource)analysis.getDataSource()).getQuery())) {
            throw new ISE("Cannot handle subquery: %s", new Object[]{analysis.getDataSource()});
        }
        Function segmentMapFn = this.joinableFactoryWrapper.createSegmentMapFn((Filter)analysis.getJoinBaseTableFilter().map(Filters::toFilter).orElse(null), analysis.getPreJoinableClauses(), new AtomicLong(), analysis.getBaseQuery().orElse(query));
        FinalizeResultsQueryRunner baseRunner = new FinalizeResultsQueryRunner(toolChest.postMergeQueryDecoration(toolChest.mergeResults(toolChest.preMergeQueryDecoration(this.makeTableRunner(toolChest, factory, this.getSegmentsForTable(dataSourceName, specs), segmentMapFn)))), toolChest);
        return (arg_0, arg_1) -> this.lambda$getQueryRunnerForSegments$4(specs, (QueryRunner)baseRunner, arg_0, arg_1);
    }

    private <T> QueryRunner<T> makeTableRunner(QueryToolChest<T, Query<T>> toolChest, QueryRunnerFactory<T, Query<T>> factory, Iterable<WindowedSegment> segments, Function<SegmentReference, SegmentReference> segmentMapFn) {
        ArrayList segmentsList = Lists.newArrayList(segments);
        if (segmentsList.isEmpty()) {
            return new NoopQueryRunner();
        }
        return new FinalizeResultsQueryRunner(toolChest.mergeResults(factory.mergeRunners((ExecutorService)Execs.directExecutor(), (Iterable)FunctionalIterable.create((Iterable)segmentsList).transform(segment -> new SpecificSegmentQueryRunner((QueryRunner)new ReferenceCountingSegmentQueryRunner(factory, (SegmentReference)segmentMapFn.apply((SegmentReference)segment.getSegment()), segment.getDescriptor()), new SpecificSegmentSpec(segment.getDescriptor()))))), toolChest);
    }

    private List<WindowedSegment> getSegmentsForTable(String dataSource, Interval interval) {
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.timelines.get(dataSource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<WindowedSegment> retVal = new ArrayList<WindowedSegment>();
        for (TimelineObjectHolder holder : timeline.lookup(interval)) {
            for (PartitionChunk chunk : holder.getObject()) {
                retVal.add(new WindowedSegment((ReferenceCountingSegment)chunk.getObject(), holder.getInterval()));
            }
        }
        return retVal;
    }

    private List<WindowedSegment> getSegmentsForTable(String dataSource, Iterable<SegmentDescriptor> specs) {
        VersionedIntervalTimeline<String, ReferenceCountingSegment> timeline = this.timelines.get(dataSource);
        if (timeline == null) {
            return Collections.emptyList();
        }
        ArrayList<WindowedSegment> retVal = new ArrayList<WindowedSegment>();
        for (SegmentDescriptor spec : specs) {
            PartitionChunk entry = timeline.findChunk(spec.getInterval(), (Object)spec.getVersion(), spec.getPartitionNumber());
            retVal.add(new WindowedSegment((ReferenceCountingSegment)entry.getObject(), spec.getInterval()));
        }
        return retVal;
    }

    private /* synthetic */ Sequence lambda$getQueryRunnerForSegments$4(Iterable specs, QueryRunner baseRunner, QueryPlus theQuery, ResponseContext responseContext) {
        responseContext.initializeRemainingResponses();
        responseContext.addRemainingResponse(theQuery.getQuery().getMostSpecificId(), 0);
        if (this.scheduler != null) {
            HashSet segments = new HashSet();
            specs.forEach(spec -> segments.add(new SegmentServerSelector(spec)));
            return this.scheduler.run(this.scheduler.prioritizeAndLaneQuery(theQuery, segments), (Sequence)new LazySequence(() -> baseRunner.run(theQuery.withQuery(Queries.withSpecificSegments((Query)theQuery.getQuery(), (List)ImmutableList.copyOf((Iterable)specs))), responseContext)));
        }
        return baseRunner.run(theQuery.withQuery(Queries.withSpecificSegments((Query)theQuery.getQuery(), (List)ImmutableList.copyOf((Iterable)specs))), responseContext);
    }

    private static class WindowedSegment {
        private final ReferenceCountingSegment segment;
        private final Interval interval;

        public WindowedSegment(ReferenceCountingSegment segment, Interval interval) {
            this.segment = segment;
            this.interval = interval;
            Preconditions.checkArgument((boolean)segment.getId().getInterval().contains((ReadableInterval)interval));
        }

        public ReferenceCountingSegment getSegment() {
            return this.segment;
        }

        public Interval getInterval() {
            return this.interval;
        }

        public SegmentDescriptor getDescriptor() {
            return new SegmentDescriptor(this.interval, this.segment.getId().getVersion(), this.segment.getId().getPartitionNum());
        }
    }
}

