/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.metadata.MetadataSupervisorManager;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.KillSupervisorsCustomDuty;
import org.joda.time.Duration;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KillSupervisorsCustomDutyTest {
    @Mock
    private MetadataSupervisorManager mockMetadataSupervisorManager;
    @Mock
    private DruidCoordinatorRuntimeParams mockDruidCoordinatorRuntimeParams;
    @Mock
    private ServiceEmitter mockServiceEmitter;
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private KillSupervisorsCustomDuty killSupervisors;

    @Test
    public void testConstructorFailIfRetainDurationNull() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("(Custom Duty) Coordinator supervisor kill retainDuration must be >= 0");
        this.killSupervisors = new KillSupervisorsCustomDuty(null, this.mockMetadataSupervisorManager);
    }

    @Test
    public void testConstructorFailIfRetainDurationInvalid() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("(Custom Duty) Coordinator supervisor kill retainDuration must be >= 0");
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT-1s"), this.mockMetadataSupervisorManager);
    }

    @Test
    public void testConstructorSuccess() {
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), this.mockMetadataSupervisorManager);
        Assert.assertNotNull((Object)this.killSupervisors);
    }

    @Test
    public void testRun() {
        Mockito.when((Object)this.mockDruidCoordinatorRuntimeParams.getEmitter()).thenReturn((Object)this.mockServiceEmitter);
        this.killSupervisors = new KillSupervisorsCustomDuty(new Duration((Object)"PT1S"), this.mockMetadataSupervisorManager);
        this.killSupervisors.run(this.mockDruidCoordinatorRuntimeParams);
        ((MetadataSupervisorManager)Mockito.verify((Object)this.mockMetadataSupervisorManager)).removeTerminatedSupervisorsOlderThan(ArgumentMatchers.anyLong());
        ((ServiceEmitter)Mockito.verify((Object)this.mockServiceEmitter)).emit((ServiceEventBuilder)ArgumentMatchers.any(ServiceEventBuilder.class));
    }
}

