/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.primitives.Bytes;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.apache.druid.client.CacheUtil;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class CachingQueryRunner<T>
implements QueryRunner<T> {
    private final String cacheId;
    private final SegmentDescriptor segmentDescriptor;
    private final Interval actualDataInterval;
    private final Optional<byte[]> cacheKeyPrefix;
    private final QueryRunner<T> base;
    private final QueryToolChest toolChest;
    private final Cache cache;
    private final ObjectMapper mapper;
    private final CachePopulator cachePopulator;
    private final CacheConfig cacheConfig;

    public CachingQueryRunner(String cacheId, Optional<byte[]> cacheKeyPrefix, SegmentDescriptor segmentDescriptor, Interval actualDataInterval, ObjectMapper mapper, Cache cache, QueryToolChest toolchest, QueryRunner<T> base, CachePopulator cachePopulator, CacheConfig cacheConfig) {
        this.cacheKeyPrefix = cacheKeyPrefix;
        this.base = base;
        this.cacheId = cacheId;
        this.segmentDescriptor = segmentDescriptor;
        this.actualDataInterval = actualDataInterval;
        this.toolChest = toolchest;
        this.cache = cache;
        this.mapper = mapper;
        this.cachePopulator = cachePopulator;
        this.cacheConfig = cacheConfig;
    }

    public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
        Function cacheFn;
        Query query = queryPlus.getQuery();
        CacheStrategy strategy = this.toolChest.getCacheStrategy(query);
        boolean populateCache = this.canPopulateCache(query, strategy);
        boolean useCache = this.canUseCache(query, strategy);
        Cache.NamedKey key = useCache || populateCache ? CacheUtil.computeSegmentCacheKey(this.cacheId, this.alignToActualDataInterval(this.segmentDescriptor), Bytes.concat((byte[][])new byte[][]{this.cacheKeyPrefix.get(), strategy.computeCacheKey(query)})) : null;
        if (useCache) {
            cacheFn = strategy.pullFromSegmentLevelCache();
            final byte[] cachedResult = this.cache.get(key);
            if (cachedResult != null) {
                final TypeReference cacheObjectClazz = strategy.getCacheObjectClazz();
                return Sequences.map((Sequence)new BaseSequence(new BaseSequence.IteratorMaker<T, Iterator<T>>(){

                    public Iterator<T> make() {
                        try {
                            if (cachedResult.length == 0) {
                                return Collections.emptyIterator();
                            }
                            return CachingQueryRunner.this.mapper.readValues(CachingQueryRunner.this.mapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    public void cleanup(Iterator<T> iterFromMake) {
                    }
                }), (Function)cacheFn);
            }
        }
        if (populateCache) {
            cacheFn = strategy.prepareForSegmentLevelCache();
            return this.cachePopulator.wrap(this.base.run(queryPlus, responseContext), value -> cacheFn.apply(value), this.cache, key);
        }
        return this.base.run(queryPlus, responseContext);
    }

    @VisibleForTesting
    boolean canUseCache(Query<T> query, CacheStrategy strategy) {
        return CacheUtil.isUseSegmentCache(query, strategy, this.cacheConfig, CacheUtil.ServerType.DATA) && this.cacheKeyPrefix.isPresent();
    }

    @VisibleForTesting
    boolean canPopulateCache(Query<T> query, CacheStrategy strategy) {
        return CacheUtil.isPopulateSegmentCache(query, strategy, this.cacheConfig, CacheUtil.ServerType.DATA) && this.cacheKeyPrefix.isPresent();
    }

    private SegmentDescriptor alignToActualDataInterval(SegmentDescriptor in) {
        Interval interval = in.getInterval();
        return new SegmentDescriptor(interval.overlaps((ReadableInterval)this.actualDataInterval) ? interval.overlap((ReadableInterval)this.actualDataInterval) : interval, in.getVersion(), in.getPartitionNumber());
    }
}

