/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import com.google.common.base.Predicate;
import org.apache.druid.client.ServerView;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;

public class FilteringSegmentCallback
implements ServerView.SegmentCallback {
    private final ServerView.SegmentCallback callback;
    private final Predicate<Pair<DruidServerMetadata, DataSegment>> filter;

    public FilteringSegmentCallback(ServerView.SegmentCallback callback, Predicate<Pair<DruidServerMetadata, DataSegment>> filter) {
        this.callback = callback;
        this.filter = filter;
    }

    @Override
    public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
        ServerView.CallbackAction action = this.filter.apply((Object)Pair.of((Object)server, (Object)segment)) ? this.callback.segmentAdded(server, segment) : ServerView.CallbackAction.CONTINUE;
        return action;
    }

    @Override
    public ServerView.CallbackAction segmentRemoved(DruidServerMetadata server, DataSegment segment) {
        ServerView.CallbackAction action = this.filter.apply((Object)Pair.of((Object)server, (Object)segment)) ? this.callback.segmentRemoved(server, segment) : ServerView.CallbackAction.CONTINUE;
        return action;
    }

    @Override
    public ServerView.CallbackAction segmentViewInitialized() {
        return this.callback.segmentViewInitialized();
    }
}

