/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.druid.data.input.FiniteFirehoseFactory;
import org.apache.druid.data.input.Firehose;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.java.util.emitter.EmittingLogger;

public class CombiningFirehoseFactory
implements FiniteFirehoseFactory<InputRowParser, List<FirehoseFactory>> {
    private static final EmittingLogger log = new EmittingLogger(CombiningFirehoseFactory.class);
    private final List<FirehoseFactory> delegateFactoryList;

    @JsonCreator
    public CombiningFirehoseFactory(@JsonProperty(value="delegates") List<FirehoseFactory> delegateFactoryList) {
        Preconditions.checkArgument((!delegateFactoryList.isEmpty() ? 1 : 0) != 0);
        this.delegateFactoryList = delegateFactoryList;
    }

    public Firehose connect(InputRowParser parser, File temporaryDirectory) {
        return new CombiningFirehose(parser, temporaryDirectory);
    }

    @JsonProperty(value="delegates")
    public List<FirehoseFactory> getDelegateFactoryList() {
        return this.delegateFactoryList;
    }

    public boolean isSplittable() {
        return false;
    }

    public Stream<InputSplit<List<FirehoseFactory>>> getSplits(@Nullable SplitHintSpec splitHintSpec) {
        return Stream.of(new InputSplit(this.delegateFactoryList));
    }

    public int getNumSplits(@Nullable SplitHintSpec splitHintSpec) {
        return 1;
    }

    public FiniteFirehoseFactory<InputRowParser, List<FirehoseFactory>> withSplit(InputSplit<List<FirehoseFactory>> split) {
        return new CombiningFirehoseFactory((List)split.get());
    }

    class CombiningFirehose
    implements Firehose {
        private final InputRowParser parser;
        private final File temporaryDirectory;
        private final Iterator<FirehoseFactory> firehoseFactoryIterator;
        private volatile Firehose currentFirehose;

        CombiningFirehose(InputRowParser parser, File temporaryDirectory) {
            this.firehoseFactoryIterator = CombiningFirehoseFactory.this.delegateFactoryList.iterator();
            this.parser = parser;
            this.temporaryDirectory = temporaryDirectory;
            this.nextFirehose();
        }

        private void nextFirehose() {
            if (this.firehoseFactoryIterator.hasNext()) {
                try {
                    if (this.currentFirehose != null) {
                        this.currentFirehose.close();
                    }
                    this.currentFirehose = this.firehoseFactoryIterator.next().connect(this.parser, this.temporaryDirectory);
                }
                catch (IOException e) {
                    if (this.currentFirehose != null) {
                        try {
                            this.currentFirehose.close();
                        }
                        catch (IOException e2) {
                            log.error((Throwable)e, "Unable to close currentFirehose!", new Object[0]);
                            throw new RuntimeException(e2);
                        }
                    }
                    throw new RuntimeException(e);
                }
            }
        }

        public boolean hasMore() throws IOException {
            return this.currentFirehose.hasMore();
        }

        @Nullable
        public InputRow nextRow() throws IOException {
            InputRow rv = this.currentFirehose.nextRow();
            if (!this.currentFirehose.hasMore()) {
                this.nextFirehose();
            }
            return rv;
        }

        public void close() throws IOException {
            this.currentFirehose.close();
        }
    }
}

