/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.druid.curator.discovery.ServiceAnnouncer;
import org.apache.druid.guice.annotations.RemoteChatHandler;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.realtime.firehose.ChatHandlerProvider;
import org.apache.druid.server.DruidNode;

public class ServiceAnnouncingChatHandlerProvider
implements ChatHandlerProvider {
    private static final Logger log = new Logger(ServiceAnnouncingChatHandlerProvider.class);
    private final DruidNode node;
    private final ServiceAnnouncer serviceAnnouncer;
    private final ConcurrentMap<String, ChatHandler> handlers;
    private final ConcurrentSkipListSet<String> announcements;

    @Inject
    public ServiceAnnouncingChatHandlerProvider(@RemoteChatHandler DruidNode node, ServiceAnnouncer serviceAnnouncer) {
        this.node = node;
        this.serviceAnnouncer = serviceAnnouncer;
        this.handlers = new ConcurrentHashMap<String, ChatHandler>();
        this.announcements = new ConcurrentSkipListSet();
    }

    @Override
    public void register(String service, ChatHandler handler) {
        this.register(service, handler, true);
    }

    @Override
    public void register(String service, ChatHandler handler, boolean announce) {
        log.debug("Registering Eventhandler[%s]", new Object[]{service});
        if (this.handlers.putIfAbsent(service, handler) != null) {
            throw new ISE("handler already registered for service[%s]", new Object[]{service});
        }
        if (announce) {
            try {
                this.serviceAnnouncer.announce(this.makeDruidNode(service));
                if (!this.announcements.add(service)) {
                    throw new ISE("announcements already has an entry for service[%s]", new Object[]{service});
                }
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Failed to register service[%s]", new Object[]{service});
                this.handlers.remove(service, handler);
            }
        }
    }

    @Override
    public void unregister(String service) {
        log.debug("Unregistering chat handler[%s]", new Object[]{service});
        ChatHandler handler = (ChatHandler)this.handlers.get(service);
        if (handler == null) {
            log.warn("handler[%s] not currently registered, ignoring.", new Object[]{service});
            return;
        }
        if (this.announcements.contains(service)) {
            try {
                this.serviceAnnouncer.unannounce(this.makeDruidNode(service));
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Failed to unregister service[%s]", new Object[]{service});
            }
            this.announcements.remove(service);
        }
        this.handlers.remove(service, handler);
    }

    @Override
    public Optional<ChatHandler> get(String key) {
        return Optional.fromNullable(this.handlers.get(key));
    }

    private DruidNode makeDruidNode(String key) {
        return new DruidNode(key, this.node.getHost(), this.node.isBindOnHost(), this.node.getPlaintextPort(), this.node.getTlsPort(), this.node.isEnablePlaintextPort(), this.node.isEnableTlsPort());
    }
}

