/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.druid.client.DruidServerConfig;
import org.apache.druid.guice.ExtensionsLoader;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.http.security.ConfigResourceFilter;
import org.apache.druid.server.http.security.StateResourceFilter;
import org.apache.druid.utils.JvmUtils;
import org.apache.druid.utils.RuntimeInfo;

@Path(value="/status")
public class StatusResource {
    private final Properties properties;
    private final DruidServerConfig druidServerConfig;
    private final ExtensionsLoader extnLoader;

    @Inject
    public StatusResource(Properties properties, DruidServerConfig druidServerConfig, ExtensionsLoader extnLoader) {
        this.properties = properties;
        this.druidServerConfig = druidServerConfig;
        this.extnLoader = extnLoader;
    }

    @GET
    @Path(value="/properties")
    @ResourceFilters(value={ConfigResourceFilter.class})
    @Produces(value={"application/json"})
    public Map<String, String> getProperties() {
        ImmutableMap allProperties = Maps.fromProperties((Properties)this.properties);
        Set<String> hiddenProperties = this.druidServerConfig.getHiddenProperties();
        return this.filterHiddenProperties(hiddenProperties, (Map<String, String>)allProperties);
    }

    @Nonnull
    private Map<String, String> filterHiddenProperties(Set<String> hiddenProperties, Map<String, String> allProperties) {
        HashMap<String, String> propertyCopy = new HashMap<String, String>(allProperties);
        allProperties.keySet().forEach(key -> {
            if (hiddenProperties.stream().anyMatch(hiddenProperty -> StringUtils.toLowerCase((String)key).contains(StringUtils.toLowerCase((String)hiddenProperty)))) {
                propertyCopy.remove(key);
            }
        });
        return propertyCopy;
    }

    @GET
    @ResourceFilters(value={StateResourceFilter.class})
    @Produces(value={"application/json"})
    public Status doGet(@Context HttpServletRequest req) {
        return new Status(this.extnLoader.getLoadedModules());
    }

    @GET
    @Path(value="/health")
    @Produces(value={"application/json"})
    public boolean getHealth() {
        return true;
    }

    public static class Memory {
        final long maxMemory;
        final long totalMemory;
        final long freeMemory;
        final long usedMemory;
        final long directMemory;

        public Memory(RuntimeInfo runtime) {
            this.maxMemory = runtime.getMaxHeapSizeBytes();
            this.totalMemory = runtime.getTotalHeapSizeBytes();
            this.freeMemory = runtime.getFreeHeapSizeBytes();
            this.usedMemory = this.totalMemory - this.freeMemory;
            long directMemory = -1L;
            try {
                directMemory = runtime.getDirectMemorySizeBytes();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.directMemory = directMemory;
        }

        @JsonProperty
        public long getMaxMemory() {
            return this.maxMemory;
        }

        @JsonProperty
        public long getTotalMemory() {
            return this.totalMemory;
        }

        @JsonProperty
        public long getFreeMemory() {
            return this.freeMemory;
        }

        @JsonProperty
        public long getUsedMemory() {
            return this.usedMemory;
        }

        @JsonProperty
        public long getDirectMemory() {
            return this.directMemory;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ModuleVersion {
        final String name;
        final String artifact;
        final String version;

        public ModuleVersion(String name, String artifact, String version) {
            this.name = name;
            this.artifact = artifact;
            this.version = version;
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public String getArtifact() {
            return this.artifact;
        }

        @JsonProperty
        public String getVersion() {
            return this.version;
        }

        public String toString() {
            if (this.artifact == null || this.artifact.isEmpty()) {
                return StringUtils.format((String)"  - %s ", (Object[])new Object[]{this.name});
            }
            return StringUtils.format((String)"  - %s (%s-%s)", (Object[])new Object[]{this.name, this.artifact, this.version});
        }
    }

    public static class Status {
        final String version = this.getDruidVersion();
        final List<ModuleVersion> modules;
        final Memory memory;

        public Status(Collection<DruidModule> modules) {
            this.modules = this.getExtensionVersions(modules);
            this.memory = new Memory(JvmUtils.getRuntimeInfo());
        }

        private String getDruidVersion() {
            return Status.class.getPackage().getImplementationVersion();
        }

        @JsonProperty
        public String getVersion() {
            return this.version;
        }

        @JsonProperty
        public List<ModuleVersion> getModules() {
            return this.modules;
        }

        @JsonProperty
        public Memory getMemory() {
            return this.memory;
        }

        public String toString() {
            StringBuilder output = new StringBuilder();
            String lineSeparator = System.lineSeparator();
            output.append(StringUtils.format((String)"Druid version - %s", (Object[])new Object[]{this.version})).append(lineSeparator).append(lineSeparator);
            if (this.modules.size() > 0) {
                output.append("Registered Druid Modules").append(lineSeparator);
            } else {
                output.append("No Druid Modules loaded !");
            }
            for (ModuleVersion moduleVersion : this.modules) {
                output.append(moduleVersion).append(lineSeparator);
            }
            return output.toString();
        }

        private List<ModuleVersion> getExtensionVersions(Collection<DruidModule> druidModules) {
            ArrayList<ModuleVersion> moduleVersions = new ArrayList<ModuleVersion>();
            for (DruidModule module : druidModules) {
                String artifact = module.getClass().getPackage().getImplementationTitle();
                String version = module.getClass().getPackage().getImplementationVersion();
                moduleVersions.add(new ModuleVersion(module.getClass().getName(), artifact, version));
            }
            return moduleVersions;
        }
    }
}

