/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.common.logger.Logger;

public class CoordinatorDynamicConfig {
    public static final String CONFIG_KEY = "coordinator.config";
    private final long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
    private final long mergeBytesLimit;
    private final int mergeSegmentsLimit;
    private final int maxSegmentsToMove;
    @Deprecated
    private final double percentOfSegmentsToConsiderPerMove;
    private final boolean useBatchedSegmentSampler;
    private final int replicantLifetime;
    private final int replicationThrottleLimit;
    private final int balancerComputeThreads;
    private final boolean emitBalancingStats;
    private final Set<String> specificDataSourcesToKillUnusedSegmentsIn;
    private final Set<String> decommissioningNodes;
    private final int decommissioningMaxPercentOfMaxSegmentsToMove;
    private final Set<String> dataSourcesToNotKillStalePendingSegmentsIn;
    private final int maxSegmentsInNodeLoadingQueue;
    private final boolean pauseCoordination;
    private final boolean replicateAfterLoadTimeout;
    private final int maxNonPrimaryReplicantsToLoad;
    private static final Logger log = new Logger(CoordinatorDynamicConfig.class);

    @JsonCreator
    public CoordinatorDynamicConfig(@JsonProperty(value="millisToWaitBeforeDeleting") long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, @JsonProperty(value="mergeBytesLimit") long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") int mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") int maxSegmentsToMove, @Deprecated @JsonProperty(value="percentOfSegmentsToConsiderPerMove") @Nullable Double percentOfSegmentsToConsiderPerMove, @JsonProperty(value="useBatchedSegmentSampler") boolean useBatchedSegmentSampler, @JsonProperty(value="replicantLifetime") int replicantLifetime, @JsonProperty(value="replicationThrottleLimit") int replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") int balancerComputeThreads, @JsonProperty(value="emitBalancingStats") boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killPendingSegmentsSkipList") Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") Object decommissioningNodes, @JsonProperty(value="decommissioningMaxPercentOfMaxSegmentsToMove") int decommissioningMaxPercentOfMaxSegmentsToMove, @JsonProperty(value="pauseCoordination") boolean pauseCoordination, @JsonProperty(value="replicateAfterLoadTimeout") boolean replicateAfterLoadTimeout, @JsonProperty(value="maxNonPrimaryReplicantsToLoad") @Nullable Integer maxNonPrimaryReplicantsToLoad) {
        this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments = leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
        this.mergeBytesLimit = mergeBytesLimit;
        this.mergeSegmentsLimit = mergeSegmentsLimit;
        this.maxSegmentsToMove = maxSegmentsToMove;
        if (percentOfSegmentsToConsiderPerMove == null) {
            log.debug("percentOfSegmentsToConsiderPerMove was null! This is likely because your metastore does not reflect this configuration being added to Druid in a recent release. Druid is defaulting the value to the Druid default of %f. It is recommended that you re-submit your dynamic config with your desired value for percentOfSegmentsToConsideredPerMove", new Object[]{100.0});
            percentOfSegmentsToConsiderPerMove = 100.0;
        }
        Preconditions.checkArgument((percentOfSegmentsToConsiderPerMove > 0.0 && percentOfSegmentsToConsiderPerMove <= 100.0 ? 1 : 0) != 0, (Object)"percentOfSegmentsToConsiderPerMove should be between 1 and 100!");
        this.percentOfSegmentsToConsiderPerMove = percentOfSegmentsToConsiderPerMove;
        this.useBatchedSegmentSampler = useBatchedSegmentSampler;
        this.replicantLifetime = replicantLifetime;
        this.replicationThrottleLimit = replicationThrottleLimit;
        this.balancerComputeThreads = Math.max(balancerComputeThreads, 1);
        this.emitBalancingStats = emitBalancingStats;
        this.specificDataSourcesToKillUnusedSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(specificDataSourcesToKillUnusedSegmentsIn);
        this.dataSourcesToNotKillStalePendingSegmentsIn = CoordinatorDynamicConfig.parseJsonStringOrArray(dataSourcesToNotKillStalePendingSegmentsIn);
        this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue == null ? 100 : maxSegmentsInNodeLoadingQueue;
        this.decommissioningNodes = CoordinatorDynamicConfig.parseJsonStringOrArray(decommissioningNodes);
        Preconditions.checkArgument((decommissioningMaxPercentOfMaxSegmentsToMove >= 0 && decommissioningMaxPercentOfMaxSegmentsToMove <= 100 ? 1 : 0) != 0, (Object)"decommissioningMaxPercentOfMaxSegmentsToMove should be in range [0, 100]");
        this.decommissioningMaxPercentOfMaxSegmentsToMove = decommissioningMaxPercentOfMaxSegmentsToMove;
        this.pauseCoordination = pauseCoordination;
        this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
        if (maxNonPrimaryReplicantsToLoad == null) {
            log.debug("maxNonPrimaryReplicantsToLoad was null! This is likely because your metastore does not reflect this configuration being added to Druid in a recent release. Druid is defaulting the value to the Druid default of %d. It is recommended that you re-submit your dynamic config with your desired value for maxNonPrimaryReplicantsToLoad", new Object[]{Integer.MAX_VALUE});
            maxNonPrimaryReplicantsToLoad = Integer.MAX_VALUE;
        }
        Preconditions.checkArgument((maxNonPrimaryReplicantsToLoad >= 0 ? 1 : 0) != 0, (Object)"maxNonPrimaryReplicantsToLoad must be greater than or equal to 0.");
        this.maxNonPrimaryReplicantsToLoad = maxNonPrimaryReplicantsToLoad;
    }

    private static Set<String> parseJsonStringOrArray(Object jsonStringOrArray) {
        if (jsonStringOrArray instanceof String) {
            String[] list = ((String)jsonStringOrArray).split(",");
            HashSet<String> result = new HashSet<String>();
            for (String item : list) {
                String trimmed = item.trim();
                if (trimmed.isEmpty()) continue;
                result.add(trimmed);
            }
            return result;
        }
        if (jsonStringOrArray instanceof Collection) {
            return ImmutableSet.copyOf((Collection)((Collection)jsonStringOrArray));
        }
        return ImmutableSet.of();
    }

    public static AtomicReference<CoordinatorDynamicConfig> watch(JacksonConfigManager configManager) {
        return configManager.watch(CONFIG_KEY, CoordinatorDynamicConfig.class, (Object)CoordinatorDynamicConfig.builder().build());
    }

    @Nonnull
    public static CoordinatorDynamicConfig current(JacksonConfigManager configManager) {
        return (CoordinatorDynamicConfig)Preconditions.checkNotNull((Object)CoordinatorDynamicConfig.watch(configManager).get(), (Object)"Got null config from watcher?!");
    }

    @JsonProperty(value="millisToWaitBeforeDeleting")
    public long getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments() {
        return this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
    }

    @JsonProperty
    public long getMergeBytesLimit() {
        return this.mergeBytesLimit;
    }

    @JsonProperty
    public boolean emitBalancingStats() {
        return this.emitBalancingStats;
    }

    @JsonProperty
    public int getMergeSegmentsLimit() {
        return this.mergeSegmentsLimit;
    }

    @JsonProperty
    public int getMaxSegmentsToMove() {
        return this.maxSegmentsToMove;
    }

    @Deprecated
    @JsonProperty
    public double getPercentOfSegmentsToConsiderPerMove() {
        return this.percentOfSegmentsToConsiderPerMove;
    }

    @JsonProperty
    public boolean useBatchedSegmentSampler() {
        return this.useBatchedSegmentSampler;
    }

    @JsonProperty
    public int getReplicantLifetime() {
        return this.replicantLifetime;
    }

    @JsonProperty
    public int getReplicationThrottleLimit() {
        return this.replicationThrottleLimit;
    }

    @JsonProperty
    public int getBalancerComputeThreads() {
        return this.balancerComputeThreads;
    }

    @JsonProperty(value="killDataSourceWhitelist")
    public Set<String> getSpecificDataSourcesToKillUnusedSegmentsIn() {
        return this.specificDataSourcesToKillUnusedSegmentsIn;
    }

    @JsonIgnore
    public boolean isKillUnusedSegmentsInAllDataSources() {
        return this.specificDataSourcesToKillUnusedSegmentsIn.isEmpty();
    }

    @JsonProperty(value="killPendingSegmentsSkipList")
    public Set<String> getDataSourcesToNotKillStalePendingSegmentsIn() {
        return this.dataSourcesToNotKillStalePendingSegmentsIn;
    }

    @JsonProperty
    public int getMaxSegmentsInNodeLoadingQueue() {
        return this.maxSegmentsInNodeLoadingQueue;
    }

    @JsonProperty
    public Set<String> getDecommissioningNodes() {
        return this.decommissioningNodes;
    }

    @Min(value=0L)
    @Max(value=100L)
    @JsonProperty
    public int getDecommissioningMaxPercentOfMaxSegmentsToMove() {
        return this.decommissioningMaxPercentOfMaxSegmentsToMove;
    }

    @JsonProperty
    public boolean getPauseCoordination() {
        return this.pauseCoordination;
    }

    @JsonProperty
    public boolean getReplicateAfterLoadTimeout() {
        return this.replicateAfterLoadTimeout;
    }

    @Min(value=0L)
    @JsonProperty
    public int getMaxNonPrimaryReplicantsToLoad() {
        return this.maxNonPrimaryReplicantsToLoad;
    }

    public String toString() {
        return "CoordinatorDynamicConfig{leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments=" + this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments + ", mergeBytesLimit=" + this.mergeBytesLimit + ", mergeSegmentsLimit=" + this.mergeSegmentsLimit + ", maxSegmentsToMove=" + this.maxSegmentsToMove + ", percentOfSegmentsToConsiderPerMove=" + this.percentOfSegmentsToConsiderPerMove + ", useBatchedSegmentSampler=" + this.useBatchedSegmentSampler + ", replicantLifetime=" + this.replicantLifetime + ", replicationThrottleLimit=" + this.replicationThrottleLimit + ", balancerComputeThreads=" + this.balancerComputeThreads + ", emitBalancingStats=" + this.emitBalancingStats + ", specificDataSourcesToKillUnusedSegmentsIn=" + this.specificDataSourcesToKillUnusedSegmentsIn + ", dataSourcesToNotKillStalePendingSegmentsIn=" + this.dataSourcesToNotKillStalePendingSegmentsIn + ", maxSegmentsInNodeLoadingQueue=" + this.maxSegmentsInNodeLoadingQueue + ", decommissioningNodes=" + this.decommissioningNodes + ", decommissioningMaxPercentOfMaxSegmentsToMove=" + this.decommissioningMaxPercentOfMaxSegmentsToMove + ", pauseCoordination=" + this.pauseCoordination + ", replicateAfterLoadTimeout=" + this.replicateAfterLoadTimeout + ", maxNonPrimaryReplicantsToLoad=" + this.maxNonPrimaryReplicantsToLoad + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinatorDynamicConfig that = (CoordinatorDynamicConfig)o;
        if (this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments != that.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments) {
            return false;
        }
        if (this.mergeBytesLimit != that.mergeBytesLimit) {
            return false;
        }
        if (this.mergeSegmentsLimit != that.mergeSegmentsLimit) {
            return false;
        }
        if (this.maxSegmentsToMove != that.maxSegmentsToMove) {
            return false;
        }
        if (this.percentOfSegmentsToConsiderPerMove != that.percentOfSegmentsToConsiderPerMove) {
            return false;
        }
        if (this.useBatchedSegmentSampler != that.useBatchedSegmentSampler) {
            return false;
        }
        if (this.replicantLifetime != that.replicantLifetime) {
            return false;
        }
        if (this.replicationThrottleLimit != that.replicationThrottleLimit) {
            return false;
        }
        if (this.balancerComputeThreads != that.balancerComputeThreads) {
            return false;
        }
        if (this.emitBalancingStats != that.emitBalancingStats) {
            return false;
        }
        if (this.maxSegmentsInNodeLoadingQueue != that.maxSegmentsInNodeLoadingQueue) {
            return false;
        }
        if (!Objects.equals(this.specificDataSourcesToKillUnusedSegmentsIn, that.specificDataSourcesToKillUnusedSegmentsIn)) {
            return false;
        }
        if (!Objects.equals(this.dataSourcesToNotKillStalePendingSegmentsIn, that.dataSourcesToNotKillStalePendingSegmentsIn)) {
            return false;
        }
        if (!Objects.equals(this.decommissioningNodes, that.decommissioningNodes)) {
            return false;
        }
        if (this.pauseCoordination != that.pauseCoordination) {
            return false;
        }
        if (this.replicateAfterLoadTimeout != that.replicateAfterLoadTimeout) {
            return false;
        }
        if (this.maxNonPrimaryReplicantsToLoad != that.maxNonPrimaryReplicantsToLoad) {
            return false;
        }
        return this.decommissioningMaxPercentOfMaxSegmentsToMove == that.decommissioningMaxPercentOfMaxSegmentsToMove;
    }

    public int hashCode() {
        return Objects.hash(this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, this.mergeBytesLimit, this.mergeSegmentsLimit, this.maxSegmentsToMove, this.percentOfSegmentsToConsiderPerMove, this.useBatchedSegmentSampler, this.replicantLifetime, this.replicationThrottleLimit, this.balancerComputeThreads, this.emitBalancingStats, this.maxSegmentsInNodeLoadingQueue, this.specificDataSourcesToKillUnusedSegmentsIn, this.dataSourcesToNotKillStalePendingSegmentsIn, this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove, this.pauseCoordination, this.maxNonPrimaryReplicantsToLoad);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final long DEFAULT_LEADING_TIME_MILLIS_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS = TimeUnit.MINUTES.toMillis(15L);
        private static final long DEFAULT_MERGE_BYTES_LIMIT = 524288000L;
        private static final int DEFAULT_MERGE_SEGMENTS_LIMIT = 100;
        private static final int DEFAULT_MAX_SEGMENTS_TO_MOVE = 5;
        private static final double DEFAULT_PERCENT_OF_SEGMENTS_TO_CONSIDER_PER_MOVE = 100.0;
        private static final int DEFAULT_REPLICANT_LIFETIME = 15;
        private static final int DEFAULT_REPLICATION_THROTTLE_LIMIT = 10;
        private static final int DEFAULT_BALANCER_COMPUTE_THREADS = 1;
        private static final boolean DEFAULT_EMIT_BALANCING_STATS = false;
        private static final boolean DEFAULT_USE_BATCHED_SEGMENT_SAMPLER = false;
        private static final int DEFAULT_MAX_SEGMENTS_IN_NODE_LOADING_QUEUE = 100;
        private static final int DEFAULT_DECOMMISSIONING_MAX_SEGMENTS_TO_MOVE_PERCENT = 70;
        private static final boolean DEFAULT_PAUSE_COORDINATION = false;
        private static final boolean DEFAULT_REPLICATE_AFTER_LOAD_TIMEOUT = false;
        private static final int DEFAULT_MAX_NON_PRIMARY_REPLICANTS_TO_LOAD = Integer.MAX_VALUE;
        private Long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
        private Long mergeBytesLimit;
        private Integer mergeSegmentsLimit;
        private Integer maxSegmentsToMove;
        private Double percentOfSegmentsToConsiderPerMove;
        private Boolean useBatchedSegmentSampler;
        private Integer replicantLifetime;
        private Integer replicationThrottleLimit;
        private Boolean emitBalancingStats;
        private Integer balancerComputeThreads;
        private Object specificDataSourcesToKillUnusedSegmentsIn;
        private Object dataSourcesToNotKillStalePendingSegmentsIn;
        private Integer maxSegmentsInNodeLoadingQueue;
        private Object decommissioningNodes;
        private Integer decommissioningMaxPercentOfMaxSegmentsToMove;
        private Boolean pauseCoordination;
        private Boolean replicateAfterLoadTimeout;
        private Integer maxNonPrimaryReplicantsToLoad;

        public Builder() {
        }

        @JsonCreator
        public Builder(@JsonProperty(value="millisToWaitBeforeDeleting") @Nullable Long leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, @JsonProperty(value="mergeBytesLimit") @Nullable Long mergeBytesLimit, @JsonProperty(value="mergeSegmentsLimit") @Nullable Integer mergeSegmentsLimit, @JsonProperty(value="maxSegmentsToMove") @Nullable Integer maxSegmentsToMove, @Deprecated @JsonProperty(value="percentOfSegmentsToConsiderPerMove") @Nullable Double percentOfSegmentsToConsiderPerMove, @JsonProperty(value="useBatchedSegmentSampler") Boolean useBatchedSegmentSampler, @JsonProperty(value="replicantLifetime") @Nullable Integer replicantLifetime, @JsonProperty(value="replicationThrottleLimit") @Nullable Integer replicationThrottleLimit, @JsonProperty(value="balancerComputeThreads") @Nullable Integer balancerComputeThreads, @JsonProperty(value="emitBalancingStats") @Nullable Boolean emitBalancingStats, @JsonProperty(value="killDataSourceWhitelist") @Nullable Object specificDataSourcesToKillUnusedSegmentsIn, @JsonProperty(value="killPendingSegmentsSkipList") @Nullable Object dataSourcesToNotKillStalePendingSegmentsIn, @JsonProperty(value="maxSegmentsInNodeLoadingQueue") @Nullable Integer maxSegmentsInNodeLoadingQueue, @JsonProperty(value="decommissioningNodes") @Nullable Object decommissioningNodes, @JsonProperty(value="decommissioningMaxPercentOfMaxSegmentsToMove") @Nullable Integer decommissioningMaxPercentOfMaxSegmentsToMove, @JsonProperty(value="pauseCoordination") @Nullable Boolean pauseCoordination, @JsonProperty(value="replicateAfterLoadTimeout") @Nullable Boolean replicateAfterLoadTimeout, @JsonProperty(value="maxNonPrimaryReplicantsToLoad") @Nullable Integer maxNonPrimaryReplicantsToLoad) {
            this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments = leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments;
            this.mergeBytesLimit = mergeBytesLimit;
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            this.maxSegmentsToMove = maxSegmentsToMove;
            this.percentOfSegmentsToConsiderPerMove = percentOfSegmentsToConsiderPerMove;
            this.useBatchedSegmentSampler = useBatchedSegmentSampler;
            this.replicantLifetime = replicantLifetime;
            this.replicationThrottleLimit = replicationThrottleLimit;
            this.balancerComputeThreads = balancerComputeThreads;
            this.emitBalancingStats = emitBalancingStats;
            this.specificDataSourcesToKillUnusedSegmentsIn = specificDataSourcesToKillUnusedSegmentsIn;
            this.dataSourcesToNotKillStalePendingSegmentsIn = dataSourcesToNotKillStalePendingSegmentsIn;
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            this.decommissioningNodes = decommissioningNodes;
            this.decommissioningMaxPercentOfMaxSegmentsToMove = decommissioningMaxPercentOfMaxSegmentsToMove;
            this.pauseCoordination = pauseCoordination;
            this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
            this.maxNonPrimaryReplicantsToLoad = maxNonPrimaryReplicantsToLoad;
        }

        public Builder withLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments(long leadingTimeMillis) {
            this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments = leadingTimeMillis;
            return this;
        }

        public Builder withMergeBytesLimit(long mergeBytesLimit) {
            this.mergeBytesLimit = mergeBytesLimit;
            return this;
        }

        public Builder withMergeSegmentsLimit(int mergeSegmentsLimit) {
            this.mergeSegmentsLimit = mergeSegmentsLimit;
            return this;
        }

        public Builder withMaxSegmentsToMove(int maxSegmentsToMove) {
            this.maxSegmentsToMove = maxSegmentsToMove;
            return this;
        }

        @Deprecated
        public Builder withPercentOfSegmentsToConsiderPerMove(double percentOfSegmentsToConsiderPerMove) {
            this.percentOfSegmentsToConsiderPerMove = percentOfSegmentsToConsiderPerMove;
            return this;
        }

        public Builder withUseBatchedSegmentSampler(boolean useBatchedSegmentSampler) {
            this.useBatchedSegmentSampler = useBatchedSegmentSampler;
            return this;
        }

        public Builder withReplicantLifetime(int replicantLifetime) {
            this.replicantLifetime = replicantLifetime;
            return this;
        }

        public Builder withReplicationThrottleLimit(int replicationThrottleLimit) {
            this.replicationThrottleLimit = replicationThrottleLimit;
            return this;
        }

        public Builder withBalancerComputeThreads(int balancerComputeThreads) {
            this.balancerComputeThreads = balancerComputeThreads;
            return this;
        }

        public Builder withEmitBalancingStats(boolean emitBalancingStats) {
            this.emitBalancingStats = emitBalancingStats;
            return this;
        }

        public Builder withSpecificDataSourcesToKillUnusedSegmentsIn(Set<String> dataSources) {
            this.specificDataSourcesToKillUnusedSegmentsIn = dataSources;
            return this;
        }

        public Builder withMaxSegmentsInNodeLoadingQueue(int maxSegmentsInNodeLoadingQueue) {
            this.maxSegmentsInNodeLoadingQueue = maxSegmentsInNodeLoadingQueue;
            return this;
        }

        public Builder withDecommissioningNodes(Set<String> decommissioning) {
            this.decommissioningNodes = decommissioning;
            return this;
        }

        public Builder withDecommissioningMaxPercentOfMaxSegmentsToMove(Integer percent) {
            this.decommissioningMaxPercentOfMaxSegmentsToMove = percent;
            return this;
        }

        public Builder withPauseCoordination(boolean pauseCoordination) {
            this.pauseCoordination = pauseCoordination;
            return this;
        }

        public Builder withReplicateAfterLoadTimeout(boolean replicateAfterLoadTimeout) {
            this.replicateAfterLoadTimeout = replicateAfterLoadTimeout;
            return this;
        }

        public Builder withMaxNonPrimaryReplicantsToLoad(int maxNonPrimaryReplicantsToLoad) {
            this.maxNonPrimaryReplicantsToLoad = maxNonPrimaryReplicantsToLoad;
            return this;
        }

        public CoordinatorDynamicConfig build() {
            return new CoordinatorDynamicConfig(this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments == null ? DEFAULT_LEADING_TIME_MILLIS_BEFORE_CAN_MARK_AS_UNUSED_OVERSHADOWED_SEGMENTS : this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments, this.mergeBytesLimit == null ? 524288000L : this.mergeBytesLimit, this.mergeSegmentsLimit == null ? 100 : this.mergeSegmentsLimit, this.maxSegmentsToMove == null ? 5 : this.maxSegmentsToMove, this.percentOfSegmentsToConsiderPerMove == null ? 100.0 : this.percentOfSegmentsToConsiderPerMove, this.useBatchedSegmentSampler == null ? false : this.useBatchedSegmentSampler, this.replicantLifetime == null ? 15 : this.replicantLifetime, this.replicationThrottleLimit == null ? 10 : this.replicationThrottleLimit, this.balancerComputeThreads == null ? 1 : this.balancerComputeThreads, this.emitBalancingStats == null ? false : this.emitBalancingStats, this.specificDataSourcesToKillUnusedSegmentsIn, this.dataSourcesToNotKillStalePendingSegmentsIn, this.maxSegmentsInNodeLoadingQueue == null ? 100 : this.maxSegmentsInNodeLoadingQueue, this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove == null ? 70 : this.decommissioningMaxPercentOfMaxSegmentsToMove, this.pauseCoordination == null ? false : this.pauseCoordination, this.replicateAfterLoadTimeout == null ? false : this.replicateAfterLoadTimeout, this.maxNonPrimaryReplicantsToLoad == null ? Integer.MAX_VALUE : this.maxNonPrimaryReplicantsToLoad);
        }

        public CoordinatorDynamicConfig build(CoordinatorDynamicConfig defaults) {
            return new CoordinatorDynamicConfig(this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments == null ? defaults.getLeadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments() : this.leadingTimeMillisBeforeCanMarkAsUnusedOvershadowedSegments.longValue(), this.mergeBytesLimit == null ? defaults.getMergeBytesLimit() : this.mergeBytesLimit.longValue(), this.mergeSegmentsLimit == null ? defaults.getMergeSegmentsLimit() : this.mergeSegmentsLimit.intValue(), this.maxSegmentsToMove == null ? defaults.getMaxSegmentsToMove() : this.maxSegmentsToMove.intValue(), this.percentOfSegmentsToConsiderPerMove == null ? defaults.getPercentOfSegmentsToConsiderPerMove() : this.percentOfSegmentsToConsiderPerMove.doubleValue(), this.useBatchedSegmentSampler == null ? defaults.useBatchedSegmentSampler() : this.useBatchedSegmentSampler.booleanValue(), this.replicantLifetime == null ? defaults.getReplicantLifetime() : this.replicantLifetime.intValue(), this.replicationThrottleLimit == null ? defaults.getReplicationThrottleLimit() : this.replicationThrottleLimit.intValue(), this.balancerComputeThreads == null ? defaults.getBalancerComputeThreads() : this.balancerComputeThreads.intValue(), this.emitBalancingStats == null ? defaults.emitBalancingStats() : this.emitBalancingStats.booleanValue(), this.specificDataSourcesToKillUnusedSegmentsIn == null ? defaults.getSpecificDataSourcesToKillUnusedSegmentsIn() : this.specificDataSourcesToKillUnusedSegmentsIn, this.dataSourcesToNotKillStalePendingSegmentsIn == null ? defaults.getDataSourcesToNotKillStalePendingSegmentsIn() : this.dataSourcesToNotKillStalePendingSegmentsIn, this.maxSegmentsInNodeLoadingQueue == null ? defaults.getMaxSegmentsInNodeLoadingQueue() : this.maxSegmentsInNodeLoadingQueue.intValue(), this.decommissioningNodes == null ? defaults.getDecommissioningNodes() : this.decommissioningNodes, this.decommissioningMaxPercentOfMaxSegmentsToMove == null ? defaults.getDecommissioningMaxPercentOfMaxSegmentsToMove() : this.decommissioningMaxPercentOfMaxSegmentsToMove.intValue(), this.pauseCoordination == null ? defaults.getPauseCoordination() : this.pauseCoordination.booleanValue(), this.replicateAfterLoadTimeout == null ? defaults.getReplicateAfterLoadTimeout() : this.replicateAfterLoadTimeout.booleanValue(), this.maxNonPrimaryReplicantsToLoad == null ? defaults.getMaxNonPrimaryReplicantsToLoad() : this.maxNonPrimaryReplicantsToLoad.intValue());
        }
    }
}

