/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.common.config.ConfigManager;
import org.apache.druid.common.config.JacksonConfigManager;
import org.apache.druid.java.util.RetryableException;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.metadata.MetadataStorageConnector;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SqlSegmentsMetadataManager;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;

public class KillCompactionConfig
implements CoordinatorDuty {
    private static final Logger log = new Logger(KillCompactionConfig.class);
    private static final int UPDATE_NUM_RETRY = 5;
    static final String COUNT_METRIC = "metadata/kill/compaction/count";
    private final long period;
    private long lastKillTime = 0L;
    private final JacksonConfigManager jacksonConfigManager;
    private final SqlSegmentsMetadataManager sqlSegmentsMetadataManager;
    private final MetadataStorageConnector connector;
    private final MetadataStorageTablesConfig connectorConfig;

    @Inject
    public KillCompactionConfig(DruidCoordinatorConfig config, SqlSegmentsMetadataManager sqlSegmentsMetadataManager, JacksonConfigManager jacksonConfigManager, MetadataStorageConnector connector, MetadataStorageTablesConfig connectorConfig) {
        this.sqlSegmentsMetadataManager = sqlSegmentsMetadataManager;
        this.jacksonConfigManager = jacksonConfigManager;
        this.period = config.getCoordinatorCompactionKillPeriod().getMillis();
        this.connector = connector;
        this.connectorConfig = connectorConfig;
        Preconditions.checkArgument((this.period >= config.getCoordinatorMetadataStoreManagementPeriod().getMillis() ? 1 : 0) != 0, (Object)"Coordinator compaction configuration kill period must be >= druid.coordinator.period.metadataStoreManagementPeriod");
        log.debug("Compaction Configuration Kill Task scheduling enabled with period [%s]", new Object[]{this.period});
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        long currentTimeMillis = System.currentTimeMillis();
        if (this.lastKillTime + this.period < currentTimeMillis) {
            this.lastKillTime = currentTimeMillis;
            try {
                RetryUtils.retry(() -> {
                    byte[] currentBytes = CoordinatorCompactionConfig.getConfigInByteFromDb(this.connector, this.connectorConfig);
                    CoordinatorCompactionConfig current = CoordinatorCompactionConfig.convertByteToConfig(this.jacksonConfigManager, currentBytes);
                    if (CoordinatorCompactionConfig.empty().equals(current)) {
                        log.info("Finished running KillCompactionConfig duty. Nothing to do as compaction config is already empty.", new Object[0]);
                        this.emitMetric(params.getEmitter(), 0);
                        return ConfigManager.SetResult.ok();
                    }
                    Set<String> activeDatasources = this.sqlSegmentsMetadataManager.retrieveAllDataSourceNames();
                    Map updated = current.getCompactionConfigs().stream().filter(dataSourceCompactionConfig -> activeDatasources.contains(dataSourceCompactionConfig.getDataSource())).collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
                    int compactionConfigRemoved = current.getCompactionConfigs().size() - updated.size();
                    ConfigManager.SetResult result = this.jacksonConfigManager.set("coordinator.compaction.config", currentBytes, (Object)CoordinatorCompactionConfig.from(current, (List<DataSourceCompactionConfig>)ImmutableList.copyOf(updated.values())), new AuditInfo("KillCompactionConfig", "CoordinatorDuty for automatic deletion of compaction config", ""));
                    if (result.isOk()) {
                        log.info("Finished running KillCompactionConfig duty. Removed %,d compaction configs", new Object[]{compactionConfigRemoved});
                        this.emitMetric(params.getEmitter(), compactionConfigRemoved);
                    } else {
                        if (result.isRetryable()) {
                            log.debug("Retrying KillCompactionConfig duty", new Object[0]);
                            throw new RetryableException((Throwable)result.getException());
                        }
                        log.error((Throwable)result.getException(), "Failed to kill compaction configurations", new Object[0]);
                        this.emitMetric(params.getEmitter(), 0);
                    }
                    return result;
                }, e -> e instanceof RetryableException, (int)5);
            }
            catch (Exception e2) {
                log.error((Throwable)e2, "Failed to kill compaction configurations", new Object[0]);
                this.emitMetric(params.getEmitter(), 0);
            }
        }
        return params;
    }

    private void emitMetric(ServiceEmitter emitter, int compactionConfigRemoved) {
        emitter.emit(new ServiceMetricEvent.Builder().build(COUNT_METRIC, (Number)compactionConfigRemoved));
    }
}

