/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.client.CacheUtil;
import org.apache.druid.client.CachingClusteredClientTestUtils;
import org.apache.druid.client.cache.BackgroundCachePopulator;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CachePopulatorStats;
import org.apache.druid.client.cache.CacheStats;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.Result;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.query.topn.TopNQueryConfig;
import org.apache.druid.query.topn.TopNQueryQueryToolChest;
import org.apache.druid.query.topn.TopNResultValue;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BackgroundCachePopulatorTest {
    private static final ObjectMapper JSON_MAPPER = CachingClusteredClientTestUtils.createObjectMapper();
    private static final Object[] OBJECTS = new Object[]{DateTimes.of((String)"2011-01-05"), "a", 50, 4994, "b", 50, 4993, "c", 50, 4992, DateTimes.of((String)"2011-01-06"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-07"), "a", 50, 4991, "b", 50, 4990, "c", 50, 4989, DateTimes.of((String)"2011-01-08"), "a", 50, 4988, "b", 50, 4987, "c", 50, 4986, DateTimes.of((String)"2011-01-09"), "a", 50, 4985, "b", 50, 4984, "c", 50, 4983};
    private static final List<AggregatorFactory> AGGS = Arrays.asList(new CountAggregatorFactory("rows"), new LongSumAggregatorFactory("imps", "imps"), new LongSumAggregatorFactory("impers", "imps"));
    private BackgroundCachePopulator backgroundCachePopulator;
    private QueryToolChest toolchest;
    private Cache cache;
    private Query query;
    private QueryRunner baseRunner;
    private AssertingClosable closable;

    @Before
    public void before() {
        this.backgroundCachePopulator = new BackgroundCachePopulator(Execs.multiThreaded((int)2, (String)"CachingQueryRunnerTest-%d"), JSON_MAPPER, new CachePopulatorStats(), -1L);
        TopNQueryBuilder builder = new TopNQueryBuilder().dataSource("ds").dimension("top_dim").metric("imps").threshold(3).intervals("2011-01-05/2011-01-10").aggregators(AGGS).granularity(Granularities.ALL);
        this.query = builder.build();
        this.toolchest = new TopNQueryQueryToolChest(new TopNQueryConfig());
        List<Result> expectedRes = this.makeTopNResults(false, OBJECTS);
        this.closable = new AssertingClosable();
        Sequence resultSeq = Sequences.wrap((Sequence)Sequences.simple(expectedRes), (SequenceWrapper)new SequenceWrapper(){

            public void before() {
                Assert.assertFalse((boolean)BackgroundCachePopulatorTest.this.closable.isClosed());
            }

            public void after(boolean isDone, Throwable thrown) {
                BackgroundCachePopulatorTest.this.closable.close();
            }
        });
        this.baseRunner = (queryPlus, responseContext) -> resultSeq;
        this.cache = new Cache(){
            private final ConcurrentMap<Cache.NamedKey, byte[]> baseMap = new ConcurrentHashMap<Cache.NamedKey, byte[]>();

            public byte[] get(Cache.NamedKey key) {
                return (byte[])this.baseMap.get(key);
            }

            public void put(Cache.NamedKey key, byte[] value) {
                this.baseMap.put(key, value);
            }

            public Map<Cache.NamedKey, byte[]> getBulk(Iterable<Cache.NamedKey> keys) {
                return null;
            }

            public void close(String namespace) {
            }

            public void close() {
            }

            public CacheStats getStats() {
                return null;
            }

            public boolean isLocal() {
                return true;
            }

            public void doMonitor(ServiceEmitter emitter) {
            }
        };
    }

    @Test
    public void testWrap() {
        String cacheId = "segment";
        SegmentDescriptor segmentDescriptor = new SegmentDescriptor(Intervals.of((String)"2011/2012"), "version", 0);
        CacheStrategy cacheStrategy = this.toolchest.getCacheStrategy(this.query);
        Cache.NamedKey cacheKey = CacheUtil.computeSegmentCacheKey((String)cacheId, (SegmentDescriptor)segmentDescriptor, (byte[])cacheStrategy.computeCacheKey(this.query));
        Sequence res = this.backgroundCachePopulator.wrap(this.baseRunner.run(QueryPlus.wrap((Query)this.query), ResponseContext.createEmpty()), value -> cacheStrategy.prepareForSegmentLevelCache().apply(value), this.cache, cacheKey);
        Assert.assertFalse((String)"sequence must not be closed", (boolean)this.closable.isClosed());
        Assert.assertNull((String)"cache must be empty", (Object)this.cache.get(cacheKey));
        List results = res.toList();
        Assert.assertTrue((boolean)this.closable.isClosed());
        List<Result> expectedRes = this.makeTopNResults(false, OBJECTS);
        Assert.assertEquals((Object)expectedRes.toString(), (Object)results.toString());
        Assert.assertEquals((long)5L, (long)results.size());
    }

    @Test
    public void testWrapOnFailure() {
        String cacheId = "segment";
        SegmentDescriptor segmentDescriptor = new SegmentDescriptor(Intervals.of((String)"2011/2012"), "version", 0);
        CacheStrategy cacheStrategy = this.toolchest.getCacheStrategy(this.query);
        Cache.NamedKey cacheKey = CacheUtil.computeSegmentCacheKey((String)cacheId, (SegmentDescriptor)segmentDescriptor, (byte[])cacheStrategy.computeCacheKey(this.query));
        Sequence res = this.backgroundCachePopulator.wrap(this.baseRunner.run(QueryPlus.wrap((Query)this.query), ResponseContext.createEmpty()), value -> {
            throw new RuntimeException("Error");
        }, this.cache, cacheKey);
        Assert.assertFalse((String)"sequence must not be closed", (boolean)this.closable.isClosed());
        Assert.assertNull((String)"cache must be empty", (Object)this.cache.get(cacheKey));
        List results = res.toList();
        Assert.assertTrue((boolean)this.closable.isClosed());
        List<Result> expectedRes = this.makeTopNResults(false, OBJECTS);
        Assert.assertEquals((Object)expectedRes.toString(), (Object)results.toString());
        Assert.assertEquals((long)5L, (long)results.size());
    }

    private List<Result> makeTopNResults(boolean cachedResults, Object ... objects) {
        ArrayList<Result> retVal = new ArrayList<Result>();
        int index = 0;
        while (index < objects.length) {
            DateTime timestamp = (DateTime)objects[index++];
            ArrayList<ImmutableMap> values = new ArrayList<ImmutableMap>();
            while (index < objects.length && !(objects[index] instanceof DateTime)) {
                if (objects.length - index < 3) {
                    throw new ISE("expect 3 values for each entry in the top list, had %d values left.", new Object[]{objects.length - index});
                }
                double imps = ((Number)objects[index + 2]).doubleValue();
                double rows = ((Number)objects[index + 1]).doubleValue();
                if (cachedResults) {
                    values.add(ImmutableMap.of((Object)"top_dim", (Object)objects[index], (Object)"rows", (Object)rows, (Object)"imps", (Object)imps, (Object)"impers", (Object)imps));
                } else {
                    values.add(ImmutableMap.of((Object)"top_dim", (Object)objects[index], (Object)"rows", (Object)rows, (Object)"imps", (Object)imps, (Object)"impers", (Object)imps, (Object)"avg_imps_per_row", (Object)(imps / rows)));
                }
                index += 3;
            }
            retVal.add(new Result(timestamp, (Object)new TopNResultValue(values)));
        }
        return retVal;
    }

    private static class AssertingClosable
    implements Closeable {
        private final AtomicBoolean closed = new AtomicBoolean(false);

        private AssertingClosable() {
        }

        @Override
        public void close() {
            Assert.assertFalse((boolean)this.closed.get());
            Assert.assertTrue((boolean)this.closed.compareAndSet(false, true));
        }

        public boolean isClosed() {
            return this.closed.get();
        }
    }
}

