/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.cache;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheProvider;
import org.apache.druid.client.cache.MemcachedCache;
import org.apache.druid.client.cache.MemcachedCacheConfig;
import org.apache.druid.client.cache.MemcachedCacheProvider;
import org.apache.druid.client.cache.MemcachedProviderWithConfig;
import org.apache.druid.client.cache.MockMemcachedClient;
import org.apache.druid.collections.StupidResourceHolder;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.initialization.Initialization;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.metrics.AbstractMonitor;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemcachedCacheTest {
    private static final Logger log = new Logger(MemcachedCacheTest.class);
    private static final byte[] HI = StringUtils.toUtf8((String)"hiiiiiiiiiiiiiiiiiii");
    private static final byte[] HO = StringUtils.toUtf8((String)"hooooooooooooooooooo");
    protected static final AbstractMonitor NOOP_MONITOR = new AbstractMonitor(){

        public boolean doMonitor(ServiceEmitter emitter) {
            return false;
        }
    };
    private MemcachedCache cache;
    private final MemcachedCacheConfig memcachedCacheConfig = new MemcachedCacheConfig(){

        public String getMemcachedPrefix() {
            return "druid-memcached-test";
        }

        public int getTimeout() {
            return 10;
        }

        public int getExpiration() {
            return 3600;
        }

        public String getHosts() {
            return "localhost:9999";
        }
    };

    @Before
    public void setUp() {
        this.cache = new MemcachedCache(Suppliers.ofInstance((Object)StupidResourceHolder.create((Object)new MockMemcachedClient())), this.memcachedCacheConfig, NOOP_MONITOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicInjection() throws Exception {
        final MemcachedCacheConfig config = new MemcachedCacheConfig(){

            public String getHosts() {
                return "127.0.0.1:22";
            }
        };
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test/memcached");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(MemcachedCacheConfig.class).toInstance((Object)config);
                binder.bind(Cache.class).toProvider(MemcachedProviderWithConfig.class).in(ManageLifecycle.class);
            }
        }));
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        lifecycle.start();
        try {
            Cache cache = (Cache)injector.getInstance(Cache.class);
            Assert.assertEquals(MemcachedCache.class, cache.getClass());
        }
        finally {
            lifecycle.stop();
        }
    }

    @Test
    public void testSimpleInjection() {
        final String uuid = UUID.randomUUID().toString();
        System.setProperty(uuid + ".type", "memcached");
        System.setProperty(uuid + ".hosts", "localhost");
        Injector injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"serviceName")).to("druid/test/memcached");
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"servicePort")).to(0);
                binder.bindConstant().annotatedWith((Annotation)Names.named((String)"tlsServicePort")).to(-1);
                binder.bind(Cache.class).toProvider(CacheProvider.class);
                JsonConfigProvider.bind((Binder)binder, (String)uuid, CacheProvider.class);
            }
        }));
        CacheProvider memcachedCacheProvider = (CacheProvider)injector.getInstance(CacheProvider.class);
        Assert.assertNotNull((Object)memcachedCacheProvider);
        Assert.assertEquals(MemcachedCacheProvider.class, memcachedCacheProvider.getClass());
    }

    @Test
    public void testMonitor() throws Exception {
        MemcachedCache cache = MemcachedCache.create((MemcachedCacheConfig)this.memcachedCacheConfig);
        Emitter emitter = (Emitter)EasyMock.createNiceMock(Emitter.class);
        final ArrayList events = new ArrayList();
        ServiceEmitter serviceEmitter = new ServiceEmitter("service", "host", emitter){

            public void emit(Event event) {
                events.add(event);
            }
        };
        while (events.isEmpty()) {
            Thread.sleep(this.memcachedCacheConfig.getTimeout());
            cache.doMonitor(serviceEmitter);
        }
        Assert.assertFalse((boolean)events.isEmpty());
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        for (Event event : events) {
            log.debug("Found event `%s`", new Object[]{mapper.writeValueAsString((Object)event.toMap())});
        }
    }

    @Test
    public void testSanity() {
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("a", HI)));
        this.put((Cache)this.cache, "a", HI, 1);
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("the", HI)));
        this.put((Cache)this.cache, "the", HI, 2);
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertEquals((long)2L, (long)this.get((Cache)this.cache, "the", HI));
        this.put((Cache)this.cache, "the", HO, 10);
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("a", HO)));
        Assert.assertEquals((long)2L, (long)this.get((Cache)this.cache, "the", HI));
        Assert.assertEquals((long)10L, (long)this.get((Cache)this.cache, "the", HO));
        this.cache.close("the");
        Assert.assertEquals((long)1L, (long)this.get((Cache)this.cache, "a", HI));
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("a", HO)));
        this.cache.close("a");
    }

    @Test
    public void testGetBulk() {
        Assert.assertNull((Object)this.cache.get(new Cache.NamedKey("the", HI)));
        this.put((Cache)this.cache, "the", HI, 2);
        this.put((Cache)this.cache, "the", HO, 10);
        Cache.NamedKey key1 = new Cache.NamedKey("the", HI);
        Cache.NamedKey key2 = new Cache.NamedKey("the", HO);
        Map result = this.cache.getBulk((Iterable)Lists.newArrayList((Object[])new Cache.NamedKey[]{key1, key2}));
        Assert.assertEquals((long)2L, (long)Ints.fromByteArray((byte[])((byte[])result.get(key1))));
        Assert.assertEquals((long)10L, (long)Ints.fromByteArray((byte[])((byte[])result.get(key2))));
    }

    public void put(Cache cache, String namespace, byte[] key, Integer value) {
        cache.put(new Cache.NamedKey(namespace, key), Ints.toByteArray((int)value));
    }

    public int get(Cache cache, String namespace, byte[] key) {
        return Ints.fromByteArray((byte[])cache.get(new Cache.NamedKey(namespace, key)));
    }
}

