/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.druid.client.indexing.ClientCompactionTaskTransformSpec;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.SelectorDimFilter;
import org.junit.Assert;
import org.junit.Test;

public class ClientCompactionTaskTransformSpecTest {
    @Test
    public void testEquals() {
        EqualsVerifier.forClass(ClientCompactionTaskTransformSpec.class).withNonnullFields(new String[]{"filter"}).usingGetClass().verify();
    }

    @Test
    public void testSerde() throws IOException {
        NullHandling.initializeForTests();
        ClientCompactionTaskTransformSpec expected = new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter("dim1", "foo", null));
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        byte[] json = mapper.writeValueAsBytes((Object)expected);
        ClientCompactionTaskTransformSpec fromJson = (ClientCompactionTaskTransformSpec)mapper.readValue(json, ClientCompactionTaskTransformSpec.class);
        Assert.assertEquals((Object)expected, (Object)fromJson);
    }

    @Test
    public void testAsMap() {
        NullHandling.initializeForTests();
        DefaultObjectMapper objectMapper = new DefaultObjectMapper();
        String dimension = "dim1";
        String value = "foo";
        ClientCompactionTaskTransformSpec spec = new ClientCompactionTaskTransformSpec((DimFilter)new SelectorDimFilter(dimension, value, null));
        Map map = spec.asMap((ObjectMapper)objectMapper);
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((long)3L, (long)((Map)map.get("filter")).size());
        Assert.assertEquals((Object)dimension, ((Map)map.get("filter")).get("dimension"));
        Assert.assertEquals((Object)value, ((Map)map.get("filter")).get("value"));
        ClientCompactionTaskTransformSpec actual = (ClientCompactionTaskTransformSpec)objectMapper.convertValue((Object)map, ClientCompactionTaskTransformSpec.class);
        Assert.assertEquals((Object)spec, (Object)actual);
    }
}

