/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.curator;

import java.util.Arrays;
import java.util.Map;
import org.apache.druid.curator.CuratorConfig;
import org.apache.druid.curator.ExhibitorConfig;
import org.apache.druid.guice.JsonConfigTesterBase;
import org.junit.Assert;
import org.junit.Test;

public class CuratorConfigTest
extends JsonConfigTesterBase<CuratorConfig> {
    @Test
    public void testSerde() {
        this.propertyValues.put(CuratorConfigTest.getPropertyKey("host"), "fooHost");
        this.propertyValues.put(CuratorConfigTest.getPropertyKey("acl"), "true");
        this.propertyValues.put(CuratorConfigTest.getPropertyKey("user"), "test-zk-user");
        this.propertyValues.put(CuratorConfigTest.getPropertyKey("pwd"), "test-zk-pwd");
        this.propertyValues.put(CuratorConfigTest.getPropertyKey("authScheme"), "auth");
        this.testProperties.putAll((Map<?, ?>)this.propertyValues);
        this.configProvider.inject(this.testProperties, this.configurator);
        CuratorConfig config = (CuratorConfig)this.configProvider.get().get();
        Assert.assertEquals((Object)"fooHost", (Object)config.getZkHosts());
        Assert.assertEquals((Object)true, (Object)config.getEnableAcl());
        Assert.assertEquals((Object)"test-zk-user", (Object)config.getZkUser());
        Assert.assertEquals((Object)"test-zk-pwd", (Object)config.getZkPwd());
        Assert.assertEquals((Object)"auth", (Object)config.getAuthScheme());
    }

    @Test
    public void testCreate() {
        CuratorConfig config = CuratorConfig.create((String)"foo:2181,bar:2181");
        Assert.assertEquals((Object)"foo:2181,bar:2181", (Object)config.getZkHosts());
        Assert.assertEquals((Object)false, (Object)config.getEnableAcl());
        Assert.assertNull((Object)config.getZkUser());
        Assert.assertEquals((Object)"digest", (Object)config.getAuthScheme());
    }

    @Test
    public void testExhibitorCreate() {
        ExhibitorConfig config = ExhibitorConfig.create(Arrays.asList("foo:2181", "bar:2181"));
        Assert.assertEquals((long)2L, (long)config.getHosts().size());
    }
}

