/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.druid.data.input.FirehoseFactory;
import org.apache.druid.guice.FirehoseModule;
import org.apache.druid.segment.realtime.firehose.ClippedFirehoseFactory;
import org.apache.druid.utils.JvmUtils;
import org.junit.Assert;
import org.junit.Test;

public class FirehoseModuleTest {
    private static final Predicate<Class> IS_FIREHOSE_FACTORY = c -> FirehoseFactory.class.isAssignableFrom((Class<?>)c) && !Modifier.isAbstract(c.getModifiers());

    @Test
    public void testAllFirehoseFactorySubtypesRegistered() throws IOException {
        ObjectMapper objectMapper = FirehoseModuleTest.createObjectMapper();
        Set<Class> registeredSubtypeClasses = FirehoseModuleTest.getFirehoseFactorySubtypeClasses(objectMapper);
        String packageName = ClippedFirehoseFactory.class.getPackage().getName();
        Set<Class> expectedSubtypeClasses = FirehoseModuleTest.getFirehoseFactoryClassesInPackage(packageName);
        Assert.assertEquals(expectedSubtypeClasses, registeredSubtypeClasses);
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        for (Module jacksonModule : new FirehoseModule().getJacksonModules()) {
            objectMapper.registerModule(jacksonModule);
        }
        return objectMapper;
    }

    private static Set<Class> getFirehoseFactorySubtypeClasses(ObjectMapper objectMapper) {
        Class<FirehoseFactory> parentClass = FirehoseFactory.class;
        DeserializationConfig config = objectMapper.getDeserializationConfig();
        AnnotatedClass ac = AnnotatedClass.constructWithoutSuperTypes(parentClass, (MapperConfig)config);
        Collection subtypes = objectMapper.getSubtypeResolver().collectAndResolveSubtypesByClass((MapperConfig)config, ac);
        Assert.assertNotNull((Object)subtypes);
        return subtypes.stream().map(NamedType::getType).filter(c -> !c.equals(parentClass)).collect(Collectors.toSet());
    }

    private static Set<Class> getFirehoseFactoryClassesInPackage(String packageName) throws IOException {
        URLClassLoader classloader = new URLClassLoader(JvmUtils.systemClassPath().toArray(new URL[0]));
        ClassPath classPath = ClassPath.from((ClassLoader)classloader);
        return classPath.getTopLevelClasses(packageName).stream().map(ClassPath.ClassInfo::load).filter(IS_FIREHOSE_FACTORY).collect(Collectors.toSet());
    }
}

