/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.input;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.metadata.SQLFirehoseDatabaseConnector;
import org.apache.druid.metadata.TestDerbyConnector;
import org.apache.druid.metadata.input.InputSourceModule;
import org.apache.druid.metadata.input.SqlEntity;
import org.apache.druid.metadata.input.SqlTestUtils;
import org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SqlEntityTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private final ObjectMapper mapper = TestHelper.makeSmileMapper();
    private TestDerbyConnector derbyConnector;
    String TABLE_NAME_1 = "FOOS_TABLE";
    String VALID_SQL = "SELECT timestamp,a,b FROM FOOS_TABLE";
    String INVALID_SQL = "DONT SELECT timestamp,a,b FROM FOOS_TABLE";
    String resultJson = "[{\"a\":\"0\",\"b\":\"0\",\"timestamp\":\"2011-01-12T00:00:00.000Z\"}]";

    @Before
    public void setUp() {
        for (Module jacksonModule : new InputSourceModule().getJacksonModules()) {
            this.mapper.registerModule(jacksonModule);
        }
    }

    @Test
    public void testExecuteQuery() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable(this.TABLE_NAME_1, 1);
        File tmpFile = File.createTempFile("testQueryResults", "");
        InputEntity.CleanableFile queryResult = SqlEntity.openCleanableFile((String)this.VALID_SQL, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), (ObjectMapper)this.mapper, (boolean)true, (File)tmpFile);
        FileInputStream queryInputStream = new FileInputStream(queryResult.file());
        String actualJson = IOUtils.toString((InputStream)queryInputStream, (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)actualJson, (Object)this.resultJson);
        testUtils.dropTable(this.TABLE_NAME_1);
    }

    @Test(expected=IOException.class)
    public void testFailOnInvalidQuery() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable(this.TABLE_NAME_1, 1);
        File tmpFile = File.createTempFile("testQueryResults", "");
        InputEntity.CleanableFile queryResult = SqlEntity.openCleanableFile((String)this.INVALID_SQL, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), (ObjectMapper)this.mapper, (boolean)true, (File)tmpFile);
        Assert.assertTrue((boolean)tmpFile.exists());
    }

    @Test
    public void testFileDeleteOnInvalidQuery() throws IOException {
        this.derbyConnector = this.derbyConnectorRule.getConnector();
        SqlTestUtils testUtils = new SqlTestUtils(this.derbyConnector);
        testUtils.createAndUpdateTable(this.TABLE_NAME_1, 1);
        File tmpFile = File.createTempFile("testQueryResults", "");
        try {
            SqlEntity.openCleanableFile((String)this.INVALID_SQL, (SQLFirehoseDatabaseConnector)testUtils.getDerbyFirehoseConnector(), (ObjectMapper)this.mapper, (boolean)true, (File)tmpFile);
        }
        catch (IOException e) {
            Assert.assertFalse((boolean)tmpFile.exists());
        }
    }
}

