/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.List;
import org.apache.druid.client.CachingClusteredClient;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.SimpleServerView;
import org.apache.druid.client.TestHttpClient;
import org.apache.druid.java.util.common.NonnullPair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerBasedOnClusteredClientTestBase;
import org.apache.druid.query.Result;
import org.apache.druid.query.RetryQueryRunner;
import org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.SegmentMissingException;
import org.apache.druid.timeline.DataSegment;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class RetryQueryRunnerTest
extends QueryRunnerBasedOnClusteredClientTestBase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testNoRetry() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = RetryQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        RetryQueryRunner<Result<TimeseriesResultValue>> queryRunner = this.createQueryRunner(RetryQueryRunnerTest.newRetryQueryRunnerConfig(1, false), query, () -> {});
        Sequence sequence = queryRunner.run(QueryPlus.wrap(query), RetryQueryRunnerTest.responseContext());
        List queryResult = sequence.toList();
        Assert.assertEquals((long)0L, (long)queryRunner.getTotalNumRetries());
        Assert.assertFalse((boolean)queryResult.isEmpty());
        Assert.assertEquals(RetryQueryRunnerTest.expectedTimeseriesResult(10), (Object)queryResult);
    }

    @Test
    public void testRetryForMovedSegment() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = RetryQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        RetryQueryRunner<Result<TimeseriesResultValue>> queryRunner = this.createQueryRunner(RetryQueryRunnerTest.newRetryQueryRunnerConfig(1, true), query, () -> this.dropSegmentFromServerAndAddNewServerForSegment((DruidServer)this.servers.get(0)));
        Sequence sequence = queryRunner.run(QueryPlus.wrap(query), RetryQueryRunnerTest.responseContext());
        List queryResult = sequence.toList();
        Assert.assertEquals((long)1L, (long)queryRunner.getTotalNumRetries());
        Assert.assertTrue((queryResult.size() == 9 || queryResult.size() == 10 ? 1 : 0) != 0);
        Assert.assertEquals(RetryQueryRunnerTest.expectedTimeseriesResult(queryResult.size()), (Object)queryResult);
    }

    @Test
    public void testRetryUntilWeGetFullResult() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = RetryQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        RetryQueryRunner<Result<TimeseriesResultValue>> queryRunner = this.createQueryRunner(RetryQueryRunnerTest.newRetryQueryRunnerConfig(100, false), query, () -> this.dropSegmentFromServerAndAddNewServerForSegment((DruidServer)this.servers.get(0)));
        Sequence sequence = queryRunner.run(QueryPlus.wrap(query), RetryQueryRunnerTest.responseContext());
        List queryResult = sequence.toList();
        Assert.assertTrue((0 < queryRunner.getTotalNumRetries() ? 1 : 0) != 0);
        Assert.assertEquals(RetryQueryRunnerTest.expectedTimeseriesResult(10), (Object)queryResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailWithPartialResultsAfterRetry() {
        this.prepareCluster(10);
        Query<Result<TimeseriesResultValue>> query = RetryQueryRunnerTest.timeseriesQuery(BASE_SCHEMA_INFO.getDataInterval());
        RetryQueryRunner<Result<TimeseriesResultValue>> queryRunner = this.createQueryRunner(RetryQueryRunnerTest.newRetryQueryRunnerConfig(1, false), query, () -> this.dropSegmentFromServer((DruidServer)this.servers.get(0)));
        Sequence sequence = queryRunner.run(QueryPlus.wrap(query), RetryQueryRunnerTest.responseContext());
        this.expectedException.expect(SegmentMissingException.class);
        this.expectedException.expectMessage("No results found for segments");
        try {
            sequence.toList();
        }
        finally {
            Assert.assertEquals((long)1L, (long)queryRunner.getTotalNumRetries());
        }
    }

    private NonnullPair<DataSegment, QueryableIndex> dropSegmentFromServer(DruidServer fromServer) {
        TestHttpClient.SimpleServerManager serverManager = this.httpClient.getServerManager(fromServer);
        Assert.assertNotNull((Object)serverManager);
        return serverManager.dropSegment();
    }

    private NonnullPair<DataSegment, QueryableIndex> unannounceSegmentFromServer(DruidServer fromServer) {
        NonnullPair<DataSegment, QueryableIndex> pair = this.dropSegmentFromServer(fromServer);
        this.simpleServerView.unannounceSegmentFromServer(fromServer, (DataSegment)pair.lhs);
        return pair;
    }

    private void dropSegmentFromServerAndAddNewServerForSegment(DruidServer fromServer) {
        NonnullPair<DataSegment, QueryableIndex> pair = this.unannounceSegmentFromServer(fromServer);
        DataSegment segmentToMove = (DataSegment)pair.lhs;
        QueryableIndex queryableIndexToMove = (QueryableIndex)pair.rhs;
        this.addServer(SimpleServerView.createServer(11), segmentToMove, queryableIndexToMove);
    }

    private <T> RetryQueryRunner<T> createQueryRunner(RetryQueryRunnerConfig retryQueryRunnerConfig, Query<T> query, Runnable runnableAfterFirstAttempt) {
        QueryRunner baseRunner = this.cachingClusteredClient.getQueryRunnerForIntervals(query, (Iterable)query.getIntervals());
        return new RetryQueryRunner(baseRunner, (arg_0, arg_1) -> ((CachingClusteredClient)this.cachingClusteredClient).getQueryRunnerForSegments(arg_0, arg_1), retryQueryRunnerConfig, this.objectMapper, runnableAfterFirstAttempt);
    }

    private static RetryQueryRunnerConfig newRetryQueryRunnerConfig(final int numTries, final boolean returnPartialResults) {
        return new RetryQueryRunnerConfig(){

            public int getNumTries() {
                return numTries;
            }

            public boolean isReturnPartialResults() {
                return returnPartialResults;
            }
        };
    }
}

