/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.handoff;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.druid.client.ImmutableSegmentLoadInfo;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifier;
import org.apache.druid.segment.handoff.CoordinatorBasedSegmentHandoffNotifierConfig;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NumberedShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.easymock.EasyMock;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class CoordinatorBasedSegmentHandoffNotifierTest {
    private final CoordinatorBasedSegmentHandoffNotifierConfig notifierConfig = new CoordinatorBasedSegmentHandoffNotifierConfig(){

        public Duration getPollDuration() {
            return Duration.millis((long)10L);
        }
    };

    @Test
    public void testHandoffCallbackNotCalled() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        SegmentDescriptor descriptor = new SegmentDescriptor(interval, "v1", 2);
        CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
        EasyMock.expect((Object)coordinatorClient.isHandOffComplete("test_ds", descriptor)).andReturn((Object)false).anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinatorClient});
        CoordinatorBasedSegmentHandoffNotifier notifier = new CoordinatorBasedSegmentHandoffNotifier("test_ds", coordinatorClient, this.notifierConfig);
        AtomicBoolean callbackCalled = new AtomicBoolean(false);
        notifier.registerSegmentHandoffCallback(descriptor, (Executor)Execs.directExecutor(), () -> callbackCalled.set(true));
        notifier.checkForSegmentHandoffs();
        Assert.assertEquals((long)1L, (long)notifier.getHandOffCallbacks().size());
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().containsKey(descriptor));
        Assert.assertFalse((boolean)callbackCalled.get());
        EasyMock.verify((Object[])new Object[]{coordinatorClient});
    }

    @Test
    public void testHandoffCallbackCalled() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        SegmentDescriptor descriptor = new SegmentDescriptor(interval, "v1", 2);
        AtomicBoolean callbackCalled = new AtomicBoolean(false);
        CoordinatorClient coordinatorClient = (CoordinatorClient)EasyMock.createMock(CoordinatorClient.class);
        EasyMock.expect((Object)coordinatorClient.isHandOffComplete("test_ds", descriptor)).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{coordinatorClient});
        CoordinatorBasedSegmentHandoffNotifier notifier = new CoordinatorBasedSegmentHandoffNotifier("test_ds", coordinatorClient, this.notifierConfig);
        notifier.registerSegmentHandoffCallback(descriptor, (Executor)Execs.directExecutor(), () -> callbackCalled.set(true));
        Assert.assertEquals((long)1L, (long)notifier.getHandOffCallbacks().size());
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().containsKey(descriptor));
        notifier.checkForSegmentHandoffs();
        Assert.assertTrue((boolean)notifier.getHandOffCallbacks().isEmpty());
        Assert.assertTrue((boolean)callbackCalled.get());
        EasyMock.verify((Object[])new Object[]{coordinatorClient});
    }

    @Test
    public void testHandoffChecksForVersion() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v2", 2)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v2", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testHandoffChecksForAssignableServer() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 2), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createRealtimeServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testHandoffChecksForPartitionNumber() {
        Interval interval = Intervals.of((String)"2011-04-01/2011-04-02");
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 1)));
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(interval, "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(interval, "v1", 2)));
    }

    @Test
    public void testHandoffChecksForInterval() {
        Assert.assertFalse((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(Intervals.of((String)"2011-04-01/2011-04-02"), "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(Intervals.of((String)"2011-04-01/2011-04-03"), "v1", 1)));
        Assert.assertTrue((boolean)CoordinatorBasedSegmentHandoffNotifier.isHandOffComplete(Collections.singletonList(new ImmutableSegmentLoadInfo(this.createSegment(Intervals.of((String)"2011-04-01/2011-04-04"), "v1", 1), (Set)Sets.newHashSet((Object[])new DruidServerMetadata[]{this.createHistoricalServerMetadata("a")}))), (SegmentDescriptor)new SegmentDescriptor(Intervals.of((String)"2011-04-02/2011-04-03"), "v1", 1)));
    }

    private DruidServerMetadata createRealtimeServerMetadata(String name) {
        return this.createServerMetadata(name, ServerType.REALTIME);
    }

    private DruidServerMetadata createHistoricalServerMetadata(String name) {
        return this.createServerMetadata(name, ServerType.HISTORICAL);
    }

    private DruidServerMetadata createServerMetadata(String name, ServerType type) {
        return new DruidServerMetadata(name, name, null, 10000L, type, "tier", 1);
    }

    private DataSegment createSegment(Interval interval, String version, int partitionNumber) {
        return new DataSegment("test_ds", interval, version, null, null, null, (ShardSpec)new NumberedShardSpec(partitionNumber, 100), Integer.valueOf(0), 0L);
    }
}

