/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.LookupDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.extraction.MapLookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactory;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainer;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.MapLookupExtractorFactory;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinTestHelper;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.LookupJoinableFactory;
import org.apache.druid.segment.join.lookup.LookupJoinable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class LookupJoinableFactoryTest {
    private static final String PREFIX = "j.";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final LookupJoinableFactory factory;
    private final LookupDataSource lookupDataSource = new LookupDataSource("country_code_to_name");

    public LookupJoinableFactoryTest() {
        try {
            final MapLookupExtractor countryIsoCodeToNameLookup = JoinTestHelper.createCountryIsoCodeToNameLookup();
            this.factory = new LookupJoinableFactory(new LookupExtractorFactoryContainerProvider(){

                public Set<String> getAllLookupNames() {
                    return ImmutableSet.of((Object)LookupJoinableFactoryTest.this.lookupDataSource.getLookupName());
                }

                public Optional<LookupExtractorFactoryContainer> get(String lookupName) {
                    if (LookupJoinableFactoryTest.this.lookupDataSource.getLookupName().equals(lookupName)) {
                        return Optional.of(new LookupExtractorFactoryContainer("v0", (LookupExtractorFactory)new MapLookupExtractorFactory(countryIsoCodeToNameLookup.getMap(), false)));
                    }
                    return Optional.empty();
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testBuildNonLookup() {
        this.expectedException.expect(ClassCastException.class);
        this.expectedException.expectMessage("TableDataSource cannot be cast");
        Optional ignored = this.factory.build((DataSource)new TableDataSource("foo"), LookupJoinableFactoryTest.makeCondition("x == \"j.k\""));
    }

    @Test
    public void testBuildNonHashJoin() {
        Assert.assertEquals(Optional.empty(), (Object)this.factory.build((DataSource)this.lookupDataSource, LookupJoinableFactoryTest.makeCondition("x > \"j.k\"")));
    }

    @Test
    public void testBuildDifferentLookup() {
        Assert.assertEquals(Optional.empty(), (Object)this.factory.build((DataSource)new LookupDataSource("beep"), LookupJoinableFactoryTest.makeCondition("x == \"j.k\"")));
    }

    @Test
    public void testBuild() {
        Joinable joinable = (Joinable)this.factory.build((DataSource)this.lookupDataSource, LookupJoinableFactoryTest.makeCondition("x == \"j.k\"")).get();
        Assert.assertThat((Object)joinable, (Matcher)CoreMatchers.instanceOf(LookupJoinable.class));
        Assert.assertEquals((Object)ImmutableList.of((Object)"k", (Object)"v"), (Object)joinable.getAvailableColumns());
        Assert.assertEquals((long)-1L, (long)joinable.getCardinality("k"));
        Assert.assertEquals((long)-1L, (long)joinable.getCardinality("v"));
    }

    @Test
    public void testIsDirectlyJoinable() {
        Assert.assertTrue((boolean)this.factory.isDirectlyJoinable((DataSource)this.lookupDataSource));
        Assert.assertFalse((boolean)this.factory.isDirectlyJoinable((DataSource)new TableDataSource("foo")));
    }

    private static JoinConditionAnalysis makeCondition(String condition) {
        return JoinConditionAnalysis.forExpression((String)condition, (String)PREFIX, (ExprMacroTable)ExprMacroTable.nil());
    }
}

