/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.segment.loading.LocalDataSegmentKiller;
import org.apache.druid.segment.loading.LocalDataSegmentPusherConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LocalDataSegmentKillerTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testKill() throws Exception {
        LocalDataSegmentKiller killer = new LocalDataSegmentKiller(new LocalDataSegmentPusherConfig());
        File dataSourceDir = this.temporaryFolder.newFolder();
        File interval1Dir = new File(dataSourceDir, "interval1");
        File version11Dir = new File(interval1Dir, "v1");
        File partition011Dir = new File(version11Dir, "0");
        File partition111Dir = new File(version11Dir, "1");
        this.makePartitionDirWithIndex(partition011Dir);
        this.makePartitionDirWithIndex(partition111Dir);
        File version21Dir = new File(interval1Dir, "v2");
        File partition021Dir = new File(version21Dir, "0");
        this.makePartitionDirWithIndex(partition021Dir);
        File interval2Dir = new File(dataSourceDir, "interval2");
        File version12Dir = new File(interval2Dir, "v1");
        File partition012Dir = new File(version12Dir, "0");
        this.makePartitionDirWithIndex(partition012Dir);
        killer.kill(this.getSegmentWithPath(new File(partition011Dir, "index.zip").toString()));
        Assert.assertFalse((boolean)partition011Dir.exists());
        Assert.assertTrue((boolean)partition111Dir.exists());
        Assert.assertTrue((boolean)partition021Dir.exists());
        Assert.assertTrue((boolean)partition012Dir.exists());
        killer.kill(this.getSegmentWithPath(new File(partition111Dir, "index.zip").toString()));
        Assert.assertFalse((boolean)version11Dir.exists());
        Assert.assertTrue((boolean)partition021Dir.exists());
        Assert.assertTrue((boolean)partition012Dir.exists());
        killer.kill(this.getSegmentWithPath(new File(partition021Dir, "index.zip").toString()));
        Assert.assertFalse((boolean)interval1Dir.exists());
        Assert.assertTrue((boolean)partition012Dir.exists());
        killer.kill(this.getSegmentWithPath(new File(partition012Dir, "index.zip").toString()));
        Assert.assertFalse((boolean)dataSourceDir.exists());
    }

    @Test
    public void testKillUniquePath() throws Exception {
        LocalDataSegmentKiller killer = new LocalDataSegmentKiller(new LocalDataSegmentPusherConfig());
        String uuid = UUID.randomUUID().toString().substring(0, 5);
        File dataSourceDir = this.temporaryFolder.newFolder("dataSource");
        File intervalDir = new File(dataSourceDir, "interval");
        File versionDir = new File(intervalDir, "1");
        File partitionDir = new File(versionDir, "0");
        File uuidDir = new File(partitionDir, uuid);
        this.makePartitionDirWithIndex(uuidDir);
        killer.kill(this.getSegmentWithPath(new File(uuidDir, "index.zip").toString()));
        Assert.assertFalse((boolean)uuidDir.exists());
        Assert.assertFalse((boolean)partitionDir.exists());
        Assert.assertFalse((boolean)versionDir.exists());
        Assert.assertFalse((boolean)intervalDir.exists());
        Assert.assertFalse((boolean)dataSourceDir.exists());
    }

    private void makePartitionDirWithIndex(File path) throws IOException {
        FileUtils.mkdirp((File)path);
        Assert.assertTrue((boolean)new File(path, "index.zip").createNewFile());
    }

    private DataSegment getSegmentWithPath(String path) {
        return new DataSegment("dataSource", Intervals.of((String)"2000/3000"), "ver", (Map)ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)path), (List)ImmutableList.of((Object)"product"), (List)ImmutableList.of((Object)"visited_sum", (Object)"unique_hosts"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(9), 12334L);
    }
}

