/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.realtime.firehose;

import com.fasterxml.jackson.databind.InjectableValues;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.apache.druid.data.input.impl.HttpInputSourceConfig;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.druid.metadata.PasswordProvider;
import org.apache.druid.segment.realtime.firehose.HttpFirehoseFactory;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class HttpFirehoseFactoryTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        HttpInputSourceConfig inputSourceConfig = new HttpInputSourceConfig(null);
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(HttpInputSourceConfig.class, (Object)inputSourceConfig));
        DefaultPasswordProvider pwProvider = new DefaultPasswordProvider("testPassword");
        HttpFirehoseFactory factory = new HttpFirehoseFactory((List)ImmutableList.of((Object)URI.create("http://foo/bar"), (Object)URI.create("http://foo/bar2")), Long.valueOf(2048L), Long.valueOf(1024L), Long.valueOf(512L), Long.valueOf(100L), Integer.valueOf(5), "testUser", (PasswordProvider)pwProvider, inputSourceConfig);
        HttpFirehoseFactory outputFact = (HttpFirehoseFactory)mapper.readValue(mapper.writeValueAsString((Object)factory), HttpFirehoseFactory.class);
        Assert.assertEquals((Object)factory, (Object)outputFact);
    }

    @Test
    public void testConstructorAllowsOnlyDefaultProtocols() {
        new HttpFirehoseFactory((List)ImmutableList.of((Object)URI.create("http:///")), null, null, null, null, null, null, null, new HttpInputSourceConfig(null));
        new HttpFirehoseFactory((List)ImmutableList.of((Object)URI.create("https:///")), null, null, null, null, null, null, null, new HttpInputSourceConfig(null));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only [http, https] protocols are allowed");
        new HttpFirehoseFactory((List)ImmutableList.of((Object)URI.create("my-protocol:///")), null, null, null, null, null, null, null, new HttpInputSourceConfig(null));
    }

    @Test
    public void testConstructorAllowsOnlyCustomProtocols() {
        HttpInputSourceConfig customConfig = new HttpInputSourceConfig((Set)ImmutableSet.of((Object)"druid"));
        new HttpFirehoseFactory((List)ImmutableList.of((Object)URI.create("druid:///")), null, null, null, null, null, null, null, customConfig);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Only [druid] protocols are allowed");
        new HttpFirehoseFactory((List)ImmutableList.of((Object)URI.create("https:///")), null, null, null, null, null, null, null, customConfig);
    }
}

