/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.guice.GuiceInjectors;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.JsonConfigurator;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.LazySequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.SequenceWrapper;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.emitter.core.Emitter;
import org.apache.druid.java.util.emitter.core.NoopEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryBuilder;
import org.apache.druid.server.ObservableQueryScheduler;
import org.apache.druid.server.QueryLaningStrategy;
import org.apache.druid.server.QueryScheduler;
import org.apache.druid.server.QuerySchedulerProvider;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryPrioritizationStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class QuerySchedulerTest {
    private static final int NUM_QUERIES = 10000;
    private static final int NUM_ROWS = 10000;
    private static final int TEST_HI_CAPACITY = 5;
    private static final int TEST_LO_CAPACITY = 2;
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private ListeningExecutorService executorService;
    private ObservableQueryScheduler scheduler;

    @Before
    public void setup() {
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Execs.multiThreaded((int)64, (String)"test_query_scheduler_%s"));
        this.scheduler = new ObservableQueryScheduler(5, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new HiLoQueryLaningStrategy(Integer.valueOf(40)), new ServerConfig());
    }

    @After
    public void teardown() {
        this.executorService.shutdownNow();
    }

    @Test
    public void testHiLoHi() throws ExecutionException, InterruptedException {
        TopNQuery interactive = this.makeInteractiveQuery();
        ListenableFuture future = this.executorService.submit(() -> {
            try {
                Query scheduled = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)interactive), (Set<SegmentServerSelector>)ImmutableSet.of());
                Assert.assertNotNull(scheduled);
                Sequence underlyingSequence = this.makeSequence(10);
                underlyingSequence = Sequences.wrap(underlyingSequence, (SequenceWrapper)new SequenceWrapper(){

                    public void before() {
                        Assert.assertEquals((long)4L, (long)QuerySchedulerTest.this.scheduler.getTotalAvailableCapacity());
                        Assert.assertEquals((long)2L, (long)QuerySchedulerTest.this.scheduler.getLaneAvailableCapacity("low"));
                    }
                });
                Sequence results = this.scheduler.run(scheduled, underlyingSequence);
                int rowCount = this.consumeAndCloseSequence(results);
                Assert.assertEquals((long)10L, (long)rowCount);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        future.get();
        Assert.assertEquals((long)5L, (long)this.scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)-1L, (long)this.scheduler.getLaneAvailableCapacity("non-existent"));
    }

    @Test
    public void testHiLoLo() throws ExecutionException, InterruptedException {
        TopNQuery report = this.makeReportQuery();
        ListenableFuture future = this.executorService.submit(() -> {
            try {
                Query scheduledReport = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)report), (Set<SegmentServerSelector>)ImmutableSet.of());
                Assert.assertNotNull(scheduledReport);
                Assert.assertEquals((Object)"low", (Object)QueryContexts.getLane(scheduledReport));
                Sequence underlyingSequence = this.makeSequence(10);
                underlyingSequence = Sequences.wrap(underlyingSequence, (SequenceWrapper)new SequenceWrapper(){

                    public void before() {
                        Assert.assertEquals((long)4L, (long)QuerySchedulerTest.this.scheduler.getTotalAvailableCapacity());
                        Assert.assertEquals((long)1L, (long)QuerySchedulerTest.this.scheduler.getLaneAvailableCapacity("low"));
                    }
                });
                Sequence results = this.scheduler.run(scheduledReport, underlyingSequence);
                int rowCount = this.consumeAndCloseSequence(results);
                Assert.assertEquals((long)10L, (long)rowCount);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        future.get();
        this.assertHiLoHasAllCapacity(5, 2);
        Assert.assertEquals((long)-1L, (long)this.scheduler.getLaneAvailableCapacity("non-existent"));
    }

    @Test
    public void testHiLoReleaseLaneWhenSequenceExplodes() throws Exception {
        this.expected.expectMessage("exploded");
        this.expected.expect(ExecutionException.class);
        TopNQuery interactive = this.makeInteractiveQuery();
        ListenableFuture future = this.executorService.submit(() -> {
            try {
                Query scheduled = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)interactive), (Set<SegmentServerSelector>)ImmutableSet.of());
                Assert.assertNotNull(scheduled);
                Sequence underlyingSequence = this.makeExplodingSequence(10);
                underlyingSequence = Sequences.wrap(underlyingSequence, (SequenceWrapper)new SequenceWrapper(){

                    public void before() {
                        Assert.assertEquals((long)4L, (long)QuerySchedulerTest.this.scheduler.getTotalAvailableCapacity());
                    }
                });
                Sequence results = this.scheduler.run(scheduled, underlyingSequence);
                this.consumeAndCloseSequence(results);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
        future.get();
    }

    @Test
    public void testHiLoFailsWhenOutOfLaneCapacity() {
        this.expected.expectMessage(QueryCapacityExceededException.makeLaneErrorMessage((String)"low", (int)2));
        this.expected.expect(QueryCapacityExceededException.class);
        Query report1 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeReportQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(report1, Sequences.empty());
        Assert.assertNotNull(report1);
        Assert.assertEquals((long)4L, (long)this.scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)1L, (long)this.scheduler.getLaneAvailableCapacity("low"));
        Query report2 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeReportQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(report2, Sequences.empty());
        Assert.assertNotNull(report2);
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)0L, (long)this.scheduler.getLaneAvailableCapacity("low"));
        this.scheduler.run(this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeReportQuery()), (Set<SegmentServerSelector>)ImmutableSet.of()), Sequences.empty());
    }

    @Test
    public void testHiLoFailsWhenOutOfTotalCapacity() {
        this.expected.expectMessage(QueryCapacityExceededException.makeTotalErrorMessage((int)5));
        this.expected.expect(QueryCapacityExceededException.class);
        Query interactive1 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeInteractiveQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(interactive1, Sequences.empty());
        Assert.assertNotNull(interactive1);
        Assert.assertEquals((long)4L, (long)this.scheduler.getTotalAvailableCapacity());
        Query report1 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeReportQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(report1, Sequences.empty());
        Assert.assertNotNull(report1);
        Assert.assertEquals((long)3L, (long)this.scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)1L, (long)this.scheduler.getLaneAvailableCapacity("low"));
        Query interactive2 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeInteractiveQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(interactive2, Sequences.empty());
        Assert.assertNotNull(interactive2);
        Assert.assertEquals((long)2L, (long)this.scheduler.getTotalAvailableCapacity());
        Query report2 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeReportQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(report2, Sequences.empty());
        Assert.assertNotNull(report2);
        Assert.assertEquals((long)1L, (long)this.scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)0L, (long)this.scheduler.getLaneAvailableCapacity("low"));
        Query interactive3 = this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeInteractiveQuery()), (Set<SegmentServerSelector>)ImmutableSet.of());
        this.scheduler.run(interactive3, Sequences.empty());
        Assert.assertNotNull(interactive3);
        Assert.assertEquals((long)0L, (long)this.scheduler.getTotalAvailableCapacity());
        this.scheduler.run(this.scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeInteractiveQuery()), (Set<SegmentServerSelector>)ImmutableSet.of()), Sequences.empty());
    }

    @Test
    public void testConcurrency() throws Exception {
        ArrayList futures = new ArrayList(10000);
        for (int i = 0; i < 10000; ++i) {
            futures.add((Future<?>)this.makeQueryFuture(this.executorService, this.scheduler, (Query<?>)this.makeRandomQuery(), 10000));
            this.maybeDelayNextIteration(i);
        }
        this.getFuturesAndAssertAftermathIsChill(futures, this.scheduler, false, false);
        this.assertHiLoHasAllCapacity(5, 2);
    }

    @Test
    public void testConcurrencyLo() throws Exception {
        ArrayList futures = new ArrayList(10000);
        for (int i = 0; i < 10000; ++i) {
            futures.add((Future<?>)this.makeQueryFuture(this.executorService, this.scheduler, (Query<?>)this.makeReportQuery(), 10000));
            this.maybeDelayNextIteration(i);
        }
        this.getFuturesAndAssertAftermathIsChill(futures, this.scheduler, false, false);
        this.assertHiLoHasAllCapacity(5, 2);
    }

    @Test
    public void testConcurrencyHi() throws Exception {
        ArrayList futures = new ArrayList(10000);
        for (int i = 0; i < 10000; ++i) {
            futures.add((Future<?>)this.makeQueryFuture(this.executorService, this.scheduler, (Query<?>)this.makeInteractiveQuery(), 10000));
            this.maybeDelayNextIteration(i);
        }
        this.getFuturesAndAssertAftermathIsChill(futures, this.scheduler, true, false);
        this.assertHiLoHasAllCapacity(5, 2);
    }

    @Test
    public void testNotLimitedByDefaultLimiterIfNoTotalIsSet() {
        this.scheduler = new ObservableQueryScheduler(0, ManualQueryPrioritizationStrategy.INSTANCE, (QueryLaningStrategy)new NoQueryLaningStrategy(), new ServerConfig());
        ArrayList futures = new ArrayList(10000);
        for (int i = 0; i < 10000; ++i) {
            futures.add((Future<?>)this.makeQueryFuture(this.executorService, this.scheduler, (Query<?>)this.makeInteractiveQuery(), 10000));
        }
        this.getFuturesAndAssertAftermathIsChill(futures, this.scheduler, true, true);
    }

    @Test
    public void testConfigNone() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.setProperty("druid.query.scheduler.numThreads", "10");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)-1L, (long)scheduler.getLaneAvailableCapacity("low"));
        Assert.assertEquals((long)-1L, (long)scheduler.getLaneAvailableCapacity("non-existent"));
    }

    @Test
    public void testConfigHiLo() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.setProperty("druid.query.scheduler.numThreads", "10");
        properties.setProperty("druid.query.scheduler.laning.strategy", "hilo");
        properties.setProperty("druid.query.scheduler.laning.maxLowPercent", "20");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)2L, (long)scheduler.getLaneAvailableCapacity("low"));
        Assert.assertEquals((long)-1L, (long)scheduler.getLaneAvailableCapacity("non-existent"));
    }

    @Test
    public void testMisConfigHiLo() {
        this.expected.expect(ProvisionException.class);
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.setProperty("druid.query.scheduler.laning.strategy", "hilo");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)2L, (long)scheduler.getLaneAvailableCapacity("low"));
    }

    @Test
    public void testConfigHiLoWithThreshold() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.setProperty("druid.query.scheduler.numThreads", "10");
        properties.setProperty("druid.query.scheduler.laning.strategy", "hilo");
        properties.setProperty("druid.query.scheduler.laning.maxLowPercent", "20");
        properties.setProperty("druid.query.scheduler.prioritization.strategy", "threshold");
        properties.setProperty("druid.query.scheduler.prioritization.adjustment", "5");
        properties.setProperty("druid.query.scheduler.prioritization.segmentCountThreshold", "1");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)2L, (long)scheduler.getLaneAvailableCapacity("low"));
        Assert.assertEquals((long)-1L, (long)scheduler.getLaneAvailableCapacity("non-existent"));
        Query query = scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)this.makeDefaultQuery()), (Set)ImmutableSet.of((Object)EasyMock.createMock(SegmentServerSelector.class), (Object)EasyMock.createMock(SegmentServerSelector.class)));
        Assert.assertEquals((long)-5L, (long)QueryContexts.getPriority((Query)query));
        Assert.assertEquals((Object)"low", (Object)QueryContexts.getLane((Query)query));
    }

    @Test
    public void testMisConfigThreshold() {
        this.expected.expect(ProvisionException.class);
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.setProperty("druid.query.scheduler.prioritization.strategy", "threshold");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)2L, (long)scheduler.getLaneAvailableCapacity("low"));
    }

    @Test
    public void testConfigManual() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.put("druid.query.scheduler.numThreads", "10");
        properties.put("druid.query.scheduler.laning.strategy", "manual");
        properties.put("druid.query.scheduler.laning.lanes.one", "1");
        properties.put("druid.query.scheduler.laning.lanes.two", "2");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)1L, (long)scheduler.getLaneAvailableCapacity("one"));
        Assert.assertEquals((long)2L, (long)scheduler.getLaneAvailableCapacity("two"));
        Assert.assertEquals((long)-1L, (long)scheduler.getLaneAvailableCapacity("non-existent"));
    }

    @Test
    public void testConfigManualPercent() {
        Injector injector = this.createInjector();
        String propertyPrefix = "druid.query.scheduler";
        JsonConfigProvider provider = JsonConfigProvider.of((String)"druid.query.scheduler", QuerySchedulerProvider.class);
        Properties properties = new Properties();
        properties.put("druid.query.scheduler.numThreads", "10");
        properties.put("druid.query.scheduler.laning.strategy", "manual");
        properties.put("druid.query.scheduler.laning.isLimitPercent", "true");
        properties.put("druid.query.scheduler.laning.lanes.one", "1");
        properties.put("druid.query.scheduler.laning.lanes.twenty", "20");
        provider.inject(properties, (JsonConfigurator)injector.getInstance(JsonConfigurator.class));
        QueryScheduler scheduler = ((QuerySchedulerProvider)provider.get().get()).get();
        Assert.assertEquals((long)10L, (long)scheduler.getTotalAvailableCapacity());
        Assert.assertEquals((long)1L, (long)scheduler.getLaneAvailableCapacity("one"));
        Assert.assertEquals((long)2L, (long)scheduler.getLaneAvailableCapacity("twenty"));
        Assert.assertEquals((long)-1L, (long)scheduler.getLaneAvailableCapacity("non-existent"));
    }

    private void maybeDelayNextIteration(int i) throws InterruptedException {
        if (i > 0 && i % 10 == 0) {
            Thread.sleep(2L);
        }
    }

    private TopNQuery makeRandomQuery() {
        return ThreadLocalRandom.current().nextBoolean() ? this.makeInteractiveQuery() : this.makeReportQuery();
    }

    private TopNQuery makeDefaultQuery() {
        return this.makeBaseBuilder().context((Map)ImmutableMap.of((Object)"queryId", (Object)("default-" + UUID.randomUUID()))).build();
    }

    private TopNQuery makeInteractiveQuery() {
        return this.makeBaseBuilder().context((Map)ImmutableMap.of((Object)"priority", (Object)10, (Object)"queryId", (Object)("high-" + UUID.randomUUID()))).build();
    }

    private TopNQuery makeReportQuery() {
        return this.makeBaseBuilder().context((Map)ImmutableMap.of((Object)"priority", (Object)-1, (Object)"queryId", (Object)("low-" + UUID.randomUUID()))).build();
    }

    private TopNQueryBuilder makeBaseBuilder() {
        return new TopNQueryBuilder().dataSource("foo").intervals("2020-01-01/2020-01-02").dimension("bar").metric("chocula").aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).threshold(10);
    }

    private <T> int consumeAndCloseSequence(Sequence<T> sequence) throws IOException {
        Yielder yielder = Yielders.each(sequence);
        int rowCount = 0;
        while (!yielder.isDone()) {
            ++rowCount;
            yielder = yielder.next(yielder.get());
        }
        yielder.close();
        return rowCount;
    }

    private Sequence<Integer> makeSequence(final int count) {
        return new LazySequence(() -> new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return new Iterator<Integer>(){
                    int rowCounter = 0;

                    @Override
                    public boolean hasNext() {
                        return this.rowCounter < count;
                    }

                    @Override
                    public Integer next() {
                        ++this.rowCounter;
                        return this.rowCounter;
                    }
                };
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
            }
        }));
    }

    private Sequence<Integer> makeExplodingSequence(final int explodeAfter) {
        final int explodeAt = explodeAfter + 1;
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Integer, Iterator<Integer>>(){

            public Iterator<Integer> make() {
                return new Iterator<Integer>(){
                    int rowCounter = 0;

                    @Override
                    public boolean hasNext() {
                        return this.rowCounter < explodeAt;
                    }

                    @Override
                    public Integer next() {
                        if (this.rowCounter == explodeAfter) {
                            throw new RuntimeException("exploded");
                        }
                        ++this.rowCounter;
                        return this.rowCounter;
                    }
                };
            }

            public void cleanup(Iterator<Integer> iterFromMake) {
            }
        });
    }

    private ListenableFuture<?> makeQueryFuture(ListeningExecutorService executorService, QueryScheduler scheduler, Query<?> query, int numRows) {
        return executorService.submit(() -> {
            try {
                Query scheduled = scheduler.prioritizeAndLaneQuery(QueryPlus.wrap((Query)query), (Set)ImmutableSet.of());
                Assert.assertNotNull((Object)scheduled);
                Sequence<Integer> underlyingSequence = this.makeSequence(numRows);
                Sequence results = scheduler.run(scheduled, underlyingSequence);
                int actualNumRows = this.consumeAndCloseSequence(results);
                Assert.assertEquals((long)actualNumRows, (long)numRows);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    private void getFuturesAndAssertAftermathIsChill(List<Future<?>> futures, ObservableQueryScheduler scheduler, boolean successEqualsTotal, boolean expectNoneLimited) {
        int success = 0;
        int denied = 0;
        int other = 0;
        for (Future<?> f : futures) {
            try {
                f.get();
                ++success;
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof QueryCapacityExceededException) {
                    ++denied;
                    continue;
                }
                ++other;
            }
            catch (Exception ex) {
                ++other;
            }
        }
        Assert.assertEquals((long)0L, (long)other);
        if (expectNoneLimited) {
            Assert.assertEquals((long)0L, (long)denied);
            Assert.assertEquals((long)10000L, (long)success);
            Assert.assertEquals((long)0L, (long)scheduler.getTotalAcquired().get());
            Assert.assertEquals((long)0L, (long)scheduler.getLaneAcquired().get());
        } else {
            Assert.assertTrue((denied > 0 ? 1 : 0) != 0);
            if (successEqualsTotal) {
                Assert.assertEquals((long)success, (long)scheduler.getTotalAcquired().get());
            } else {
                Assert.assertTrue((success > 0 && (long)success <= scheduler.getTotalAcquired().get() ? 1 : 0) != 0);
            }
            Assert.assertEquals((long)scheduler.getTotalReleased().get(), (long)scheduler.getTotalAcquired().get());
            Assert.assertEquals((long)scheduler.getLaneReleased().get(), (long)(scheduler.getLaneAcquired().get() + scheduler.getLaneNotAcquired().get()));
        }
    }

    private void assertHiLoHasAllCapacity(int hi, int lo) {
        Assert.assertEquals((long)lo, (long)this.scheduler.getLaneAvailableCapacity("low"));
        Assert.assertEquals((long)hi, (long)this.scheduler.getTotalAvailableCapacity());
    }

    private Injector createInjector() {
        Injector injector = GuiceInjectors.makeStartupInjectorWithModules((Iterable)ImmutableList.of(binder -> {
            binder.bind(ServerConfig.class).toInstance((Object)new ServerConfig());
            binder.bind(ServiceEmitter.class).toInstance((Object)new ServiceEmitter("test", "localhost", (Emitter)new NoopEmitter()));
            JsonConfigProvider.bind((Binder)binder, (String)"druid.query.scheduler", QuerySchedulerProvider.class, Global.class);
        }));
        ObjectMapper mapper = (ObjectMapper)injector.getInstance(Key.get(ObjectMapper.class, Json.class));
        mapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(ServerConfig.class, injector.getInstance(ServerConfig.class)).addValue(ServiceEmitter.class, injector.getInstance(ServiceEmitter.class)));
        return injector;
    }
}

