/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.coordination.ServerType;
import org.apache.druid.server.coordinator.DruidCluster;
import org.apache.druid.server.coordinator.DruidClusterBuilder;
import org.apache.druid.server.coordinator.LoadQueuePeon;
import org.apache.druid.server.coordinator.LoadQueuePeonTester;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.druid.timeline.partition.ShardSpec;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DruidClusterTest {
    private static final List<DataSegment> SEGMENTS = ImmutableList.of((Object)new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"containerName", (Object)"container1", (Object)"blobPath", (Object)"blobPath1"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L), (Object)new DataSegment("test", Intervals.of((String)"2015-04-12/2015-04-13"), "1", (Map)ImmutableMap.of((Object)"containerName", (Object)"container2", (Object)"blobPath", (Object)"blobPath2"), null, null, (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(0), 1L));
    private static final Map<String, ImmutableDruidDataSource> DATA_SOURCES = ImmutableMap.of((Object)"src1", (Object)new ImmutableDruidDataSource("src1", Collections.emptyMap(), Collections.singletonList(SEGMENTS.get(0))), (Object)"src2", (Object)new ImmutableDruidDataSource("src2", Collections.emptyMap(), Collections.singletonList(SEGMENTS.get(0))));
    private static final ServerHolder NEW_REALTIME = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host2", null, 100L, ServerType.REALTIME, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new LoadQueuePeonTester());
    private static final ServerHolder NEW_HISTORICAL = new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host2", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new LoadQueuePeonTester());
    private DruidCluster cluster;

    @Before
    public void setup() {
        this.cluster = DruidClusterBuilder.newBuilder().withRealtimes(new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.REALTIME, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new LoadQueuePeonTester())).addTier("tier1", new ServerHolder(new ImmutableDruidServer(new DruidServerMetadata("name1", "host1", null, 100L, ServerType.HISTORICAL, "tier1", 0), 0L, ImmutableMap.of((Object)"src1", (Object)DATA_SOURCES.get("src1")), 1), (LoadQueuePeon)new LoadQueuePeonTester())).build();
    }

    @Test
    public void testAdd() {
        Assert.assertEquals((long)1L, (long)this.cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)1L, (long)this.cluster.getRealtimes().size());
        this.cluster.add(NEW_REALTIME);
        Assert.assertEquals((long)1L, (long)this.cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)2L, (long)this.cluster.getRealtimes().size());
        this.cluster.add(NEW_HISTORICAL);
        Assert.assertEquals((long)2L, (long)this.cluster.getHistoricals().values().stream().mapToInt(Collection::size).sum());
        Assert.assertEquals((long)2L, (long)this.cluster.getRealtimes().size());
    }

    @Test
    public void testGetAllServers() {
        this.cluster.add(NEW_REALTIME);
        this.cluster.add(NEW_HISTORICAL);
        Set expectedRealtimes = this.cluster.getRealtimes();
        Map expectedHistoricals = this.cluster.getHistoricals();
        Collection allServers = this.cluster.getAllServers();
        Assert.assertEquals((long)4L, (long)allServers.size());
        Assert.assertTrue((boolean)allServers.containsAll(this.cluster.getRealtimes()));
        Assert.assertTrue((boolean)allServers.containsAll(this.cluster.getHistoricals().values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
        Assert.assertEquals((Object)expectedHistoricals, (Object)this.cluster.getHistoricals());
        Assert.assertEquals((Object)expectedRealtimes, (Object)this.cluster.getRealtimes());
    }

    @Test
    public void testIsEmpty() {
        DruidCluster emptyCluster = new DruidCluster();
        Assert.assertFalse((boolean)this.cluster.isEmpty());
        Assert.assertTrue((boolean)emptyCluster.isEmpty());
    }
}

